/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.helper;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.io.DocumentMetadataHandle;
import com.marklogic.client.io.SearchHandle;
import com.marklogic.client.io.marker.DocumentMetadataReadHandle;
import com.marklogic.client.io.marker.SearchReadHandle;
import com.marklogic.client.query.MatchDocumentSummary;
import com.marklogic.client.query.QueryDefinition;
import com.marklogic.client.query.QueryManager;
import com.marklogic.client.query.StringQueryDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClientHelper
extends LoggingObject {
    private DatabaseClient client;

    public ClientHelper(DatabaseClient client) {
        this.client = client;
    }

    public DatabaseClient getClient() {
        return this.client;
    }

    public DocumentMetadataHandle getMetadata(String uri) {
        return (DocumentMetadataHandle)this.client.newDocumentManager().readMetadata(uri, (DocumentMetadataReadHandle)new DocumentMetadataHandle());
    }

    public List<String> getCollections(String uri) {
        DocumentMetadataHandle.DocumentCollections colls = this.getMetadata(uri).getCollections();
        return Arrays.asList((String[])colls.toArray((Object[])new String[0]));
    }

    public long getCollectionSize(String collectionName) {
        QueryManager queryMgr = this.getClient().newQueryManager();
        StringQueryDefinition def = queryMgr.newStringDefinition();
        def.setCollections(new String[]{collectionName});
        SearchHandle sh = (SearchHandle)queryMgr.search((QueryDefinition)def, (SearchReadHandle)new SearchHandle());
        return sh.getTotalResults();
    }

    public List<String> getUrisInCollection(String collectionName) {
        return this.getUrisInCollection(collectionName, 10);
    }

    public List<String> getUrisInCollection(String collectionName, int pageLength) {
        QueryManager mgr = this.getClient().newQueryManager();
        mgr.setPageLength((long)pageLength);
        StringQueryDefinition def = mgr.newStringDefinition();
        def.setCollections(new String[]{collectionName});
        SearchHandle h = (SearchHandle)mgr.search((QueryDefinition)def, (SearchReadHandle)new SearchHandle());
        ArrayList<String> uris = new ArrayList<String>();
        for (MatchDocumentSummary s : h.getMatchResults()) {
            uris.add(s.getUri());
        }
        return uris;
    }

    public String eval(String expr) {
        return (String)this.getClient().newServerEval().xquery(expr).evalAs(String.class);
    }
}

