/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.file;

import com.marklogic.client.ext.file.AbstractDocumentFileReader;
import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.DocumentFileReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class JarDocumentFileReader
extends AbstractDocumentFileReader
implements DocumentFileReader {
    private ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    private List<FilenameFilter> filenameFilters = new ArrayList<FilenameFilter>();
    private String uriPrefix = "/";
    private String resourcePattern = "**/*";

    @Override
    public List<DocumentFile> readDocumentFiles(String ... paths) {
        ArrayList<DocumentFile> documentFiles = new ArrayList<DocumentFile>();
        for (String path : paths) {
            this.findResources(path, this.resourcePattern).stream().forEach(resource -> {
                DocumentFile documentFile = this.buildDocumentFile(path, (Resource)resource);
                if (documentFile != null && (documentFile = this.processDocumentFile(documentFile)) != null) {
                    documentFiles.add(documentFile);
                }
            });
        }
        return documentFiles;
    }

    protected List<Resource> findResources(String basePath, String ... paths) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (String path : paths) {
            try {
                Resource[] resources;
                Object finalPath = basePath;
                if (!((String)finalPath).endsWith("/") && !path.startsWith("/")) {
                    finalPath = (String)finalPath + "/";
                }
                finalPath = (String)finalPath + path;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Finding resources in path: " + (String)finalPath);
                }
                for (Resource r : resources = this.resolver.getResources((String)finalPath)) {
                    if (!this.canReadResource(r)) continue;
                    list.add(r);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to find resources at path: " + path, e);
            }
        }
        return list;
    }

    protected boolean canReadResource(Resource r) {
        if (r == null) {
            return false;
        }
        String filename = r.getFilename();
        if (filename == null) {
            return false;
        }
        boolean canRead = true;
        if (this.filenameFilters != null) {
            for (FilenameFilter filter : this.filenameFilters) {
                if (filter.accept(null, filename)) continue;
                canRead = false;
                break;
            }
        }
        return canRead;
    }

    public void addFilenameFilter(FilenameFilter filenameFilter) {
        if (this.filenameFilters == null) {
            this.filenameFilters = new ArrayList<FilenameFilter>();
        }
        this.filenameFilters.add(filenameFilter);
    }

    protected DocumentFile buildDocumentFile(String rootPath, Resource resource) {
        try {
            Object uri = resource.getURI().toString().replaceAll(Pattern.quote(rootPath), "");
            if (this.uriPrefix != null) {
                uri = this.uriPrefix + (String)uri;
            }
            File f = null;
            try {
                f = resource.getFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!(((String)uri).endsWith("/") || f != null && f.isDirectory())) {
                DocumentFile df = new DocumentFile((String)uri, resource);
                return df;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public void setUriPrefix(String uriPrefix) {
        this.uriPrefix = uriPrefix;
    }

    public void setResourcePattern(String resourcePattern) {
        this.resourcePattern = resourcePattern;
    }

    public List<FilenameFilter> getFilenameFilters() {
        return this.filenameFilters;
    }

    public void setFilenameFilters(List<FilenameFilter> filenameFilters) {
        this.filenameFilters = filenameFilters;
    }
}

