/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.file;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.batch.BatchWriter;
import com.marklogic.client.ext.batch.RestBatchWriter;
import com.marklogic.client.ext.file.AbstractDocumentFileReader;
import com.marklogic.client.ext.file.CollectionsDocumentFileProcessor;
import com.marklogic.client.ext.file.CollectionsFileDocumentFileProcessor;
import com.marklogic.client.ext.file.DefaultDocumentFileReader;
import com.marklogic.client.ext.file.DefaultDocumentFormatGetter;
import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.file.DocumentFileReader;
import com.marklogic.client.ext.file.FileLoader;
import com.marklogic.client.ext.file.FormatDocumentFileProcessor;
import com.marklogic.client.ext.file.FormatGetter;
import com.marklogic.client.ext.file.PermissionsDocumentFileProcessor;
import com.marklogic.client.ext.file.PermissionsFileDocumentFileProcessor;
import com.marklogic.client.ext.file.TokenReplacerDocumentFileProcessor;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.tokenreplacer.TokenReplacer;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class GenericFileLoader
extends LoggingObject
implements FileLoader {
    private DocumentFileReader documentFileReader;
    private BatchWriter batchWriter;
    private boolean waitForCompletion = true;
    private boolean logFileUris = true;
    private Integer batchSize;
    private List<FileFilter> fileFilters;
    private List<DocumentFileProcessor> documentFileProcessors;
    private String permissions;
    private String[] collections;
    private TokenReplacer tokenReplacer;
    private String[] additionalBinaryExtensions;

    public GenericFileLoader(DatabaseClient client) {
        RestBatchWriter restBatchWriter = new RestBatchWriter(client);
        restBatchWriter.setReleaseDatabaseClients(false);
        this.batchWriter = restBatchWriter;
    }

    public GenericFileLoader(BatchWriter batchWriter) {
        this.batchWriter = batchWriter;
    }

    @Override
    public List<DocumentFile> loadFiles(String ... paths) {
        this.batchWriter.initialize();
        this.initializeDocumentFileReader();
        List<DocumentFile> documentFiles = this.documentFileReader.readDocumentFiles(paths);
        if (documentFiles != null && !documentFiles.isEmpty()) {
            this.writeBatchOfDocuments(documentFiles, 0);
            if (this.waitForCompletion) {
                this.batchWriter.waitForCompletion();
            }
        }
        return documentFiles;
    }

    protected void writeBatchOfDocuments(List<DocumentFile> documentFiles, int startPosition) {
        List<DocumentFile> batch;
        int endPosition;
        int documentFilesSize = documentFiles.size();
        if (startPosition >= documentFilesSize) {
            return;
        }
        if (this.batchSize != null && this.batchSize < 1) {
            this.batchSize = null;
        }
        int n = endPosition = this.batchSize == null ? documentFilesSize : startPosition + this.batchSize;
        if (endPosition > documentFilesSize) {
            endPosition = documentFilesSize;
        }
        if (!(batch = documentFiles.subList(startPosition, endPosition)).isEmpty()) {
            boolean infoEnabled = this.logger.isInfoEnabled();
            if (infoEnabled) {
                this.logger.info(this.format("Writing %d files", batch.size()));
            }
            List documentWriteOperations = batch.stream().map(file -> {
                if (this.logFileUris && infoEnabled) {
                    String uri = file.getUri();
                    this.logger.info("Writing: " + uri != null ? uri : file.getTemporalDocumentURI());
                }
                return file.toDocumentWriteOperation();
            }).collect(Collectors.toList());
            this.batchWriter.write(documentWriteOperations);
        }
        if (endPosition < documentFilesSize) {
            this.writeBatchOfDocuments(documentFiles, endPosition);
        }
    }

    public void initializeDocumentFileReader() {
        if (this.documentFileReader == null) {
            DefaultDocumentFileReader reader = new DefaultDocumentFileReader();
            if (this.fileFilters != null) {
                for (FileFilter filter : this.fileFilters) {
                    reader.addFileFilter(filter);
                }
            }
            this.prepareAbstractDocumentFileReader(reader);
            this.documentFileReader = reader;
        }
    }

    public void prepareAbstractDocumentFileReader(AbstractDocumentFileReader reader) {
        for (DocumentFileProcessor processor : this.buildDocumentFileProcessors()) {
            reader.addDocumentFileProcessor(processor);
        }
        this.applyTokenReplacerOnKnownDocumentProcessors(reader);
        if (this.additionalBinaryExtensions != null) {
            FormatDocumentFileProcessor processor = reader.getFormatDocumentFileProcessor();
            FormatGetter formatGetter = processor.getFormatGetter();
            if (formatGetter instanceof DefaultDocumentFormatGetter) {
                DefaultDocumentFormatGetter ddfg = (DefaultDocumentFormatGetter)formatGetter;
                for (String ext : this.additionalBinaryExtensions) {
                    ddfg.getBinaryExtensions().add(ext);
                }
            } else {
                this.logger.warn("FormatGetter is not an instanceof DefaultDocumentFormatGetter, so unable to add additionalBinaryExtensions: " + Arrays.asList(this.additionalBinaryExtensions));
            }
        }
    }

    protected void applyTokenReplacerOnKnownDocumentProcessors(AbstractDocumentFileReader reader) {
        if (reader instanceof DefaultDocumentFileReader && this.tokenReplacer != null) {
            PermissionsFileDocumentFileProcessor pp;
            DefaultDocumentFileReader defaultReader = (DefaultDocumentFileReader)reader;
            CollectionsFileDocumentFileProcessor cp = defaultReader.getCollectionsFileDocumentFileProcessor();
            if (cp != null) {
                cp.setTokenReplacer(this.tokenReplacer);
            }
            if ((pp = defaultReader.getPermissionsFileDocumentFileProcessor()) != null) {
                pp.setTokenReplacer(this.tokenReplacer);
            }
        }
    }

    protected List<DocumentFileProcessor> buildDocumentFileProcessors() {
        ArrayList<DocumentFileProcessor> processors = new ArrayList<DocumentFileProcessor>();
        if (this.permissions != null) {
            processors.add(new PermissionsDocumentFileProcessor(this.permissions));
        }
        if (this.collections != null) {
            processors.add(new CollectionsDocumentFileProcessor(this.collections));
        }
        if (this.tokenReplacer != null) {
            processors.add(new TokenReplacerDocumentFileProcessor(this.tokenReplacer));
        }
        if (this.documentFileProcessors != null) {
            for (DocumentFileProcessor dfp : this.documentFileProcessors) {
                processors.add(dfp);
            }
        }
        return processors;
    }

    public void addFileFilter(FileFilter fileFilter) {
        if (this.fileFilters == null) {
            this.fileFilters = new ArrayList<FileFilter>();
        }
        this.fileFilters.add(fileFilter);
    }

    public void addDocumentFileProcessor(DocumentFileProcessor processor) {
        if (this.documentFileProcessors == null) {
            this.documentFileProcessors = new ArrayList<DocumentFileProcessor>();
        }
        this.documentFileProcessors.add(processor);
    }

    public void setWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    public void setDocumentFileReader(DocumentFileReader documentFileReader) {
        this.documentFileReader = documentFileReader;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public void setCollections(String ... collections) {
        this.collections = collections;
    }

    public void setTokenReplacer(TokenReplacer tokenReplacer) {
        this.tokenReplacer = tokenReplacer;
    }

    public void setFileFilters(List<FileFilter> fileFilters) {
        this.fileFilters = fileFilters;
    }

    public void setDocumentFileProcessors(List<DocumentFileProcessor> documentFileProcessors) {
        this.documentFileProcessors = documentFileProcessors;
    }

    public void setAdditionalBinaryExtensions(String ... additionalBinaryExtensions) {
        this.additionalBinaryExtensions = additionalBinaryExtensions;
    }

    public boolean isLogFileUris() {
        return this.logFileUris;
    }

    public void setLogFileUris(boolean logFileUris) {
        this.logFileUris = logFileUris;
    }

    public DocumentFileReader getDocumentFileReader() {
        return this.documentFileReader;
    }

    public BatchWriter getBatchWriter() {
        return this.batchWriter;
    }

    public TokenReplacer getTokenReplacer() {
        return this.tokenReplacer;
    }

    public List<FileFilter> getFileFilters() {
        return this.fileFilters;
    }

    public List<DocumentFileProcessor> getDocumentFileProcessors() {
        return this.documentFileProcessors;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setBatchWriter(BatchWriter batchWriter) {
        this.batchWriter = batchWriter;
    }
}

