/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.file;

import com.marklogic.client.ext.file.DefaultDocumentFormatGetter;
import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.file.FormatGetter;
import com.marklogic.client.io.Format;

public class FormatDocumentFileProcessor
implements DocumentFileProcessor {
    private FormatGetter formatGetter;

    public FormatDocumentFileProcessor() {
        this(new DefaultDocumentFormatGetter());
    }

    public FormatDocumentFileProcessor(FormatGetter formatGetter) {
        this.formatGetter = formatGetter;
    }

    @Override
    public DocumentFile processDocumentFile(DocumentFile documentFile) {
        Format format = this.formatGetter.getFormat(documentFile.getResource());
        if (format != null) {
            documentFile.setFormat(format);
        }
        return documentFile;
    }

    public FormatGetter getFormatGetter() {
        return this.formatGetter;
    }

    public void setFormatGetter(FormatGetter formatGetter) {
        this.formatGetter = formatGetter;
    }
}

