/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.file;

import com.marklogic.client.ext.file.FormatGetter;
import com.marklogic.client.ext.util.BinaryExtensions;
import com.marklogic.client.io.Format;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.Resource;

public class DefaultDocumentFormatGetter
implements FormatGetter {
    public static final String[] DEFAULT_BINARY_EXTENSIONS = BinaryExtensions.EXTENSIONS;
    public static final String[] DEFAULT_XML_EXTENSIONS = new String[]{"xml", "xsl", "xslt", "xsd", "tdex"};
    public static final String[] DEFAULT_JSON_EXTENSIONS = new String[]{"json", "tdej"};
    private List<String> binaryExtensions = new ArrayList<String>();
    private List<String> xmlExtensions = new ArrayList<String>();
    private List<String> jsonExtensions = new ArrayList<String>();

    public DefaultDocumentFormatGetter() {
        for (String ext : DEFAULT_BINARY_EXTENSIONS) {
            this.binaryExtensions.add(ext);
        }
        for (String ext : DEFAULT_XML_EXTENSIONS) {
            this.xmlExtensions.add(ext);
        }
        for (String ext : DEFAULT_JSON_EXTENSIONS) {
            this.jsonExtensions.add(ext);
        }
    }

    @Override
    public Format getFormat(Resource resource) {
        String name = resource.getFilename();
        for (String ext : this.xmlExtensions) {
            if (!name.endsWith(ext)) continue;
            return Format.XML;
        }
        for (String ext : this.jsonExtensions) {
            if (!name.endsWith(ext)) continue;
            return Format.JSON;
        }
        boolean isBinary = false;
        for (String ext : this.binaryExtensions) {
            if (!name.endsWith(ext)) continue;
            isBinary = true;
            break;
        }
        return isBinary ? Format.BINARY : Format.TEXT;
    }

    public List<String> getBinaryExtensions() {
        return this.binaryExtensions;
    }

    public void setBinaryExtensions(List<String> binaryExtensions) {
        this.binaryExtensions = binaryExtensions;
    }

    public List<String> getXmlExtensions() {
        return this.xmlExtensions;
    }

    public void setXmlExtensions(List<String> xmlExtensions) {
        this.xmlExtensions = xmlExtensions;
    }

    public List<String> getJsonExtensions() {
        return this.jsonExtensions;
    }

    public void setJsonExtensions(List<String> jsonExtensions) {
        this.jsonExtensions = jsonExtensions;
    }
}

