/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.rest.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.command.ResourceReference;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiPredicate;

public class JsonNodeUtil {
    public static JsonNode mergeJsonFiles(List<File> files) {
        ArrayList<ObjectNode> nodes = new ArrayList<ObjectNode>();
        for (File f : files) {
            if (!f.exists()) continue;
            ObjectNode node = null;
            try {
                node = (ObjectNode)ObjectMapperFactory.getObjectMapper().readTree(f);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to read JSON from file: " + f.getAbsolutePath(), e);
            }
            nodes.add(node);
        }
        if (nodes.isEmpty()) {
            return null;
        }
        return JsonNodeUtil.mergeObjectNodes(nodes.toArray(new ObjectNode[0]));
    }

    public static List<ResourceReference> mergeObjectNodeList(List<ResourceReference> list, BiPredicate<ResourceReference, ResourceReference> objectNodeEqualityTester) {
        ArrayList<ResourceReference> listOfMergedReferences = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : list) {
            if (listOfMergedReferences.isEmpty()) {
                listOfMergedReferences.add(resourceReference);
                continue;
            }
            int indexOfMatch = -1;
            for (int i = 0; i < listOfMergedReferences.size(); ++i) {
                if (!objectNodeEqualityTester.test(resourceReference, (ResourceReference)listOfMergedReferences.get(i))) continue;
                indexOfMatch = i;
                break;
            }
            if (indexOfMatch > -1) {
                ResourceReference matchingReference = (ResourceReference)listOfMergedReferences.get(indexOfMatch);
                ObjectNode merged = JsonNodeUtil.mergeObjectNodes(matchingReference.getObjectNode(), resourceReference.getObjectNode());
                matchingReference.setObjectNode(merged);
                matchingReference.getFiles().addAll(resourceReference.getFiles());
                continue;
            }
            listOfMergedReferences.add(resourceReference);
        }
        return listOfMergedReferences;
    }

    public static ObjectNode mergeObjectNodes(ObjectNode ... nodes) {
        ArrayList<ObjectNode> nodeList = new ArrayList<ObjectNode>();
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        for (ObjectNode node2 : nodes) {
            nodeList.add(node2);
            Iterator names = node2.fieldNames();
            while (names.hasNext()) {
                fieldNames.add((String)names.next());
            }
        }
        if (nodeList.isEmpty()) {
            return null;
        }
        for (int i = 1; i < nodeList.size(); ++i) {
            ObjectNode target = (ObjectNode)nodeList.get(i);
            ObjectNode source = (ObjectNode)nodeList.get(i - 1);
            for (String name : fieldNames) {
                JsonNode targetField = target.get(name);
                JsonNode sourceField = source.get(name);
                if (sourceField == null) continue;
                if (targetField == null) {
                    target.set(name, sourceField);
                    continue;
                }
                if (!sourceField.isArray() || !targetField.isArray()) continue;
                ArrayNode sourceArray = (ArrayNode)sourceField;
                ArrayNode targetArray = (ArrayNode)targetField;
                ArrayNode newArray = ObjectMapperFactory.getObjectMapper().createArrayNode();
                newArray.addAll(sourceArray);
                targetArray.forEach(node -> {
                    if (!JsonNodeUtil.arrayContains(newArray, node)) {
                        newArray.add(node);
                    }
                });
                target.set(name, (JsonNode)newArray);
            }
        }
        return (ObjectNode)nodeList.get(nodeList.size() - 1);
    }

    private static boolean arrayContains(ArrayNode array, JsonNode jsonNode) {
        Iterator iter = array.elements();
        while (iter.hasNext()) {
            JsonNode node = (JsonNode)iter.next();
            if (!node.equals((Object)jsonNode)) continue;
            return true;
        }
        return false;
    }
}

