/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.util;

public class TopologicalSorter {
    private String[] vertices;
    private int[][] matrix;
    private int numVerts;

    public TopologicalSorter(int vertexCount) {
        this.vertices = new String[vertexCount];
        this.matrix = new int[vertexCount][vertexCount];
        this.numVerts = 0;
        for (int i = 0; i < vertexCount; ++i) {
            for (int k = 0; k < vertexCount; ++k) {
                this.matrix[i][k] = 0;
            }
        }
    }

    public void addVertex(String vertex) {
        this.vertices[this.numVerts++] = vertex;
    }

    public void addEdge(int start, int end) {
        this.matrix[start][end] = 1;
    }

    public String[] sort() {
        String[] sortedArray = new String[this.vertices.length];
        while (this.numVerts > 0) {
            int currentVertex = this.noSuccessors();
            if (currentVertex == -1) {
                throw new IllegalStateException("Graph has cycles");
            }
            sortedArray[this.numVerts - 1] = this.vertices[currentVertex];
            this.deleteVertex(currentVertex);
        }
        return sortedArray;
    }

    private int noSuccessors() {
        for (int row = 0; row < this.numVerts; ++row) {
            boolean isEdge = false;
            for (int col = 0; col < this.numVerts; ++col) {
                if (this.matrix[row][col] <= 0) continue;
                isEdge = true;
                break;
            }
            if (isEdge) continue;
            return row;
        }
        return -1;
    }

    private void deleteVertex(int delVert) {
        if (delVert != this.numVerts - 1) {
            for (int j = delVert; j < this.numVerts - 1; ++j) {
                this.vertices[j] = this.vertices[j + 1];
            }
            for (int row = delVert; row < this.numVerts - 1; ++row) {
                this.moveRowUp(row, this.numVerts);
            }
            for (int col = delVert; col < this.numVerts - 1; ++col) {
                this.moveColLeft(col, this.numVerts - 1);
            }
        }
        --this.numVerts;
    }

    private void moveRowUp(int row, int length) {
        for (int col = 0; col < length; ++col) {
            this.matrix[row][col] = this.matrix[row + 1][col];
        }
    }

    private void moveColLeft(int col, int length) {
        for (int row = 0; row < length; ++row) {
            this.matrix[row][col] = this.matrix[row][col + 1];
        }
    }
}

