/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.marklogic.mgmt.api.LowerCaseWithHyphensStrategy;
import com.marklogic.mgmt.util.ObjectMapperInitializer;
import java.util.ArrayList;
import java.util.List;

public abstract class ObjectMapperFactory {
    private static ObjectMapper objectMapper;
    private static List<ObjectMapperInitializer> objectMapperInitializers;

    public static void addObjectMapperInitializer(ObjectMapperInitializer initializer) {
        if (objectMapperInitializers == null) {
            objectMapperInitializers = new ArrayList<ObjectMapperInitializer>();
        }
        objectMapperInitializers.add(initializer);
    }

    public static ObjectMapper getObjectMapper() {
        if (objectMapper == null) {
            ObjectMapperFactory.initializeObjectMapper();
        }
        return objectMapper;
    }

    private static void initializeObjectMapper() {
        objectMapper = new ObjectMapper();
        objectMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
        objectMapper.setPropertyNamingStrategy((PropertyNamingStrategy)new LowerCaseWithHyphensStrategy());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        if (objectMapperInitializers != null) {
            for (ObjectMapperInitializer initializer : objectMapperInitializers) {
                initializer.initializeObjectMapper(objectMapper);
            }
        }
    }
}

