/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.AbstractResourceManager;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import com.marklogic.rest.util.Fragment;
import org.jdom2.Namespace;
import org.springframework.http.ResponseEntity;

public class CertificateTemplateManager
extends AbstractResourceManager {
    public CertificateTemplateManager(ManageClient client) {
        super(client);
    }

    @Override
    protected boolean useSecurityUser() {
        return true;
    }

    @Override
    public String getResourcesPath() {
        return "/manage/v2/certificate-templates";
    }

    @Override
    protected String getIdFieldName() {
        return "template-name";
    }

    @Override
    public String getResourcePath(String resourceNameOrId, String ... resourceUrlParams) {
        String id = this.getIdForName(resourceNameOrId);
        return this.format("%s/%s", new Object[]{this.getResourcesPath(), id});
    }

    @Override
    public String getPropertiesPath(String resourceNameOrId, String ... resourceUrlParams) {
        return this.format("%s/properties", new Object[]{this.getResourcePath(resourceNameOrId, new String[0])});
    }

    public String getIdForName(String name) {
        return this.getAsXml().getIdForNameOrId(name);
    }

    public ResponseEntity<String> generateTemporaryCertificate(String templateIdOrName, String commonName) {
        return this.generateTemporaryCertificate(templateIdOrName, commonName, 365, null, null, true);
    }

    public ResponseEntity<String> generateTemporaryCertificate(String templateIdOrName, String commonName, int validFor, String dnsName, String ipAddress, boolean ifNecessary) {
        ObjectNode node = ObjectMapperFactory.getObjectMapper().createObjectNode();
        node.put("operation", "generate-temporary-certificate");
        node.put("valid-for", validFor);
        node.put("common-name", commonName);
        if (dnsName != null) {
            node.put("dns-name", dnsName);
        }
        if (ipAddress != null) {
            node.put("ip-addr", ipAddress);
        }
        node.put("if-necessary", ifNecessary);
        String json = node.toString();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format("Generating temporary certificate for template %s with payload: %s", new Object[]{templateIdOrName, json}));
        }
        return this.postPayload(this.getManageClient(), this.getResourcePath(templateIdOrName, new String[0]), json);
    }

    public ResponseEntity<String> insertHostCertificate(String templateIdOrName, String pubCert, String privateKey) {
        ObjectNode command = ObjectMapperFactory.getObjectMapper().createObjectNode();
        command.put("operation", "insert-host-certificates");
        ArrayNode certs = ObjectMapperFactory.getObjectMapper().createArrayNode();
        ObjectNode certificate = ObjectMapperFactory.getObjectMapper().createObjectNode();
        ObjectNode cert = ObjectMapperFactory.getObjectMapper().createObjectNode();
        certificate.put("cert", pubCert);
        certificate.put("pkey", privateKey);
        cert.set("certificate", (JsonNode)certificate);
        certs.add((JsonNode)cert);
        command.set("certificates", (JsonNode)certs);
        String json = command.toString();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format("Inserting host certificate for template %s", new Object[]{templateIdOrName}));
        }
        return this.postPayload(this.getManageClient(), this.getResourcePath(templateIdOrName, new String[0]), json);
    }

    public boolean certificateExists(String templateIdOrName) {
        return this.certificateExists(templateIdOrName, null);
    }

    public boolean certificateExists(String templateIdOrName, String certificateHostName) {
        Fragment response = this.getCertificatesForTemplate(templateIdOrName);
        return certificateHostName != null ? response.elementExists(this.format("/msec:certificate-list/msec:certificate[msec:host-name = '%s']", new Object[]{certificateHostName})) : response.elementExists("/msec:certificate-list/msec:certificate");
    }

    public Fragment getCertificatesForTemplate(String templateIdOrName) {
        ObjectNode node = ObjectMapperFactory.getObjectMapper().createObjectNode();
        node.put("operation", "get-certificates-for-template");
        String json = node.toString();
        String xml = (String)this.postPayload(this.getManageClient(), this.getResourcePath(templateIdOrName, new String[0]), json).getBody();
        return new Fragment(xml, new Namespace[0]);
    }
}

