/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.mimetypes;

import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.mimetypes.Mimetype;
import com.marklogic.mgmt.mapper.DefaultResourceMapper;
import com.marklogic.mgmt.mapper.ResourceMapper;
import com.marklogic.mgmt.resource.AbstractResourceManager;

public class MimetypeManager
extends AbstractResourceManager {
    private boolean updateWhenPropertiesAreEqual = false;
    private ResourceMapper resourceMapper;

    public MimetypeManager(ManageClient client) {
        super(client);
    }

    @Override
    protected String getIdFieldName() {
        return "name";
    }

    @Override
    public SaveReceipt updateResource(String payload, String resourceId) {
        String name;
        String existingJson;
        Mimetype existingMimetype;
        Mimetype incomingMimetype;
        if (this.updateWhenPropertiesAreEqual) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.format("updateWhenPropertiesAreEqual is set to true, so mimetype %s will be updated based on the incoming payload regardless of whether its properties differ from what's already set in MarkLogic or not", new Object[]{resourceId}));
            }
            return super.updateResource(payload, resourceId);
        }
        if (this.resourceMapper == null) {
            this.resourceMapper = new DefaultResourceMapper(new API(this.getManageClient()));
        }
        if ((incomingMimetype = this.resourceMapper.readResource(payload, Mimetype.class)).equals(existingMimetype = this.resourceMapper.readResource(existingJson = super.getPropertiesAsJson(name = incomingMimetype.getName(), new String[0]), Mimetype.class))) {
            this.logger.info(this.format("The properties in the payload for mimetype %s are the same as what's already set in MarkLogic, so the mimetype will not be updated", new Object[]{name}));
            return new SaveReceipt(name, payload, null, null);
        }
        this.logger.info(this.format("The properties in the payload for mimetype %s differ from what's already set in MarkLogic, so the mimetype will be updated", new Object[]{name}));
        return super.updateResource(payload, resourceId);
    }

    public void setUpdateWhenPropertiesAreEqual(boolean updateWhenPropertiesAreEqual) {
        this.updateWhenPropertiesAreEqual = updateWhenPropertiesAreEqual;
    }

    public void setResourceMapper(ResourceMapper resourceMapper) {
        this.resourceMapper = resourceMapper;
    }
}

