/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource;

import com.marklogic.mgmt.AbstractManager;
import com.marklogic.mgmt.DeleteReceipt;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.rest.util.Fragment;
import com.marklogic.rest.util.ResourcesFragment;
import org.springframework.http.ResponseEntity;

public abstract class AbstractResourceManager
extends AbstractManager
implements ResourceManager {
    private ManageClient manageClient;
    private boolean updateAllowed = true;
    protected final boolean usePutForCreate;

    public AbstractResourceManager(ManageClient client) {
        this(client, false);
    }

    public AbstractResourceManager(ManageClient client, boolean usePutForCreate) {
        this.manageClient = client;
        this.usePutForCreate = usePutForCreate;
    }

    public String getResourcesPath() {
        return this.format("/manage/v2/%ss", new Object[]{this.getResourceName()});
    }

    public String getResourcePath(String resourceNameOrId, String ... resourceUrlParams) {
        resourceNameOrId = this.encodeResourceId(resourceNameOrId);
        return this.appendParamsAndValuesToPath(this.format("%s/%s", new Object[]{this.getResourcesPath(), resourceNameOrId}), resourceUrlParams);
    }

    public String getPropertiesPath(String resourceNameOrId, String ... resourceUrlParams) {
        return this.appendParamsAndValuesToPath(this.format("%s/properties", new Object[]{this.getResourcePath(resourceNameOrId, new String[0])}), resourceUrlParams);
    }

    @Override
    public boolean exists(String resourceNameOrId, String ... resourceUrlParams) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Checking for existence of resource: " + resourceNameOrId);
        }
        return this.getAsXml().resourceExists(resourceNameOrId);
    }

    @Override
    public ResourcesFragment getAsXml() {
        Fragment f = this.useSecurityUser() ? this.manageClient.getXmlAsSecurityUser(this.getResourcesPath(), new String[0]) : this.manageClient.getXml(this.getResourcesPath(), new String[0]);
        return new ResourcesFragment(f);
    }

    @Override
    public Fragment getAsXml(String resourceNameOrId, String ... resourceUrlParams) {
        String path = this.appendParamsAndValuesToPath(this.getResourcePath(resourceNameOrId, resourceUrlParams), new String[0]);
        return this.useSecurityUser() ? this.manageClient.getXmlAsSecurityUser(path, new String[0]) : this.manageClient.getXml(path, new String[0]);
    }

    @Override
    public Fragment getPropertiesAsXml(String resourceNameOrId, String ... resourceUrlParams) {
        String path = this.appendParamsAndValuesToPath(this.getPropertiesPath(resourceNameOrId, resourceUrlParams), new String[0]);
        return this.useSecurityUser() ? this.manageClient.getXmlAsSecurityUser(path, new String[0]) : this.manageClient.getXml(path, new String[0]);
    }

    @Override
    public String getPropertiesAsXmlString(String resourceNameOrId, String ... resourceUrlParams) {
        String path = this.appendParamsAndValuesToPath(this.getPropertiesPath(resourceNameOrId, resourceUrlParams), new String[0]);
        return this.useSecurityUser() ? this.manageClient.getXmlStringAsSecurityUser(path) : this.manageClient.getXmlString(path);
    }

    @Override
    public String getAsJson(String resourceNameOrId, String ... resourceUrlParams) {
        String path = this.appendParamsAndValuesToPath(this.getPropertiesPath(resourceNameOrId, resourceUrlParams), new String[0]);
        return this.useSecurityUser() ? this.manageClient.getJsonAsSecurityUser(path) : this.manageClient.getJson(path);
    }

    @Override
    public String getPropertiesAsJson(String resourceNameOrId, String ... resourceUrlParams) {
        String path = this.appendParamsAndValuesToPath(this.getPropertiesPath(resourceNameOrId, resourceUrlParams), new String[0]);
        return this.useSecurityUser() ? this.manageClient.getJsonAsSecurityUser(path) : this.manageClient.getJson(path);
    }

    @Override
    public SaveReceipt save(String payload) {
        String resourceId = this.getResourceId(payload);
        if (this.exists(resourceId, new String[0])) {
            if (this.updateAllowed) {
                return this.updateResource(payload, resourceId);
            }
            this.logger.info("Resource already exists and updates are not supported, so not updating: " + resourceId);
            return new SaveReceipt(resourceId, payload, null, null);
        }
        return this.createNewResource(payload, resourceId);
    }

    protected SaveReceipt createNewResource(String payload, String resourceId) {
        ResponseEntity<String> response;
        String label = this.getResourceName();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format("Creating %s: %s", new Object[]{label, resourceId}));
        }
        String path = this.getCreateResourcePath(payload);
        ResponseEntity<String> responseEntity = response = this.usePutForCreate ? this.putPayload(this.manageClient, path, payload) : this.postPayload(this.manageClient, path, payload);
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format("Created %s: %s", new Object[]{label, resourceId}));
        }
        return new SaveReceipt(resourceId, payload, path, response);
    }

    protected String encodeResourceId(String idValue) {
        return idValue != null ? idValue.replace("+", "%2B") : idValue;
    }

    public SaveReceipt updateResource(String payload, String resourceId) {
        String path = this.getPropertiesPath(resourceId, new String[0]);
        String label = this.getResourceName();
        path = this.appendParamsAndValuesToPath(path, this.getUpdateResourceParams(payload));
        this.logger.info(this.format("Found %s with name of %s, so updating at path %s", new Object[]{label, resourceId, path}));
        ResponseEntity<String> response = this.putPayload(this.manageClient, path, payload);
        this.logger.info(this.format("Updated %s at %s", new Object[]{label, path}));
        return new SaveReceipt(resourceId, payload, path, response);
    }

    protected String getCreateResourcePath(String payload) {
        return this.getResourcesPath();
    }

    @Override
    public DeleteReceipt deleteByIdField(String resourceIdFieldValue, String ... resourceUrlParams) {
        String payload = "{\"%s\":\"%s\"}";
        return this.delete(this.format(payload, new Object[]{this.getIdFieldName(), resourceIdFieldValue}), resourceUrlParams);
    }

    @Override
    public DeleteReceipt delete(String payload, String ... resourceUrlParams) {
        String resourceId = this.getResourceId(payload);
        if (!this.exists(resourceId, new String[0])) {
            this.logger.info(this.format("Could not find %s with name or ID of %s, so not deleting", new Object[]{this.getResourceName(), resourceId}));
            return new DeleteReceipt(resourceId, null, false);
        }
        String path = this.getResourcePath(resourceId, resourceUrlParams);
        path = this.appendParamsAndValuesToPath(path, this.getDeleteResourceParams(payload));
        this.beforeDelete(resourceId, path, resourceUrlParams);
        this.deleteAtPath(path, new String[0]);
        return new DeleteReceipt(resourceId, path, true);
    }

    protected void beforeDelete(String resourceId, String path, String ... resourceUrlParams) {
    }

    public void deleteAtPath(String path, String ... headerNamesAndValues) {
        String label = this.getResourceName();
        this.logger.info(this.format("Deleting %s at path %s", new Object[]{label, path}));
        if (this.useSecurityUser()) {
            this.manageClient.deleteAsSecurityUser(path, headerNamesAndValues);
        } else {
            this.manageClient.delete(path, headerNamesAndValues);
        }
        this.logger.info(this.format("Deleted %s at path %s", new Object[]{label, path}));
    }

    protected String appendParamsAndValuesToPath(String path, String ... paramsAndValues) {
        if (paramsAndValues != null && paramsAndValues.length > 0) {
            StringBuilder pathBuilder = new StringBuilder(path);
            if (path.contains("?")) {
                pathBuilder.append("&");
            } else {
                pathBuilder.append("?");
            }
            for (int i = 0; i < paramsAndValues.length; i += 2) {
                String name = paramsAndValues[i];
                String value = paramsAndValues[i + 1];
                if (name == null || value == null) continue;
                if (i > 0) {
                    pathBuilder.append("&");
                }
                pathBuilder.append(name).append("=").append(value);
            }
            path = pathBuilder.toString();
        }
        return path;
    }

    protected String[] getUpdateResourceParams(String payload) {
        return new String[0];
    }

    protected String[] getDeleteResourceParams(String payload) {
        return this.getUpdateResourceParams(payload);
    }

    protected ManageClient getManageClient() {
        return this.manageClient;
    }

    public boolean isUpdateAllowed() {
        return this.updateAllowed;
    }

    public void setUpdateAllowed(boolean updateAllowed) {
        this.updateAllowed = updateAllowed;
    }
}

