/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.api.group;

import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.Resource;
import com.marklogic.mgmt.api.group.Audit;
import com.marklogic.mgmt.api.group.ModuleLocation;
import com.marklogic.mgmt.api.group.Namespace;
import com.marklogic.mgmt.api.group.Schema;
import com.marklogic.mgmt.api.server.UsingNamespace;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.groups.GroupManager;
import com.marklogic.mgmt.resource.tasks.TaskManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Group
extends Resource {
    public static final String DEFAULT_GROUP_NAME = "Default";
    @XmlElement(name="group-name")
    private String groupName;
    @XmlElement(name="list-cache-size")
    private Integer listCacheSize;
    @XmlElement(name="list-cache-partitions")
    private Integer listCachePartitions;
    @XmlElement(name="compressed-tree-cache-size")
    private Integer compressedTreeCacheSize;
    @XmlElement(name="compressed-tree-cache-partitions")
    private Integer compressedTreeCachePartitions;
    @XmlElement(name="compressed-tree-read-size")
    private Integer compressedTreeReadSize;
    @XmlElement(name="expanded-tree-cache-size")
    private Integer expandedTreeCacheSize;
    @XmlElement(name="expanded-tree-cache-partitions")
    private Integer expandedTreeCachePartitions;
    @XmlElement(name="triple-cache-size")
    private Integer tripleCacheSize;
    @XmlElement(name="triple-cache-partitions")
    private Integer tripleCachePartitions;
    @XmlElement(name="triple-cache-timeout")
    private Integer tripleCacheTimeout;
    @XmlElement(name="triple-value-cache-size")
    private Integer tripleValueCacheSize;
    @XmlElement(name="triple-value-cache-partitions")
    private Integer tripleValueCachePartitions;
    @XmlElement(name="triple-value-cache-timeout")
    private Integer tripleValueCacheTimeout;
    @XmlElement(name="smtp-relay")
    private String smtpRelay;
    @XmlElement(name="smtp-timeout")
    private Integer smtpTimeout;
    @XmlElement(name="http-user-agent")
    private String httpUserAgent;
    @XmlElement(name="http-timeout")
    private Integer httpTimeout;
    @XmlElement(name="xdqp-timeout")
    private Integer xdqpTimeout;
    @XmlElement(name="host-timeout")
    private Integer hostTimeout;
    @XmlElement(name="host-initial-timeout")
    private Integer hostInitialTimeout;
    @XmlElement(name="retry-timeout")
    private Integer retryTimeout;
    @XmlElement(name="module-cache-timeout")
    private Integer moduleCacheTimeout;
    @XmlElement(name="system-log-level")
    private String systemLogLevel;
    @XmlElement(name="file-log-level")
    private String fileLogLevel;
    @XmlElement(name="rotate-log-files")
    private String rotateLogFiles;
    @XmlElement(name="keep-log-files")
    private String keepLogFiles;
    @XmlElement(name="failover-enable")
    private Boolean failoverEnable;
    @XmlElement(name="xdqp-ssl-enabled")
    private Boolean xdqpSslEnabled;
    @XmlElement(name="xdqp-ssl-allow-ssl-v3")
    private Boolean xdqpSslAllowSslv3;
    @XmlElement(name="xdqp-ssl-allow-tls")
    private Boolean xdqpSslAllowTls;
    @XmlElement(name="xdqp-ssl-ciphers")
    private String xdqpSslCiphers;
    @XmlElementWrapper(name="schemas")
    @XmlElement(name="schema")
    private List<Schema> schema;
    @XmlElementWrapper(name="namespaces")
    @XmlElement(name="namespace")
    private List<Namespace> namespace;
    @XmlElementWrapper(name="using-namespaces")
    @XmlElement(name="using-namespace")
    private List<UsingNamespace> usingNamespace;
    @XmlElementWrapper(name="module-locations")
    @XmlElement(name="module-location")
    private List<ModuleLocation> moduleLocation;
    @XmlElement(name="events-activated")
    private Boolean eventsActivated;
    @XmlElementWrapper(name="events")
    @XmlElement(name="event")
    private List<String> event;
    private Audit audit;
    @XmlElement(name="background-io-limit")
    private Long backgroundIoLimit;
    @XmlElement(name="metering-enabled")
    private Boolean meteringEnabled;
    @XmlElement(name="performance-metering-enabled")
    private Boolean performanceMeteringEnabled;
    @XmlElement(name="meters-database")
    private String metersDatabase;
    @XmlElement(name="performance-metering-period")
    private Integer performanceMeteringPeriod;
    @XmlElement(name="performance-metering-raw")
    private Integer performanceMeteringRetainRaw;
    @XmlElement(name="performance-metering-hourly")
    private Integer performanceMeteringRetainHourly;
    @XmlElement(name="performance-metering-daily")
    private Integer performanceMeteringRetainDaily;
    @XmlElement(name="s3-domain")
    private String s3Domain;
    @XmlElement(name="s3-protocol")
    private String s3Protocol;
    @XmlElement(name="s3-encryption")
    private String s3ServerSideEncryption;
    @XmlElement(name="security-database")
    private String securityDatabase;

    public Group() {
    }

    public Group(API api) {
        this(api, DEFAULT_GROUP_NAME);
    }

    public Group(API api, String groupName) {
        super(api);
        this.groupName = groupName;
    }

    @Override
    protected ResourceManager getResourceManager() {
        return new GroupManager(this.getClient());
    }

    public void trace(String ... events) {
        this.addEvents(events);
        this.eventsActivated = true;
        this.saveEvents();
    }

    public void untrace(String ... events) {
        this.removeEvents(events);
        this.saveEvents();
    }

    public void saveEvents() {
        Group temp = new Group(this.getApi(), this.groupName);
        temp.setEvent(this.getEvent());
        temp.setEventsActivated(true);
        temp.save();
    }

    public void addEvents(String ... events) {
        if (this.event == null) {
            this.event = new ArrayList<String>();
        }
        this.event.addAll(Arrays.asList(events));
    }

    public void removeEvents(String ... events) {
        if (this.event == null) {
            this.event = new ArrayList<String>();
        } else {
            this.event.removeAll(Arrays.asList(events));
        }
    }

    public void disableTasks() {
        this.newTaskManager().disableAllTasks();
    }

    public void enableTasks() {
        this.newTaskManager().enableAllTasks();
    }

    public void deleteTasks() {
        this.newTaskManager().deleteAllScheduledTasks();
    }

    public TaskManager newTaskManager() {
        return new TaskManager(this.getClient(), this.getGroupName());
    }

    @Override
    protected String getResourceId() {
        return this.groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Integer getListCacheSize() {
        return this.listCacheSize;
    }

    public void setListCacheSize(Integer listCacheSize) {
        this.listCacheSize = listCacheSize;
    }

    public Integer getListCachePartitions() {
        return this.listCachePartitions;
    }

    public void setListCachePartitions(Integer listCachePartitions) {
        this.listCachePartitions = listCachePartitions;
    }

    public Integer getCompressedTreeCacheSize() {
        return this.compressedTreeCacheSize;
    }

    public void setCompressedTreeCacheSize(Integer compressedTreeCacheSize) {
        this.compressedTreeCacheSize = compressedTreeCacheSize;
    }

    public Integer getCompressedTreeCachePartitions() {
        return this.compressedTreeCachePartitions;
    }

    public void setCompressedTreeCachePartitions(Integer compressedTreeCachePartitions) {
        this.compressedTreeCachePartitions = compressedTreeCachePartitions;
    }

    public Integer getCompressedTreeReadSize() {
        return this.compressedTreeReadSize;
    }

    public void setCompressedTreeReadSize(Integer compressedTreeReadSize) {
        this.compressedTreeReadSize = compressedTreeReadSize;
    }

    public Integer getExpandedTreeCacheSize() {
        return this.expandedTreeCacheSize;
    }

    public void setExpandedTreeCacheSize(Integer expandedTreeCacheSize) {
        this.expandedTreeCacheSize = expandedTreeCacheSize;
    }

    public Integer getExpandedTreeCachePartitions() {
        return this.expandedTreeCachePartitions;
    }

    public void setExpandedTreeCachePartitions(Integer expandedTreeCachePartitions) {
        this.expandedTreeCachePartitions = expandedTreeCachePartitions;
    }

    public Integer getTripleCacheSize() {
        return this.tripleCacheSize;
    }

    public void setTripleCacheSize(Integer tripleCacheSize) {
        this.tripleCacheSize = tripleCacheSize;
    }

    public Integer getTripleCachePartitions() {
        return this.tripleCachePartitions;
    }

    public void setTripleCachePartitions(Integer tripleCachePartitions) {
        this.tripleCachePartitions = tripleCachePartitions;
    }

    public Integer getTripleCacheTimeout() {
        return this.tripleCacheTimeout;
    }

    public void setTripleCacheTimeout(Integer tripleCacheTimeout) {
        this.tripleCacheTimeout = tripleCacheTimeout;
    }

    public Integer getTripleValueCacheSize() {
        return this.tripleValueCacheSize;
    }

    public void setTripleValueCacheSize(Integer tripleValueCacheSize) {
        this.tripleValueCacheSize = tripleValueCacheSize;
    }

    public Integer getTripleValueCachePartitions() {
        return this.tripleValueCachePartitions;
    }

    public void setTripleValueCachePartitions(Integer tripleValueCachePartitions) {
        this.tripleValueCachePartitions = tripleValueCachePartitions;
    }

    public Integer getTripleValueCacheTimeout() {
        return this.tripleValueCacheTimeout;
    }

    public void setTripleValueCacheTimeout(Integer tripleValueCacheTimeout) {
        this.tripleValueCacheTimeout = tripleValueCacheTimeout;
    }

    public String getSmtpRelay() {
        return this.smtpRelay;
    }

    public void setSmtpRelay(String smtpRelay) {
        this.smtpRelay = smtpRelay;
    }

    public Integer getSmtpTimeout() {
        return this.smtpTimeout;
    }

    public void setSmtpTimeout(Integer smtpTimeout) {
        this.smtpTimeout = smtpTimeout;
    }

    public String getHttpUserAgent() {
        return this.httpUserAgent;
    }

    public void setHttpUserAgent(String httpUserAgent) {
        this.httpUserAgent = httpUserAgent;
    }

    public Integer getHttpTimeout() {
        return this.httpTimeout;
    }

    public void setHttpTimeout(Integer httpTimeout) {
        this.httpTimeout = httpTimeout;
    }

    public Integer getXdqpTimeout() {
        return this.xdqpTimeout;
    }

    public void setXdqpTimeout(Integer xdqpTimeout) {
        this.xdqpTimeout = xdqpTimeout;
    }

    public Integer getHostTimeout() {
        return this.hostTimeout;
    }

    public void setHostTimeout(Integer hostTimeout) {
        this.hostTimeout = hostTimeout;
    }

    public Integer getHostInitialTimeout() {
        return this.hostInitialTimeout;
    }

    public void setHostInitialTimeout(Integer hostInitialTimeout) {
        this.hostInitialTimeout = hostInitialTimeout;
    }

    public Integer getRetryTimeout() {
        return this.retryTimeout;
    }

    public void setRetryTimeout(Integer retryTimeout) {
        this.retryTimeout = retryTimeout;
    }

    public Integer getModuleCacheTimeout() {
        return this.moduleCacheTimeout;
    }

    public void setModuleCacheTimeout(Integer moduleCacheTimeout) {
        this.moduleCacheTimeout = moduleCacheTimeout;
    }

    public String getSystemLogLevel() {
        return this.systemLogLevel;
    }

    public void setSystemLogLevel(String systemLogLevel) {
        this.systemLogLevel = systemLogLevel;
    }

    public String getFileLogLevel() {
        return this.fileLogLevel;
    }

    public void setFileLogLevel(String fileLogLevel) {
        this.fileLogLevel = fileLogLevel;
    }

    public String getRotateLogFiles() {
        return this.rotateLogFiles;
    }

    public void setRotateLogFiles(String rotateLogFiles) {
        this.rotateLogFiles = rotateLogFiles;
    }

    public String getKeepLogFiles() {
        return this.keepLogFiles;
    }

    public void setKeepLogFiles(String keepLogFiles) {
        this.keepLogFiles = keepLogFiles;
    }

    public Boolean getFailoverEnable() {
        return this.failoverEnable;
    }

    public void setFailoverEnable(Boolean failoverEnable) {
        this.failoverEnable = failoverEnable;
    }

    public Boolean getXdqpSslEnabled() {
        return this.xdqpSslEnabled;
    }

    public void setXdqpSslEnabled(Boolean xdqpSslEnabled) {
        this.xdqpSslEnabled = xdqpSslEnabled;
    }

    public Boolean getXdqpSslAllowSslv3() {
        return this.xdqpSslAllowSslv3;
    }

    public void setXdqpSslAllowSslv3(Boolean xdqpSslAllowSslv3) {
        this.xdqpSslAllowSslv3 = xdqpSslAllowSslv3;
    }

    public Boolean getXdqpSslAllowTls() {
        return this.xdqpSslAllowTls;
    }

    public void setXdqpSslAllowTls(Boolean xdqpSslAllowTls) {
        this.xdqpSslAllowTls = xdqpSslAllowTls;
    }

    public String getXdqpSslCiphers() {
        return this.xdqpSslCiphers;
    }

    public void setXdqpSslCiphers(String xdqpSslCiphers) {
        this.xdqpSslCiphers = xdqpSslCiphers;
    }

    public List<Schema> getSchema() {
        return this.schema;
    }

    public void setSchema(List<Schema> schema) {
        this.schema = schema;
    }

    public List<Namespace> getNamespace() {
        return this.namespace;
    }

    public void setNamespace(List<Namespace> namespace) {
        this.namespace = namespace;
    }

    public List<UsingNamespace> getUsingNamespace() {
        return this.usingNamespace;
    }

    public void setUsingNamespace(List<UsingNamespace> usingNamespace) {
        this.usingNamespace = usingNamespace;
    }

    public List<ModuleLocation> getModuleLocation() {
        return this.moduleLocation;
    }

    public void setModuleLocation(List<ModuleLocation> moduleLocation) {
        this.moduleLocation = moduleLocation;
    }

    public Boolean getEventsActivated() {
        return this.eventsActivated;
    }

    public void setEventsActivated(Boolean eventsActivated) {
        this.eventsActivated = eventsActivated;
    }

    public List<String> getEvent() {
        return this.event;
    }

    public void setEvent(List<String> event) {
        this.event = event;
    }

    public Audit getAudit() {
        return this.audit;
    }

    public void setAudit(Audit audit) {
        this.audit = audit;
    }

    public Long getBackgroundIoLimit() {
        return this.backgroundIoLimit;
    }

    public void setBackgroundIoLimit(Long backgroundIoLimit) {
        this.backgroundIoLimit = backgroundIoLimit;
    }

    public Boolean getMeteringEnabled() {
        return this.meteringEnabled;
    }

    public void setMeteringEnabled(Boolean meteringEnabled) {
        this.meteringEnabled = meteringEnabled;
    }

    public Boolean getPerformanceMeteringEnabled() {
        return this.performanceMeteringEnabled;
    }

    public void setPerformanceMeteringEnabled(Boolean performanceMeteringEnabled) {
        this.performanceMeteringEnabled = performanceMeteringEnabled;
    }

    public String getMetersDatabase() {
        return this.metersDatabase;
    }

    public void setMetersDatabase(String metersDatabase) {
        this.metersDatabase = metersDatabase;
    }

    public Integer getPerformanceMeteringPeriod() {
        return this.performanceMeteringPeriod;
    }

    public void setPerformanceMeteringPeriod(Integer performanceMeteringPeriod) {
        this.performanceMeteringPeriod = performanceMeteringPeriod;
    }

    public Integer getPerformanceMeteringRetainRaw() {
        return this.performanceMeteringRetainRaw;
    }

    public void setPerformanceMeteringRetainRaw(Integer performanceMeteringRetainRaw) {
        this.performanceMeteringRetainRaw = performanceMeteringRetainRaw;
    }

    public Integer getPerformanceMeteringRetainHourly() {
        return this.performanceMeteringRetainHourly;
    }

    public void setPerformanceMeteringRetainHourly(Integer performanceMeteringRetainHourly) {
        this.performanceMeteringRetainHourly = performanceMeteringRetainHourly;
    }

    public Integer getPerformanceMeteringRetainDaily() {
        return this.performanceMeteringRetainDaily;
    }

    public void setPerformanceMeteringRetainDaily(Integer performanceMeteringRetainDaily) {
        this.performanceMeteringRetainDaily = performanceMeteringRetainDaily;
    }

    public String getS3Domain() {
        return this.s3Domain;
    }

    public void setS3Domain(String s3Domain) {
        this.s3Domain = s3Domain;
    }

    public String getS3Protocol() {
        return this.s3Protocol;
    }

    public void setS3Protocol(String s3Protocol) {
        this.s3Protocol = s3Protocol;
    }

    public String getS3ServerSideEncryption() {
        return this.s3ServerSideEncryption;
    }

    public void setS3ServerSideEncryption(String s3ServerSideEncryption) {
        this.s3ServerSideEncryption = s3ServerSideEncryption;
    }

    public String getSecurityDatabase() {
        return this.securityDatabase;
    }

    public void setSecurityDatabase(String securityDatabase) {
        this.securityDatabase = securityDatabase;
    }
}

