/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.mgmt.DeleteReceipt;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.ApiObject;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Resource
extends ApiObject {
    private Logger logger;
    private API api;

    protected Resource() {
        this.setObjectMapper(ObjectMapperFactory.getObjectMapper());
    }

    protected Resource(API api) {
        this.api = api;
        if (api != null) {
            this.setObjectMapper(api.getObjectMapper());
        } else {
            this.setObjectMapper(ObjectMapperFactory.getObjectMapper());
        }
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(this.getClass());
        }
        return this.logger;
    }

    public ObjectNode toObjectNode() {
        String json = this.getJson();
        try {
            return (ObjectNode)ObjectMapperFactory.getObjectMapper().readTree(json);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to convert to ObjectNode, cause: " + e.getMessage(), e);
        }
    }

    public String save() {
        String name = this.getResourceType();
        String label = this.getResourceLabel();
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(this.format("Saving %s %s", name, label));
        }
        SaveReceipt receipt = this.getResourceManager().save(this.getJson());
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(this.format("Saved %s %s", name, label));
        }
        return this.format("[Path: %s; Resource ID: %s; HTTP status: %s]", receipt.getPath(), receipt.getResourceId(), receipt.getResponse() != null ? receipt.getResponse().getStatusCode() : "(none)");
    }

    public String delete() {
        String name = this.getResourceType();
        String label = this.getResourceLabel();
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(this.format("Deleting %s %s", name, label));
        }
        DeleteReceipt receipt = this.getResourceManager().deleteByIdField(this.getResourceId(), this.getResourceUrlParams());
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(this.format("Deleted %s %s", name, label));
        }
        return receipt.isDeleted() ? this.format("[Path: %s; Resource ID: %s; deleted: true]", receipt.getPath(), receipt.getResourceId()) : this.format("[Resource ID: %s; deleted: false]", receipt.getResourceId());
    }

    public List<String> list() {
        List<String> list = this.getResourceManager().getAsXml().getListItemNameRefs();
        Collections.sort(list);
        return list;
    }

    public boolean exists() {
        return this.getResourceManager().exists(this.getResourceId(), this.getResourceUrlParams());
    }

    @JsonIgnore
    public String[] getResourceUrlParams() {
        return null;
    }

    protected abstract ResourceManager getResourceManager();

    protected abstract String getResourceId();

    protected String getResourceLabel() {
        return this.getResourceId();
    }

    protected String getResourceType() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    @JsonIgnore
    protected API getApi() {
        return this.api;
    }

    @JsonIgnore
    protected ManageClient getClient() {
        return this.api.getManageClient();
    }

    protected String format(String format, Object ... args) {
        return String.format(format, args);
    }

    public void setApi(API api) {
        this.api = api;
    }

    public String toString() {
        return this.format("[%s: %s]", this.getResourceType(), this.getResourceLabel());
    }
}

