/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.scaffold;

import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.scaffold.ResourceWriter;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.mgmt.api.Resource;
import com.marklogic.mgmt.api.cluster.Cluster;
import com.marklogic.mgmt.api.database.Database;
import com.marklogic.mgmt.api.forest.Forest;
import com.marklogic.mgmt.api.group.Group;
import com.marklogic.mgmt.api.security.Amp;
import com.marklogic.mgmt.api.security.ExternalSecurity;
import com.marklogic.mgmt.api.security.Privilege;
import com.marklogic.mgmt.api.security.ProtectedCollection;
import com.marklogic.mgmt.api.security.Role;
import com.marklogic.mgmt.api.security.User;
import com.marklogic.mgmt.api.server.Server;
import com.marklogic.mgmt.api.task.Task;
import com.marklogic.mgmt.api.trigger.Trigger;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.springframework.util.FileCopyUtils;

public class DefaultResourceWriter
extends LoggingObject
implements ResourceWriter {
    private Map<Class<?>, BiFunction<ConfigDir, Resource, File>> functionMap = new HashMap();

    public DefaultResourceWriter() {
        this.addFunction(Cluster.class, (configDir, resource) -> configDir.getClustersDir());
        this.addFunction(Database.class, (configDir, resource) -> configDir.getDatabasesDir());
        this.addFunction(Forest.class, (configDir, resource) -> configDir.getForestsDir());
        this.addFunction(Group.class, (configDir, resource) -> configDir.getGroupsDir());
        this.addFunction(Amp.class, (configDir, resource) -> configDir.getAmpsDir());
        this.addFunction(ExternalSecurity.class, (configDir, resource) -> configDir.getExternalSecuritiesDir());
        this.addFunction(Privilege.class, (configDir, resource) -> configDir.getPrivilegesDir());
        this.addFunction(ProtectedCollection.class, (configDir, resource) -> configDir.getProtectedCollectionsDir());
        this.addFunction(Role.class, (configDir, resource) -> configDir.getRolesDir());
        this.addFunction(User.class, (configDir, resource) -> configDir.getUsersDir());
        this.addFunction(Server.class, (configDir, resource) -> configDir.getServersDir());
        this.addFunction(Task.class, (configDir, resource) -> configDir.getTasksDir());
        this.addFunction(Trigger.class, (configDir, resource) -> configDir.getTriggersDir(((Trigger)resource).getDatabaseName()));
    }

    public void addFunction(Class<?> resourceClass, BiFunction<ConfigDir, Resource, File> function) {
        this.functionMap.put(resourceClass, function);
    }

    @Override
    public File writeResourceAsJson(Resource r, ConfigDir configDir) {
        File file = this.determineResourceFile(r, configDir, ".json");
        try {
            FileCopyUtils.copy((byte[])r.getJson().getBytes(), (File)file);
            return file;
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to write to file: " + file.getAbsolutePath() + "; cause: " + ex.getMessage(), ex);
        }
    }

    @Override
    public File writeResourceAsXml(Resource r, ConfigDir configDir) {
        File file = this.determineResourceFile(r, configDir, ".xml");
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{r.getClass()});
            context.createMarshaller().marshal((Object)r, file);
            return file;
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Unable to write to file: " + file.getAbsolutePath() + "; cause: " + ex.getMessage(), ex);
        }
    }

    protected File determineResourceFile(Resource r, ConfigDir configDir, String extension) {
        BiFunction<ConfigDir, Resource, File> function = this.functionMap.get(r.getClass());
        if (function == null) {
            throw new IllegalArgumentException("Unsupported resource class type:" + r.getClass());
        }
        File dir = function.apply(configDir, r);
        dir.mkdirs();
        File file = new File(dir, this.buildFilename(r, extension));
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Writing file: " + file.getAbsolutePath());
        }
        return file;
    }

    protected String buildFilename(Resource resource, String extension) {
        return resource.getClass().getSimpleName() + "-" + System.currentTimeMillis() + extension;
    }
}

