/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.impl;

import com.marklogic.appdeployer.command.Command;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.security.DeployUsersCommand;
import com.marklogic.appdeployer.impl.DeployerListenerSupport;
import com.marklogic.appdeployer.impl.DeploymentContext;
import com.marklogic.mgmt.api.configuration.Configurations;
import java.util.List;

public class CmaDeployerListener
extends DeployerListenerSupport {
    @Override
    public void afterCommandExecuted(Command command, DeploymentContext context, List<Command> remainingCommands) {
        CommandContext commandContext;
        Configurations configs;
        if (this.combinedRequestShouldBeSubmitted(command, remainingCommands) && (configs = (commandContext = context.getCommandContext()).getCombinedCmaRequest()) != null) {
            commandContext.removeCombinedCmaRequest();
            if (configs.hasResources()) {
                this.logger.info("Submitting combined CMA request");
                configs.submit(commandContext.getManageClient());
            }
        }
    }

    protected boolean combinedRequestShouldBeSubmitted(Command command, List<Command> remainingCommands) {
        if (command instanceof DeployUsersCommand) {
            return true;
        }
        if (remainingCommands.isEmpty()) {
            return true;
        }
        Command nextCommand = remainingCommands.get(0);
        return nextCommand.getExecuteSortOrder() >= SortOrderConstants.DEPLOY_USERS;
    }
}

