/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.export.security;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.export.impl.AbstractNamedResourceExporter;
import com.marklogic.appdeployer.export.impl.ExportInputs;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.PayloadParser;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.security.UserManager;
import com.marklogic.rest.util.Fragment;
import java.io.File;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class UserExporter
extends AbstractNamedResourceExporter {
    private PayloadParser payloadParser = new PayloadParser();
    private String defaultPassword = "CHANGEME";

    public UserExporter(ManageClient manageClient, String ... usernames) {
        super(manageClient, usernames);
    }

    @Override
    protected ResourceManager newResourceManager(ManageClient manageClient) {
        return new UserManager(manageClient);
    }

    @Override
    protected File getResourceDirectory(File baseDir) {
        return new ConfigDir(baseDir).getUsersDir();
    }

    @Override
    protected String[] getExportMessages() {
        return new String[]{"The exported user files each have a default password in them, as the real password cannot be exported for security reasons."};
    }

    @Override
    protected String beforeResourceWrittenToFile(ExportInputs exportInputs, String payload) {
        try {
            if (this.payloadParser.isJsonPayload(payload)) {
                ObjectNode json = (ObjectNode)this.payloadParser.parseJson(payload);
                if (!json.has("password")) {
                    json.put("password", this.defaultPassword);
                    return this.objectMapper.writeValueAsString((Object)json);
                }
            } else {
                Fragment xml = new Fragment(payload, new Namespace[0]);
                if (!xml.elementExists("/node()/m:password")) {
                    Document doc = xml.getInternalDoc();
                    doc.getRootElement().addContent((Content)new Element("password", "http://marklogic.com/manage").setText(this.defaultPassword));
                    return new XMLOutputter(Format.getPrettyFormat()).outputString(doc);
                }
            }
        }
        catch (Exception ex) {
            this.logger.warn("Unable to add a default password to exported user: " + exportInputs.getResourceName() + "; still exporting user but without a password; exception message: " + ex.getMessage());
        }
        return payload;
    }

    public void setDefaultPassword(String defaultPassword) {
        this.defaultPassword = defaultPassword;
    }
}

