/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.export.databases;

import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.export.ExportedResources;
import com.marklogic.appdeployer.export.forests.ForestExporter;
import com.marklogic.appdeployer.export.impl.AbstractNamedResourceExporter;
import com.marklogic.appdeployer.export.impl.ExportInputs;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.databases.DatabaseManager;
import java.io.File;
import java.util.List;

public class DatabaseExporter
extends AbstractNamedResourceExporter {
    private boolean exportForests = true;

    public DatabaseExporter(ManageClient manageClient, String ... databaseNames) {
        super(manageClient, databaseNames);
    }

    @Override
    protected ResourceManager newResourceManager(ManageClient manageClient) {
        return new DatabaseManager(manageClient);
    }

    @Override
    protected File getResourceDirectory(File baseDir) {
        return new ConfigDir(baseDir).getDatabasesDir();
    }

    @Override
    protected String beforeResourceWrittenToFile(ExportInputs exportInputs, String payload) {
        return this.removeForestsSoDatabaseCanBeCreatedBeforeForestsAre(payload);
    }

    protected String removeForestsSoDatabaseCanBeCreatedBeforeForestsAre(String payload) {
        return this.removeJsonKeyFromPayload(payload, "forest");
    }

    @Override
    protected String[] getExportMessages() {
        return new String[]{"The 'forest' key was removed from each exported database so that databases can be deployed before forests."};
    }

    @Override
    public ExportedResources exportResources(File baseDir) {
        ExportedResources resources = super.exportResources(baseDir);
        if (this.isExportForests()) {
            resources = this.exportForests(baseDir, resources);
        }
        return resources;
    }

    protected ExportedResources exportForests(File baseDir, ExportedResources resources) {
        DatabaseManager dbMgr = new DatabaseManager(this.getManageClient());
        for (String dbName : this.getResourceNames()) {
            List<String> forestNames = dbMgr.getForestNames(dbName);
            ForestExporter forestExporter = new ForestExporter(dbName, this.getManageClient(), forestNames.toArray(new String[0]));
            resources.add(forestExporter.exportResources(baseDir));
        }
        return resources;
    }

    public boolean isExportForests() {
        return this.exportForests;
    }

    public void setExportForests(boolean exportForests) {
        this.exportForests = exportForests;
    }
}

