/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.export.appservers;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.export.ExportedResources;
import com.marklogic.appdeployer.export.databases.DatabaseExporter;
import com.marklogic.appdeployer.export.impl.AbstractNamedResourceExporter;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.appservers.ServerManager;
import java.io.File;
import java.util.ArrayList;

public class ServerExporter
extends AbstractNamedResourceExporter {
    private String groupName;
    private boolean exportDatabases = true;

    public ServerExporter(ManageClient manageClient, String ... serverNames) {
        super(manageClient, serverNames);
    }

    public ServerExporter(String groupName, ManageClient manageClient, String ... serverNames) {
        super(manageClient, serverNames);
        this.groupName = groupName;
    }

    @Override
    protected ResourceManager newResourceManager(ManageClient manageClient) {
        return this.groupName != null ? new ServerManager(manageClient, this.groupName) : new ServerManager(manageClient);
    }

    @Override
    protected File getResourceDirectory(File baseDir) {
        return new ConfigDir(baseDir).getServersDir();
    }

    @Override
    public ExportedResources exportResources(File baseDir) {
        ExportedResources resources = super.exportResources(baseDir);
        if (this.isExportDatabases()) {
            resources = this.exportDatabases(baseDir, resources);
        }
        return resources;
    }

    protected ExportedResources exportDatabases(File baseDir, ExportedResources resources) {
        ServerManager mgr = this.groupName != null ? new ServerManager(this.getManageClient(), this.groupName) : new ServerManager(this.getManageClient());
        for (String serverName : this.getResourceNames()) {
            String json = mgr.getPropertiesAsJson(serverName, new String[0]);
            ObjectNode server = (ObjectNode)this.payloadParser.parseJson(json);
            ArrayList<String> dbNames = new ArrayList<String>();
            if (server.has("content-database")) {
                dbNames.add(server.get("content-database").textValue());
            }
            if (server.has("modules-database")) {
                dbNames.add(server.get("modules-database").textValue());
            }
            if (dbNames.isEmpty()) continue;
            ExportedResources er = new DatabaseExporter(this.getManageClient(), dbNames.toArray(new String[0])).exportResources(baseDir);
            resources.add(er);
        }
        return resources;
    }

    public boolean isExportDatabases() {
        return this.exportDatabases;
    }

    public void setExportDatabases(boolean exportDatabases) {
        this.exportDatabases = exportDatabases;
    }
}

