/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.security;

import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.ResourceReference;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.security.PrivilegeBiPredicate;
import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.security.Privilege;
import com.marklogic.mgmt.mapper.DefaultResourceMapper;
import com.marklogic.mgmt.mapper.ResourceMapper;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.security.PrivilegeManager;
import java.io.File;
import java.util.function.BiPredicate;

public class DeployPrivilegeRolesCommand
extends AbstractResourceCommand {
    private ResourceMapper resourceMapper;

    public DeployPrivilegeRolesCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_PRIVILEGE_ROLES);
        this.setUndoSortOrder(SortOrderConstants.DELETE_PRIVILEGES);
        this.setSupportsResourceMerging(true);
        this.setResourceClassType(Privilege.class);
    }

    @Override
    public void undo(CommandContext context) {
        this.logger.info("Nothing to do, as DeployPrivilegesCommand is expected to delete privileges");
    }

    @Override
    protected File[] getResourceDirs(CommandContext context) {
        return this.findResourceDirs(context, (ConfigDir configDir) -> configDir.getPrivilegesDir());
    }

    @Override
    protected ResourceManager getResourceManager(CommandContext context) {
        return new PrivilegeManager(context.getManageClient());
    }

    @Override
    protected String adjustPayloadBeforeSavingResource(CommandContext context, File f, String payload) {
        if ((payload = super.adjustPayloadBeforeSavingResource(context, f, payload)) != null) {
            Privilege p;
            if (this.resourceMapper == null) {
                this.resourceMapper = new DefaultResourceMapper(new API(context.getManageClient()));
            }
            if ((p = this.resourceMapper.readResource(payload, Privilege.class)).getRole() == null || p.getRole().isEmpty()) {
                return null;
            }
        }
        return payload;
    }

    @Override
    protected BiPredicate<ResourceReference, ResourceReference> getBiPredicateForMergingResources() {
        return new PrivilegeBiPredicate();
    }
}

