/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.schemas;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ext.schemasloader.SchemasLoader;
import com.marklogic.client.ext.schemasloader.impl.DefaultSchemasLoader;
import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.database.Database;
import com.marklogic.mgmt.mapper.DefaultResourceMapper;
import java.io.File;
import java.io.FileFilter;
import java.util.List;

public class LoadSchemasCommand
extends AbstractCommand {
    public LoadSchemasCommand() {
        this.setExecuteSortOrder(SortOrderConstants.LOAD_SCHEMAS);
    }

    @Override
    public void execute(CommandContext context) {
        this.loadSchemasFromSchemaPaths(context);
        this.loadSchemasFromDatabaseSpecificPaths(context);
    }

    protected void loadSchemasFromSchemaPaths(CommandContext context) {
        AppConfig config = context.getAppConfig();
        List<String> schemaPaths = config.getSchemaPaths();
        if (schemaPaths != null && !schemaPaths.isEmpty()) {
            for (String path : schemaPaths) {
                this.loadSchemas(path, config.getSchemasDatabaseName(), context);
            }
        }
    }

    protected void loadSchemasFromDatabaseSpecificPaths(CommandContext context) {
        context.getAppConfig().getConfigDirs().forEach(configDir -> configDir.getDatabaseResourceDirectories().forEach(dir -> {
            String databaseName;
            File schemasDir = new File((File)dir, "schemas");
            if (schemasDir.exists() && schemasDir.listFiles().length > 0 && (databaseName = this.determineDatabaseNameForDatabaseResourceDirectory(context, (ConfigDir)configDir, (File)dir)) != null) {
                this.loadSchemas(schemasDir.getAbsolutePath(), databaseName, context);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSchemas(String schemasPath, String schemasDatabaseName, CommandContext context) {
        block7: {
            this.logger.info(this.format("Loading schemas into database %s from: %s", new Object[]{schemasDatabaseName, schemasPath}));
            DatabaseClient schemasClient = context.getAppConfig().newAppServicesDatabaseClient(schemasDatabaseName);
            DatabaseClient contentClient = this.buildContentClient(context, schemasDatabaseName);
            try {
                SchemasLoader schemasLoader = this.buildSchemasLoader(context, schemasClient, contentClient);
                schemasLoader.loadSchemas(new String[]{schemasPath});
                this.logger.info("Finished loading schemas from: " + schemasPath);
            }
            catch (FailedRequestException fre) {
                if (fre.getMessage().contains("NOSUCHDB")) {
                    this.logger.warn("Unable to load schemas because no schemas database exists; cause: " + fre.getMessage());
                    break block7;
                }
                throw fre;
            }
            finally {
                schemasClient.release();
                if (contentClient != null) {
                    contentClient.release();
                }
            }
        }
    }

    private DatabaseClient buildContentClient(CommandContext context, String schemasDatabase) {
        String contentDatabase = this.findContentDatabaseAssociatedWithSchemasDatabase(context, schemasDatabase);
        if (contentDatabase != null) {
            this.logger.info(this.format("Will use %s as a content database when loading into schemas database: %s", new Object[]{contentDatabase, schemasDatabase}));
            return context.getAppConfig().newAppServicesDatabaseClient(contentDatabase);
        }
        this.logger.warn(this.format("Unable to find a content database associated with schemas database: %s; this may result in errors when loading TDE templates and Query-Based-View scripts.", new Object[]{schemasDatabase}));
        return null;
    }

    protected SchemasLoader buildSchemasLoader(CommandContext context, DatabaseClient schemasClient, DatabaseClient contentClient) {
        AppConfig appConfig = context.getAppConfig();
        DefaultSchemasLoader schemasLoader = new DefaultSchemasLoader(schemasClient, contentClient, context.getAppConfig().isTdeValidationEnabled());
        schemasLoader.setCascadeCollections(appConfig.isCascadeCollections());
        schemasLoader.setCascadePermissions(appConfig.isCascadePermissions());
        FileFilter filter = appConfig.getSchemasFileFilter();
        if (filter != null) {
            schemasLoader.addFileFilter(filter);
        }
        if (appConfig.isReplaceTokensInModules()) {
            schemasLoader.setTokenReplacer(appConfig.buildTokenReplacer());
        }
        return schemasLoader;
    }

    protected String findContentDatabaseAssociatedWithSchemasDatabase(CommandContext context, String schemasDatabaseName) {
        String tdeValidationDatabase = null;
        DefaultResourceMapper resourceMapper = new DefaultResourceMapper(new API(context.getManageClient()));
        block2: for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
            File dbDir = configDir.getDatabasesDir();
            if (dbDir == null || !dbDir.exists()) continue;
            for (File f : this.listFilesInDirectory(dbDir)) {
                String payload = this.copyFileToString(f, context);
                try {
                    Database db = resourceMapper.readResource(payload, Database.class);
                    if (!schemasDatabaseName.equals(db.getSchemaDatabase())) continue;
                    tdeValidationDatabase = db.getDatabaseName();
                    continue block2;
                }
                catch (Exception ex) {
                    this.logger.warn("Unexpected error when reading database file to determine database for TDE validation: " + ex.getMessage());
                }
            }
        }
        return tdeValidationDatabase;
    }
}

