/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.restapis;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.UndoableCommand;
import com.marklogic.appdeployer.util.RestApiUtil;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.admin.ActionRequiringRestart;
import com.marklogic.mgmt.resource.appservers.ServerManager;
import com.marklogic.mgmt.resource.restapis.RestApiDeletionRequest;
import com.marklogic.mgmt.resource.restapis.RestApiManager;
import java.io.File;

public class DeployRestApiServersCommand
extends AbstractCommand
implements UndoableCommand {
    private boolean deleteModulesDatabase = true;
    private boolean deleteContentDatabase = false;
    private boolean deleteModulesReplicaForests = true;
    private boolean deleteContentReplicaForests = true;
    private String restApiFilename;

    public DeployRestApiServersCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_REST_API_SERVERS);
    }

    public DeployRestApiServersCommand(String restApiFilename) {
        this();
        this.restApiFilename = restApiFilename;
    }

    public DeployRestApiServersCommand(boolean deleteContentDatabase) {
        this();
        this.deleteContentDatabase = deleteContentDatabase;
    }

    public DeployRestApiServersCommand(String restApiFilename, boolean deleteContentDatabase) {
        this();
        this.restApiFilename = restApiFilename;
        this.deleteContentDatabase = deleteContentDatabase;
    }

    @Override
    public Integer getUndoSortOrder() {
        return SortOrderConstants.DELETE_REST_API_SERVERS;
    }

    @Override
    public void execute(CommandContext context) {
        String payload = this.getRestApiPayload(context);
        if (payload != null) {
            AppConfig appConfig = context.getAppConfig();
            RestApiManager mgr = new RestApiManager(context.getManageClient(), appConfig.getGroupName());
            mgr.createRestApi(this.payloadTokenReplacer.replaceTokens(payload, appConfig, false));
            if (appConfig.isTestPortSet()) {
                mgr.createRestApi(this.payloadTokenReplacer.replaceTokens(payload, appConfig, true));
            }
        }
    }

    protected String getRestApiPayload(CommandContext context) {
        File f = this.findRestApiConfigFile(context);
        if (f != null && f.exists()) {
            return this.copyFileToString(f);
        }
        if (context.getAppConfig().isNoRestServer()) {
            this.logger.info(this.format("Could not find REST API file at %s, will not deploy/undeploy a REST API server", new Object[]{f.getAbsolutePath()}));
            return null;
        }
        this.logger.info(this.format("Could not find REST API file at %s, will use default payload", new Object[]{f.getAbsolutePath()}));
        return this.getDefaultRestApiPayload(context);
    }

    protected File findRestApiConfigFile(CommandContext context) {
        if (this.restApiFilename != null) {
            File restApiFile = null;
            for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
                File f = new File(configDir.getBaseDir(), this.restApiFilename);
                if (!f.exists()) continue;
                restApiFile = f;
            }
            if (restApiFile == null) {
                restApiFile = new File(context.getAppConfig().getFirstConfigDir().getBaseDir(), this.restApiFilename);
            }
            return restApiFile;
        }
        File restApiFile = null;
        for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
            File f = configDir.getRestApiFile();
            if (f == null || !f.exists()) continue;
            restApiFile = f;
        }
        if (restApiFile == null) {
            restApiFile = context.getAppConfig().getFirstConfigDir().getRestApiFile();
        }
        return restApiFile;
    }

    @Override
    public void undo(CommandContext context) {
        this.deleteTestRestServer(context);
        this.deleteMainRestServer(context);
    }

    protected void deleteTestRestServer(CommandContext context) {
        final AppConfig appConfig = context.getAppConfig();
        final ManageClient manageClient = context.getManageClient();
        ServerManager mgr = new ServerManager(manageClient, appConfig.getGroupName());
        if (appConfig.isTestPortSet() && mgr.exists(appConfig.getTestRestServerName(), new String[0])) {
            mgr.setModulesDatabaseToDocuments(appConfig.getTestRestServerName());
            context.getAdminManager().invokeActionRequiringRestart(new ActionRequiringRestart(){

                @Override
                public boolean execute() {
                    return DeployRestApiServersCommand.this.deleteRestApi(appConfig.getTestRestServerName(), appConfig.getGroupName(), manageClient, false, true);
                }
            });
        }
    }

    protected void deleteMainRestServer(CommandContext context) {
        String serverName;
        final AppConfig appConfig = context.getAppConfig();
        final ManageClient manageClient = context.getManageClient();
        ServerManager mgr = new ServerManager(manageClient, appConfig.getGroupName());
        String payload = this.getRestApiPayload(context);
        if (payload != null && mgr.exists(serverName = new RestApiManager(manageClient).extractNameFromJson(payload = this.payloadTokenReplacer.replaceTokens(payload, appConfig, false)), new String[0])) {
            context.getAdminManager().invokeActionRequiringRestart(new ActionRequiringRestart(){

                @Override
                public boolean execute() {
                    return DeployRestApiServersCommand.this.deleteRestApi(serverName, appConfig.getGroupName(), manageClient, DeployRestApiServersCommand.this.deleteModulesDatabase, DeployRestApiServersCommand.this.deleteContentDatabase);
                }
            });
        }
    }

    protected String getDefaultRestApiPayload(CommandContext context) {
        Integer count = context.getAppConfig().getContentForestsPerHost();
        return count != null ? RestApiUtil.buildDefaultRestApiJson(count) : RestApiUtil.buildDefaultRestApiJson();
    }

    protected boolean deleteRestApi(String serverName, String groupName, ManageClient manageClient, boolean includeModules, boolean includeContent) {
        RestApiDeletionRequest request = new RestApiDeletionRequest(serverName, groupName);
        request.setIncludeContent(includeContent);
        request.setIncludeModules(includeModules);
        request.setDeleteContentReplicaForests(this.isDeleteContentReplicaForests());
        request.setDeleteModulesReplicaForests(this.isDeleteModulesReplicaForests());
        return new RestApiManager(manageClient, groupName).deleteRestApi(request);
    }

    public boolean isDeleteModulesDatabase() {
        return this.deleteModulesDatabase;
    }

    public void setDeleteModulesDatabase(boolean includesModules) {
        this.deleteModulesDatabase = includesModules;
    }

    public boolean isDeleteContentDatabase() {
        return this.deleteContentDatabase;
    }

    public void setDeleteContentDatabase(boolean includeContent) {
        this.deleteContentDatabase = includeContent;
    }

    public String getRestApiFilename() {
        return this.restApiFilename;
    }

    public void setRestApiFilename(String restApiFilename) {
        this.restApiFilename = restApiFilename;
    }

    public boolean isDeleteModulesReplicaForests() {
        return this.deleteModulesReplicaForests;
    }

    public void setDeleteModulesReplicaForests(boolean deleteModulesReplicaForests) {
        this.deleteModulesReplicaForests = deleteModulesReplicaForests;
    }

    public boolean isDeleteContentReplicaForests() {
        return this.deleteContentReplicaForests;
    }

    public void setDeleteContentReplicaForests(boolean deleteContentReplicaForests) {
        this.deleteContentReplicaForests = deleteContentReplicaForests;
    }
}

