/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.flexrep;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.UndoableCommand;
import com.marklogic.appdeployer.command.appservers.DeployOtherServersCommand;
import com.marklogic.appdeployer.command.cpf.DeployCpfConfigsCommand;
import com.marklogic.appdeployer.command.cpf.DeployDomainsCommand;
import com.marklogic.appdeployer.command.cpf.DeployPipelinesCommand;
import com.marklogic.appdeployer.command.flexrep.DeployConfigsCommand;
import com.marklogic.appdeployer.command.flexrep.DeployTargetsCommand;
import com.marklogic.appdeployer.impl.SimpleAppDeployer;
import java.io.File;

public class DeployFlexrepCommand
extends AbstractCommand
implements UndoableCommand {
    public DeployFlexrepCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_OTHER_SERVERS);
    }

    @Override
    public Integer getUndoSortOrder() {
        return SortOrderConstants.DELETE_OTHER_SERVERS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandContext context) {
        AppConfig appConfig = context.getAppConfig();
        File flexrepBaseDir = this.getFlexrepBaseDir(appConfig);
        if (flexrepBaseDir != null) {
            SimpleAppDeployer d = new SimpleAppDeployer(context.getManageClient(), context.getAdminManager(), new DeployCpfConfigsCommand(), new DeployDomainsCommand(), new DeployPipelinesCommand(), new DeployConfigsCommand(), new DeployTargetsCommand(), new DeployOtherServersCommand());
            for (ConfigDir configDir : appConfig.getConfigDirs()) {
                File currentBaseDir = configDir.getBaseDir();
                configDir.setBaseDir(flexrepBaseDir);
                try {
                    d.deploy(appConfig);
                }
                finally {
                    configDir.setBaseDir(currentBaseDir);
                }
            }
        } else {
            this.logResourceDirectoryNotFound(flexrepBaseDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo(CommandContext context) {
        AppConfig appConfig = context.getAppConfig();
        File flexrepBaseDir = this.getFlexrepBaseDir(appConfig);
        if (flexrepBaseDir != null) {
            SimpleAppDeployer d = new SimpleAppDeployer(context.getManageClient(), context.getAdminManager(), new DeployOtherServersCommand());
            for (ConfigDir configDir : appConfig.getConfigDirs()) {
                File currentBaseDir = configDir.getBaseDir();
                configDir.setBaseDir(flexrepBaseDir);
                try {
                    d.undeploy(appConfig);
                }
                finally {
                    configDir.setBaseDir(currentBaseDir);
                }
            }
        }
    }

    protected File getFlexrepBaseDir(AppConfig appConfig) {
        String path = appConfig.getFlexrepPath();
        if (path == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Flexrep path not configured, so not attempting to find any Flexrep resources to deploy");
            }
            return null;
        }
        File flexrepBaseDir = null;
        for (ConfigDir configDir : appConfig.getConfigDirs()) {
            File flexrepDir = configDir.getFlexrepDir();
            if (flexrepDir == null || !flexrepDir.exists()) {
                this.logResourceDirectoryNotFound(flexrepDir);
                continue;
            }
            File tmp = new File(flexrepDir, path);
            if (tmp == null || !tmp.exists()) continue;
            flexrepBaseDir = tmp;
        }
        return flexrepBaseDir;
    }
}

