/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.databases;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractUndoableCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.ResourceFilenameFilter;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.databases.DatabasePlan;
import com.marklogic.appdeployer.command.databases.DatabasePlans;
import com.marklogic.appdeployer.command.databases.DefaultDeployDatabaseCommandFactory;
import com.marklogic.appdeployer.command.databases.DeployDatabaseCommand;
import com.marklogic.appdeployer.command.databases.DeployDatabaseCommandFactory;
import com.marklogic.appdeployer.command.forests.DeployForestsCommand;
import com.marklogic.mgmt.PayloadParser;
import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.configuration.Configuration;
import com.marklogic.mgmt.api.configuration.Configurations;
import com.marklogic.mgmt.api.database.Database;
import com.marklogic.mgmt.api.database.DatabaseSorter;
import com.marklogic.mgmt.mapper.DefaultResourceMapper;
import com.marklogic.mgmt.resource.databases.DatabaseManager;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import com.marklogic.rest.util.JsonNodeUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DeployOtherDatabasesCommand
extends AbstractUndoableCommand {
    private Integer forestsPerHost;
    private boolean checkForCustomForests = true;
    private String forestFilename;
    private boolean createForestsOnEachHost = true;
    private Set<String> defaultDatabasesToNotUndeploy = new HashSet<String>();
    private DeployDatabaseCommandFactory deployDatabaseCommandFactory = new DefaultDeployDatabaseCommandFactory();
    private PayloadParser payloadParser = new PayloadParser();

    public DeployOtherDatabasesCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_OTHER_DATABASES);
        this.setUndoSortOrder(SortOrderConstants.DELETE_OTHER_DATABASES);
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_OTHER_DATABASES);
        this.setUndoSortOrder(SortOrderConstants.DELETE_OTHER_DATABASES);
        this.initializeDefaultDatabasesToNotUndeploy();
        this.setResourceClassType(Database.class);
    }

    public DeployOtherDatabasesCommand(int forestsPerHost) {
        this();
        this.setForestsPerHost(forestsPerHost);
    }

    protected void initializeDefaultDatabasesToNotUndeploy() {
        this.defaultDatabasesToNotUndeploy = new HashSet<String>();
        this.defaultDatabasesToNotUndeploy.add("App-Services");
        this.defaultDatabasesToNotUndeploy.add("Documents");
        this.defaultDatabasesToNotUndeploy.add("Extensions");
        this.defaultDatabasesToNotUndeploy.add("Fab");
        this.defaultDatabasesToNotUndeploy.add("Last-Login");
        this.defaultDatabasesToNotUndeploy.add("Meters");
        this.defaultDatabasesToNotUndeploy.add("Modules");
        this.defaultDatabasesToNotUndeploy.add("Schemas");
        this.defaultDatabasesToNotUndeploy.add("Security");
        this.defaultDatabasesToNotUndeploy.add("Triggers");
    }

    @Override
    public void execute(CommandContext context) {
        List<DatabasePlan> databasePlans = this.buildDatabasePlans(context);
        if (context.getAppConfig().isSortOtherDatabaseByDependencies()) {
            databasePlans = this.sortDatabasePlans(databasePlans);
        } else {
            this.logger.info("Not sorting databases by dependencies, will sort them by their filenames instead");
        }
        if (context.getAppConfig().getCmaConfig().isDeployDatabases()) {
            this.deployDatabasesAndForestsViaCma(context, databasePlans);
        } else {
            databasePlans.forEach(databasePlan -> databasePlan.getDeployDatabaseCommand().execute(context));
            if (context.getAppConfig().getCmaConfig().isDeployForests()) {
                this.deployAllForestsInSingleCmaRequest(context, databasePlans);
            } else {
                databasePlans.forEach(databasePlan -> {
                    DeployForestsCommand dfc = databasePlan.getDeployDatabaseCommand().getDeployForestsCommand();
                    if (dfc != null) {
                        dfc.execute(context);
                    }
                });
            }
        }
    }

    @Override
    public void undo(CommandContext context) {
        List<DatabasePlan> databasePlans = this.buildDatabasePlans(context);
        if (context.getAppConfig().isSortOtherDatabaseByDependencies()) {
            databasePlans = this.sortDatabasePlans(databasePlans);
            Collections.reverse(databasePlans);
        } else {
            this.logger.info("Not sorting databases by dependencies, will sort them by their filenames instead");
        }
        databasePlans.forEach(databasePlan -> databasePlan.getDeployDatabaseCommand().undo(context));
        if (this.deleteContentDatabaseOnUndo(databasePlans, context.getAppConfig())) {
            DatabaseManager dbMgr = new DeployDatabaseCommand().newDatabaseManageForDeleting(context);
            dbMgr.deleteByName(context.getAppConfig().getContentDatabaseName());
        }
    }

    protected boolean deleteContentDatabaseOnUndo(List<DatabasePlan> databasePlans, AppConfig appConfig) {
        if (databasePlans == null || databasePlans.isEmpty()) {
            Set<String> filenamesToIgnore;
            FilenameFilter filter = this.getResourceFilenameFilter();
            if (filter != null && filter instanceof ResourceFilenameFilter && (filenamesToIgnore = ((ResourceFilenameFilter)filter).getFilenamesToIgnore()) != null && !filenamesToIgnore.isEmpty() && appConfig.getConfigDirs() != null) {
                for (ConfigDir configDir : appConfig.getConfigDirs()) {
                    if (!filenamesToIgnore.contains(configDir.getDefaultContentDatabaseFilename())) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public List<DatabasePlan> buildDatabasePlans(CommandContext context) {
        DatabasePlans databasePlan = new DatabasePlans();
        for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
            this.addDatabaseFiles(context, configDir, databasePlan);
        }
        List<DatabasePlan> databasePlans = this.mergeDatabasePlanFiles(context, databasePlan);
        this.buildDeployDatabaseCommands(context, databasePlans);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Logging the files for each database before it's created or updated:");
            databasePlans.forEach(plan -> this.logger.debug(plan + "\n"));
        }
        return databasePlans;
    }

    protected void addDatabaseFiles(CommandContext context, ConfigDir configDir, DatabasePlans databasePlans) {
        String contentDatabaseFilename = configDir.getDefaultContentDatabaseFilename();
        File dir = configDir.getDatabasesDir();
        if (dir != null && dir.exists()) {
            for (File f : this.listFilesInDirectory(dir)) {
                String payload = this.copyFileToString(f, context);
                String databaseName = this.payloadParser.getPayloadFieldValue(payload, "database-name", false);
                if (databaseName == null) continue;
                boolean isMainContentDatabase = false;
                if (databasePlans.getMainContentDatabaseName() == null && f.getName().equals(contentDatabaseFilename)) {
                    databasePlans.setMainContentDatabaseName(databaseName);
                    isMainContentDatabase = true;
                }
                if (databasePlans.getDatabasePlanMap().containsKey(databaseName)) {
                    DatabasePlan reference = databasePlans.getDatabasePlanMap().get(databaseName);
                    reference.addFile(f);
                    if (reference.isMainContentDatabase() || !isMainContentDatabase) continue;
                    reference.setMainContentDatabase(isMainContentDatabase);
                    continue;
                }
                databasePlans.getDatabasePlanMap().put(databaseName, new DatabasePlan(databaseName, f, isMainContentDatabase));
            }
        } else {
            this.logResourceDirectoryNotFound(dir);
        }
    }

    protected List<DatabasePlan> mergeDatabasePlanFiles(CommandContext context, DatabasePlans databasePlans) {
        DefaultResourceMapper resourceMapper = new DefaultResourceMapper(new API(context.getManageClient()));
        ObjectReader objectReader = ObjectMapperFactory.getObjectMapper().readerFor(Database.class);
        ArrayList<DatabasePlan> databasePlanList = new ArrayList<DatabasePlan>();
        databasePlanList.addAll(databasePlans.getDatabasePlanMap().values());
        DatabasePlan testDatabasePlan = null;
        String testContentDatabaseName = context.getAppConfig().getTestContentDatabaseName();
        for (DatabasePlan reference : databasePlanList) {
            List<File> files;
            boolean createTestDatabase;
            boolean bl = createTestDatabase = reference.isMainContentDatabase() && context.getAppConfig().isTestPortSet();
            if (createTestDatabase) {
                testDatabasePlan = new DatabasePlan(testContentDatabaseName, reference.getFiles());
            }
            if ((files = reference.getFiles()).size() == 1) {
                String payload = this.copyFileToString(files.get(0), context);
                reference.setPayload(payload);
                reference.setDatabaseForSorting(resourceMapper.readResource(payload, Database.class));
                if (!createTestDatabase) continue;
                String testPayload = this.payloadTokenReplacer.replaceTokens(this.copyFileToString(files.get(0)), context.getAppConfig(), true);
                testDatabasePlan.setPayload(testPayload);
                Database testDb = resourceMapper.readResource(payload, Database.class);
                testDb.setDatabaseName(testContentDatabaseName);
                testDatabasePlan.setDatabaseForSorting(testDb);
                continue;
            }
            ArrayList nodes = new ArrayList();
            files.forEach(file -> {
                String payload = this.copyFileToString((File)file, context);
                nodes.add(this.convertPayloadToObjectNode(context, payload));
            });
            ObjectNode mergedNode = JsonNodeUtil.mergeObjectNodes(nodes.toArray(new ObjectNode[0]));
            reference.setMergedObjectNode(mergedNode);
            try {
                reference.setDatabaseForSorting((Database)objectReader.readValue((JsonNode)mergedNode));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read ObjectNode into Database class, cause: " + e.getMessage(), e);
            }
            if (!createTestDatabase) continue;
            ArrayList testNodes = new ArrayList();
            files.forEach(file -> {
                String testPayload = this.payloadTokenReplacer.replaceTokens(this.copyFileToString((File)file), context.getAppConfig(), true);
                testNodes.add(this.convertPayloadToObjectNode(context, testPayload));
            });
            ObjectNode mergedTestNode = JsonNodeUtil.mergeObjectNodes(testNodes.toArray(new ObjectNode[0]));
            testDatabasePlan.setMergedObjectNode(mergedTestNode);
            try {
                testDatabasePlan.setDatabaseForSorting((Database)objectReader.readValue((JsonNode)mergedTestNode));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read ObjectNode into Database class, cause: " + e.getMessage(), e);
            }
        }
        if (testDatabasePlan != null) {
            databasePlanList.add(testDatabasePlan);
            testDatabasePlan.setTestContentDatabase(true);
        }
        return databasePlanList;
    }

    protected List<DatabasePlan> sortDatabasePlans(List<DatabasePlan> databasePlans) {
        ArrayList<Database> databases = new ArrayList<Database>();
        HashMap map = new HashMap();
        databasePlans.forEach(plan -> {
            databases.add(plan.getDatabaseForSorting());
            map.put(plan.getDatabaseName(), plan);
        });
        String[] sortedNames = new DatabaseSorter().sortDatabasesAndReturnNames(databases);
        ArrayList<DatabasePlan> sortedList = new ArrayList<DatabasePlan>();
        for (String name : sortedNames) {
            sortedList.add((DatabasePlan)map.get(name));
        }
        return sortedList;
    }

    protected void buildDeployDatabaseCommands(CommandContext context, List<DatabasePlan> databasePlans) {
        databasePlans.forEach(databasePlan -> {
            DeployDatabaseCommand command = this.deployDatabaseCommandFactory.newDeployDatabaseCommand(databasePlan.getLastFile());
            command.setCheckForCustomForests(this.isCheckForCustomForests());
            command.setCreateForestsOnEachHost(this.isCreateForestsOnEachHost());
            command.setDatabasesToNotUndeploy(this.getDefaultDatabasesToNotUndeploy());
            if (databasePlan.isMainContentDatabase() || databasePlan.isTestContentDatabase()) {
                Integer contentForestsPerHost = context.getAppConfig().getContentForestsPerHost();
                if (contentForestsPerHost != null) {
                    command.setForestsPerHost(contentForestsPerHost);
                } else if (this.forestsPerHost != null) {
                    command.setForestsPerHost(this.forestsPerHost);
                } else {
                    command.setForestsPerHost(3);
                }
                command.setForestFilename("content-forest.json");
            } else {
                if (this.forestsPerHost != null) {
                    command.setForestsPerHost(this.forestsPerHost);
                }
                command.setForestFilename(this.getForestFilename());
            }
            command.setPayload(databasePlan.getPayload());
            command.setPostponeForestCreation(context.getAppConfig().getCmaConfig().isDeployForests());
            databasePlan.setDeployDatabaseCommand(command);
        });
    }

    protected void deployDatabasesAndForestsViaCma(CommandContext context, List<DatabasePlan> databasePlans) {
        Configuration dbConfig = new Configuration();
        Configuration forestConfig = new Configuration();
        databasePlans.forEach(plan -> {
            DeployDatabaseCommand deployDatabaseCommand = plan.getDeployDatabaseCommand();
            String payload = deployDatabaseCommand.buildPayloadForSaving(context);
            dbConfig.addDatabase(this.convertPayloadToObjectNode(context, payload));
            DeployForestsCommand deployForestsCommand = deployDatabaseCommand.buildDeployForestsCommand(plan.getDatabaseName(), context);
            if (deployForestsCommand != null) {
                deployForestsCommand.buildForests(context, false).forEach(forest -> forestConfig.addForest(forest.toObjectNode()));
            }
        });
        new Configurations(dbConfig, forestConfig).submit(context.getManageClient());
        databasePlans.forEach(plan -> plan.getDeployDatabaseCommand().deploySubDatabases(plan.getDatabaseName(), context));
    }

    protected void deployAllForestsInSingleCmaRequest(CommandContext context, List<DatabasePlan> databasePlans) {
        ArrayList allForests = new ArrayList();
        databasePlans.forEach(plan -> {
            DeployForestsCommand dfc = plan.getDeployDatabaseCommand().getDeployForestsCommand();
            if (dfc != null) {
                allForests.addAll(dfc.buildForests(context, false));
            }
        });
        if (!allForests.isEmpty()) {
            Configuration config = new Configuration();
            allForests.forEach(forest -> config.addForest(forest.toObjectNode()));
            new Configurations(config).submit(context.getManageClient());
        }
    }

    public void setDeployDatabaseCommandFactory(DeployDatabaseCommandFactory deployDatabaseCommandFactory) {
        this.deployDatabaseCommandFactory = deployDatabaseCommandFactory;
    }

    public Integer getForestsPerHost() {
        return this.forestsPerHost;
    }

    public void setForestsPerHost(Integer forestsPerHost) {
        this.forestsPerHost = forestsPerHost;
    }

    public boolean isCheckForCustomForests() {
        return this.checkForCustomForests;
    }

    public void setCheckForCustomForests(boolean checkForCustomForests) {
        this.checkForCustomForests = checkForCustomForests;
    }

    public String getForestFilename() {
        return this.forestFilename;
    }

    public void setForestFilename(String forestFilename) {
        this.forestFilename = forestFilename;
    }

    public boolean isCreateForestsOnEachHost() {
        return this.createForestsOnEachHost;
    }

    public void setCreateForestsOnEachHost(boolean createForestsOnEachHost) {
        this.createForestsOnEachHost = createForestsOnEachHost;
    }

    public Set<String> getDefaultDatabasesToNotUndeploy() {
        return this.defaultDatabasesToNotUndeploy;
    }

    public void setDefaultDatabasesToNotUndeploy(Set<String> defaultDatabasesToNotUndeploy) {
        this.defaultDatabasesToNotUndeploy = defaultDatabasesToNotUndeploy;
    }
}

