/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.alert;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.PayloadParser;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.alert.AlertRuleManager;
import java.io.File;

public class DeployAlertRulesCommand
extends AbstractCommand {
    private String rulesDirectorySuffix = "-rules";
    private PayloadParser payloadParser = new PayloadParser();

    public DeployAlertRulesCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_ALERT_RULES);
    }

    @Override
    public void execute(CommandContext context) {
        AppConfig appConfig = context.getAppConfig();
        for (ConfigDir configDir : appConfig.getConfigDirs()) {
            this.deployRules(context, configDir, appConfig.getContentDatabaseName());
            for (File dir : configDir.getDatabaseResourceDirectories()) {
                String databaseName = this.determineDatabaseNameForDatabaseResourceDirectory(context, configDir, dir);
                if (databaseName == null) continue;
                this.deployRules(context, new ConfigDir(dir), databaseName);
            }
        }
    }

    protected void deployRules(CommandContext context, ConfigDir configDir, String databaseIdOrName) {
        File configsDir = configDir.getAlertConfigsDir();
        if (configsDir != null && configsDir.exists()) {
            for (File f : configsDir.listFiles()) {
                if (!f.isDirectory() || !f.getName().endsWith(this.rulesDirectorySuffix)) continue;
                this.deployRulesInDirectory(f, context, databaseIdOrName);
            }
        } else {
            this.logResourceDirectoryNotFound(configsDir);
        }
    }

    protected void deployRulesInDirectory(File dir, CommandContext context, String databaseIdOrName) {
        String configUri = this.extractConfigUriFromDirectory(dir);
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format("Deploying alert rules with config URI '%s' in directory: %s", new Object[]{configUri, dir.getAbsolutePath()}));
        }
        for (File f : this.listFilesInDirectory(dir)) {
            String payload = this.copyFileToString(f, context);
            String actionName = this.payloadParser.getPayloadFieldValue(payload, "action-name");
            AlertRuleManager mgr = new AlertRuleManager(context.getManageClient(), databaseIdOrName, configUri, actionName);
            this.saveResource((ResourceManager)mgr, context, f);
        }
    }

    protected String extractConfigUriFromDirectory(File dir) {
        String name = dir.getName();
        return name.substring(0, name.length() - this.rulesDirectorySuffix.length());
    }

    public void setRulesDirectorySuffix(String targetDirectorySuffix) {
        this.rulesDirectorySuffix = targetDirectorySuffix;
    }

    public void setPayloadParser(PayloadParser payloadParser) {
        this.payloadParser = payloadParser;
    }
}

