/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command;

import com.marklogic.appdeployer.command.ResourceFileManager;
import com.marklogic.client.ext.modulesloader.impl.PropertiesModuleManager;
import java.io.File;
import java.util.Date;

public class ResourceFileManagerImpl
extends PropertiesModuleManager
implements ResourceFileManager {
    public static final String DEFAULT_FILE_PATH = "build/com.marklogic.ml-app-deployer/resource-timestamps.properties";

    public ResourceFileManagerImpl() {
        this(DEFAULT_FILE_PATH);
    }

    public ResourceFileManagerImpl(String propertiesFilePath) {
        super(propertiesFilePath);
    }

    @Override
    public boolean shouldResourceFileBeProcessed(File file) {
        this.initialize();
        boolean shouldBeProcessed = this.hasFileBeenModifiedSinceLastLoaded(file);
        if (shouldBeProcessed) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("File is new or has been modified: " + file.getAbsolutePath());
            }
            super.saveLastLoadedTimestamp(file, new Date());
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("File is neither new nor modified: " + file.getAbsolutePath());
        }
        return shouldBeProcessed;
    }
}

