/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command;

import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.Command;
import com.marklogic.appdeployer.command.alert.DeployAlertActionsCommand;
import com.marklogic.appdeployer.command.alert.DeployAlertConfigsCommand;
import com.marklogic.appdeployer.command.alert.DeployAlertRulesCommand;
import com.marklogic.appdeployer.command.appservers.DeployOtherServersCommand;
import com.marklogic.appdeployer.command.appservers.UpdateRestApiServersCommand;
import com.marklogic.appdeployer.command.clusters.ModifyLocalClusterCommand;
import com.marklogic.appdeployer.command.cma.DeployConfigurationsCommand;
import com.marklogic.appdeployer.command.cpf.AbstractCpfResourceCommand;
import com.marklogic.appdeployer.command.cpf.DeployCpfConfigsCommand;
import com.marklogic.appdeployer.command.cpf.DeployDomainsCommand;
import com.marklogic.appdeployer.command.cpf.DeployPipelinesCommand;
import com.marklogic.appdeployer.command.data.LoadDataCommand;
import com.marklogic.appdeployer.command.databases.DeployOtherDatabasesCommand;
import com.marklogic.appdeployer.command.flexrep.DeployConfigsCommand;
import com.marklogic.appdeployer.command.flexrep.DeployFlexrepCommand;
import com.marklogic.appdeployer.command.flexrep.DeployTargetsCommand;
import com.marklogic.appdeployer.command.forests.ConfigureForestReplicasCommand;
import com.marklogic.appdeployer.command.forests.DeployCustomForestsCommand;
import com.marklogic.appdeployer.command.groups.DeployGroupsCommand;
import com.marklogic.appdeployer.command.hosts.AssignHostsToGroupsCommand;
import com.marklogic.appdeployer.command.mimetypes.DeployMimetypesCommand;
import com.marklogic.appdeployer.command.modules.DeleteTestModulesCommand;
import com.marklogic.appdeployer.command.modules.LoadModulesCommand;
import com.marklogic.appdeployer.command.plugins.InstallPluginsCommand;
import com.marklogic.appdeployer.command.rebalancer.DeployPartitionQueriesCommand;
import com.marklogic.appdeployer.command.rebalancer.DeployPartitionsCommand;
import com.marklogic.appdeployer.command.restapis.DeployRestApiServersCommand;
import com.marklogic.appdeployer.command.schemas.LoadSchemasCommand;
import com.marklogic.appdeployer.command.security.DeployAmpsCommand;
import com.marklogic.appdeployer.command.security.DeployCertificateAuthoritiesCommand;
import com.marklogic.appdeployer.command.security.DeployCertificateTemplatesCommand;
import com.marklogic.appdeployer.command.security.DeployCredentialsCommand;
import com.marklogic.appdeployer.command.security.DeployExternalSecurityCommand;
import com.marklogic.appdeployer.command.security.DeployPrivilegeRolesCommand;
import com.marklogic.appdeployer.command.security.DeployPrivilegesCommand;
import com.marklogic.appdeployer.command.security.DeployProtectedCollectionsCommand;
import com.marklogic.appdeployer.command.security.DeployProtectedPathsCommand;
import com.marklogic.appdeployer.command.security.DeployQueryRolesetsCommand;
import com.marklogic.appdeployer.command.security.DeployRolesCommand;
import com.marklogic.appdeployer.command.security.DeploySecureCredentialsCommand;
import com.marklogic.appdeployer.command.security.DeployUsersCommand;
import com.marklogic.appdeployer.command.security.InsertCertificateHostsTemplateCommand;
import com.marklogic.appdeployer.command.tasks.DeployScheduledTasksCommand;
import com.marklogic.appdeployer.command.taskservers.UpdateTaskServerCommand;
import com.marklogic.appdeployer.command.temporal.DeployTemporalAxesCommand;
import com.marklogic.appdeployer.command.temporal.DeployTemporalCollectionsCommand;
import com.marklogic.appdeployer.command.temporal.DeployTemporalCollectionsLSQTCommand;
import com.marklogic.appdeployer.command.triggers.DeployTriggersCommand;
import com.marklogic.appdeployer.command.viewschemas.DeployViewSchemasCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandMapBuilder {
    public Map<String, List<Command>> buildCommandMap() {
        HashMap<String, List<Command>> map = new HashMap<String, List<Command>>();
        this.addCommandsThatDoNotWriteToDatabases(map);
        this.addCommandsThatWriteToDatabases(map);
        return map;
    }

    public Map<String, List<Command>> buildCommandMapForReplicaCluster() {
        HashMap<String, List<Command>> map = new HashMap<String, List<Command>>();
        this.addCommandsThatDoNotWriteToDatabases(map);
        return map;
    }

    public List<Command> getCommandsForReplicaCluster() {
        return this.buildCommandMapForReplicaCluster().values().stream().reduce(new ArrayList(), (a, b) -> {
            a.addAll(b);
            return a;
        });
    }

    private void addCommandsThatDoNotWriteToDatabases(Map<String, List<Command>> map) {
        ArrayList<ModifyLocalClusterCommand> clusterCommands = new ArrayList<ModifyLocalClusterCommand>();
        clusterCommands.add(new ModifyLocalClusterCommand());
        map.put("mlClusterCommands", clusterCommands);
        ArrayList<DeployConfigurationsCommand> configurationCommands = new ArrayList<DeployConfigurationsCommand>();
        configurationCommands.add(new DeployConfigurationsCommand());
        map.put("mlConfigurationCommands", configurationCommands);
        ArrayList<DeployOtherDatabasesCommand> dbCommands = new ArrayList<DeployOtherDatabasesCommand>();
        dbCommands.add(new DeployOtherDatabasesCommand());
        map.put("mlDatabaseCommands", dbCommands);
        ArrayList<DeployCustomForestsCommand> forestCommands = new ArrayList<DeployCustomForestsCommand>();
        forestCommands.add(new DeployCustomForestsCommand());
        map.put("mlForestCommands", forestCommands);
        ArrayList<ConfigureForestReplicasCommand> replicaCommands = new ArrayList<ConfigureForestReplicasCommand>();
        replicaCommands.add(new ConfigureForestReplicasCommand());
        map.put("mlForestReplicaCommands", replicaCommands);
        ArrayList<DeployGroupsCommand> groupCommands = new ArrayList<DeployGroupsCommand>();
        groupCommands.add(new DeployGroupsCommand());
        map.put("mlGroupCommands", groupCommands);
        ArrayList<AssignHostsToGroupsCommand> hostCommands = new ArrayList<AssignHostsToGroupsCommand>();
        hostCommands.add(new AssignHostsToGroupsCommand());
        map.put("mlHostCommands", hostCommands);
        ArrayList<DeployMimetypesCommand> mimetypeCommands = new ArrayList<DeployMimetypesCommand>();
        mimetypeCommands.add(new DeployMimetypesCommand());
        map.put("mlMimetypeCommands", mimetypeCommands);
        ArrayList<InstallPluginsCommand> pluginCommands = new ArrayList<InstallPluginsCommand>();
        pluginCommands.add(new InstallPluginsCommand());
        map.put("mlPluginCommands", pluginCommands);
        ArrayList<AbstractResourceCommand> rebalancerCommands = new ArrayList<AbstractResourceCommand>();
        rebalancerCommands.add(new DeployPartitionsCommand());
        rebalancerCommands.add(new DeployPartitionQueriesCommand());
        map.put("mlRebalancerCommands", rebalancerCommands);
        ArrayList<DeployRestApiServersCommand> restApiCommands = new ArrayList<DeployRestApiServersCommand>();
        restApiCommands.add(new DeployRestApiServersCommand());
        map.put("mlRestApiCommands", restApiCommands);
        ArrayList<AbstractCommand> securityCommands = new ArrayList<AbstractCommand>();
        securityCommands.add(new DeployRolesCommand());
        securityCommands.add(new DeployUsersCommand());
        securityCommands.add(new DeployAmpsCommand());
        securityCommands.add(new DeployCertificateTemplatesCommand());
        securityCommands.add(new DeployCertificateAuthoritiesCommand());
        securityCommands.add(new InsertCertificateHostsTemplateCommand());
        securityCommands.add(new DeployExternalSecurityCommand());
        securityCommands.add(new DeploySecureCredentialsCommand());
        securityCommands.add(new DeployCredentialsCommand());
        securityCommands.add(new DeployPrivilegesCommand());
        securityCommands.add(new DeployPrivilegeRolesCommand());
        securityCommands.add(new DeployProtectedCollectionsCommand());
        securityCommands.add(new DeployProtectedPathsCommand());
        securityCommands.add(new DeployQueryRolesetsCommand());
        map.put("mlSecurityCommands", securityCommands);
        ArrayList<AbstractCommand> serverCommands = new ArrayList<AbstractCommand>();
        serverCommands.add(new DeployOtherServersCommand());
        serverCommands.add(new UpdateRestApiServersCommand());
        map.put("mlServerCommands", serverCommands);
        ArrayList<AbstractCommand> taskCommands = new ArrayList<AbstractCommand>();
        taskCommands.add(new DeployScheduledTasksCommand());
        taskCommands.add(new UpdateTaskServerCommand());
        map.put("mlTaskCommands", taskCommands);
    }

    private void addCommandsThatWriteToDatabases(Map<String, List<Command>> map) {
        ArrayList<AbstractCommand> alertCommands = new ArrayList<AbstractCommand>();
        alertCommands.add(new DeployAlertConfigsCommand());
        alertCommands.add(new DeployAlertActionsCommand());
        alertCommands.add(new DeployAlertRulesCommand());
        map.put("mlAlertCommands", alertCommands);
        ArrayList<AbstractCpfResourceCommand> cpfCommands = new ArrayList<AbstractCpfResourceCommand>();
        cpfCommands.add(new DeployCpfConfigsCommand());
        cpfCommands.add(new DeployDomainsCommand());
        cpfCommands.add(new DeployPipelinesCommand());
        map.put("mlCpfCommands", cpfCommands);
        ArrayList<LoadDataCommand> dataCommands = new ArrayList<LoadDataCommand>();
        dataCommands.add(new LoadDataCommand());
        map.put("mlDataCommands", dataCommands);
        ArrayList<AbstractCommand> flexrepCommands = new ArrayList<AbstractCommand>();
        flexrepCommands.add(new DeployConfigsCommand());
        flexrepCommands.add(new DeployTargetsCommand());
        flexrepCommands.add(new DeployFlexrepCommand());
        map.put("mlFlexrepCommands", flexrepCommands);
        ArrayList<AbstractCommand> moduleCommands = new ArrayList<AbstractCommand>();
        moduleCommands.add(new LoadModulesCommand());
        moduleCommands.add(new DeleteTestModulesCommand());
        map.put("mlModuleCommands", moduleCommands);
        ArrayList<LoadSchemasCommand> schemaCommands = new ArrayList<LoadSchemasCommand>();
        schemaCommands.add(new LoadSchemasCommand());
        map.put("mlSchemaCommands", schemaCommands);
        ArrayList<AbstractCommand> temporalCommands = new ArrayList<AbstractCommand>();
        temporalCommands.add(new DeployTemporalAxesCommand());
        temporalCommands.add(new DeployTemporalCollectionsCommand());
        temporalCommands.add(new DeployTemporalCollectionsLSQTCommand());
        map.put("mlTemporalCommands", temporalCommands);
        ArrayList<DeployTriggersCommand> triggerCommands = new ArrayList<DeployTriggersCommand>();
        triggerCommands.add(new DeployTriggersCommand());
        map.put("mlTriggerCommands", triggerCommands);
        ArrayList<DeployViewSchemasCommand> viewCommands = new ArrayList<DeployViewSchemasCommand>();
        viewCommands.add(new DeployViewSchemasCommand());
        map.put("mlViewCommands", viewCommands);
    }
}

