/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractUndoableCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.ResourceDirFinder;
import com.marklogic.appdeployer.command.ResourceReference;
import com.marklogic.appdeployer.command.SupportsCmaCommand;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.api.configuration.Configuration;
import com.marklogic.mgmt.resource.ResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractResourceCommand
extends AbstractUndoableCommand {
    private boolean deleteResourcesOnUndo = true;
    private boolean restartAfterDelete = false;
    private boolean catchExceptionOnDeleteFailure = false;

    protected abstract File[] getResourceDirs(CommandContext var1);

    protected abstract ResourceManager getResourceManager(CommandContext var1);

    @Override
    public void execute(CommandContext context) {
        List references;
        boolean isIncrementalDeploy = context.getAppConfig().isIncrementalDeploy();
        boolean mergeResourcesBeforeSaving = this.resourceMergingIsSupported(context);
        if (mergeResourcesBeforeSaving) {
            this.logger.info("Will read and merge resource files in each config path before saving any resources");
            this.setIncrementalMode(false);
            if (isIncrementalDeploy) {
                this.logger.info("Incremental deploy will not be enabled since files are being read and merged first");
            }
        } else {
            this.setIncrementalMode(isIncrementalDeploy);
        }
        for (File resourceDir : this.getResourceDirs(context)) {
            this.processExecuteOnResourceDir(context, resourceDir);
        }
        if (mergeResourcesBeforeSaving && (references = (List)context.getContextMap().get(this.getContextKeyForResourcesToSave())) != null && !references.isEmpty()) {
            List<ResourceReference> mergedReferences = this.mergeResources(references);
            if (this.useCmaForDeployingResources(context)) {
                this.saveMergedResourcesViaCma(context, mergedReferences);
            } else {
                this.saveMergedResources(context, this.getResourceManager(context), mergedReferences);
            }
        }
    }

    protected File[] findResourceDirs(CommandContext context, ResourceDirFinder resourceDirFinder) {
        return this.findResourceDirs(context.getAppConfig(), resourceDirFinder);
    }

    protected File[] findResourceDirs(AppConfig appConfig, ResourceDirFinder resourceDirFinder) {
        ArrayList<File> list = new ArrayList<File>();
        List<ConfigDir> configDirs = appConfig.getConfigDirs();
        if (configDirs != null && !configDirs.isEmpty()) {
            for (ConfigDir configDir : appConfig.getConfigDirs()) {
                File dir = resourceDirFinder.getResourceDir(configDir);
                if (dir != null && dir.exists()) {
                    list.add(dir);
                    continue;
                }
                this.logResourceDirectoryNotFound(dir);
            }
        } else {
            this.logger.warn("No ConfigDir objects found in AppConfig, unable to find resource directories");
        }
        return list.toArray(new File[0]);
    }

    protected void processExecuteOnResourceDir(CommandContext context, File resourceDir) {
        if (resourceDir.exists()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Processing files in directory: " + resourceDir.getAbsolutePath());
            }
            if (this.useCmaForDeployingResources(context) && !this.resourceMergingIsSupported(context)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Command supports deployment via CMA, so will submit all resources via a single CMA configuration for directory: " + resourceDir);
                }
                this.deployResourcesViaCma(context, resourceDir);
            } else {
                ResourceManager mgr = this.getResourceManager(context);
                for (File resourceFile : this.listFilesInDirectory(resourceDir, context)) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Processing file: " + resourceFile.getAbsolutePath());
                    }
                    SaveReceipt receipt = this.saveResource(mgr, context, resourceFile);
                    this.afterResourceSaved(mgr, context, new ResourceReference(resourceFile, null), receipt);
                }
            }
        } else {
            this.logResourceDirectoryNotFound(resourceDir);
        }
    }

    protected boolean useCmaForDeployingResources(CommandContext context) {
        SupportsCmaCommand command;
        if (this instanceof SupportsCmaCommand && (command = (SupportsCmaCommand)((Object)this)).cmaShouldBeUsed(context)) {
            return this.cmaEndpointExists(context);
        }
        return false;
    }

    protected void deployResourcesViaCma(CommandContext context, File resourceDir) {
        Configuration config = new Configuration();
        for (File f : this.listFilesInDirectory(resourceDir, context)) {
            String payload;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Processing file: " + f.getAbsolutePath());
            }
            if ((payload = this.readResourceFromFile(context, f)) == null || payload.trim().length() <= 0) continue;
            ObjectNode objectNode = this.convertPayloadToObjectNode(context, payload);
            ((SupportsCmaCommand)((Object)this)).addResourceToConfiguration(objectNode, config);
        }
        this.deployConfiguration(context, config);
    }

    protected void saveMergedResourcesViaCma(CommandContext context, List<ResourceReference> mergedReferences) {
        Configuration config = new Configuration();
        for (ResourceReference reference : mergedReferences) {
            ((SupportsCmaCommand)((Object)this)).addResourceToConfiguration(reference.getObjectNode(), config);
        }
        this.deployConfiguration(context, config);
    }

    protected File[] listFilesInDirectory(File resourceDir, CommandContext context) {
        return this.listFilesInDirectory(resourceDir);
    }

    @Override
    public void undo(CommandContext context) {
        if (this.deleteResourcesOnUndo) {
            this.setIncrementalMode(false);
            for (File resourceDir : this.getResourceDirs(context)) {
                this.processUndoOnResourceDir(context, resourceDir);
            }
        }
    }

    protected void processUndoOnResourceDir(CommandContext context, File resourceDir) {
        if (resourceDir.exists()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Processing files in directory: " + resourceDir.getAbsolutePath());
            }
            ResourceManager mgr = this.getResourceManager(context);
            for (File f : this.listFilesInDirectory(resourceDir)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Processing file: " + f.getAbsolutePath());
                }
                this.deleteResource(mgr, context, f);
            }
        }
    }

    protected void deleteResource(ResourceManager mgr, CommandContext context, File f) {
        String payload = this.copyFileToString(f, context);
        ResourceManager resourceManager = this.adjustResourceManagerForPayload(mgr, context, payload);
        String finalPayload = this.adjustPayloadBeforeDeletingResource(resourceManager, context, f, payload);
        if (finalPayload == null) {
            return;
        }
        try {
            if (this.restartAfterDelete) {
                context.getAdminManager().invokeActionRequiringRestart(() -> resourceManager.delete(finalPayload, new String[0]).isDeleted());
            } else {
                resourceManager.delete(finalPayload, new String[0]);
            }
        }
        catch (RuntimeException e) {
            if (this.catchExceptionOnDeleteFailure) {
                this.logger.warn("Caught exception while trying to delete resource; cause: " + e.getMessage());
                if (this.restartAfterDelete) {
                    context.getAdminManager().waitForRestart();
                }
            }
            throw e;
        }
    }

    protected String adjustPayloadBeforeDeletingResource(ResourceManager mgr, CommandContext context, File f, String payload) {
        return payload;
    }

    public void setDeleteResourcesOnUndo(boolean deleteResourceOnUndo) {
        this.deleteResourcesOnUndo = deleteResourceOnUndo;
    }

    public void setRestartAfterDelete(boolean restartAfterDelete) {
        this.restartAfterDelete = restartAfterDelete;
    }

    public boolean isDeleteResourcesOnUndo() {
        return this.deleteResourcesOnUndo;
    }

    public boolean isRestartAfterDelete() {
        return this.restartAfterDelete;
    }

    public void setCatchExceptionOnDeleteFailure(boolean catchExceptionOnDeleteFailure) {
        this.catchExceptionOnDeleteFailure = catchExceptionOnDeleteFailure;
    }
}

