/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer;

import com.marklogic.appdeployer.CmaConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.DataConfig;
import com.marklogic.appdeployer.PluginConfig;
import com.marklogic.appdeployer.command.forests.ForestNamingStrategy;
import com.marklogic.appdeployer.command.forests.ReplicaBuilderStrategy;
import com.marklogic.appdeployer.util.MapPropertiesSource;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.ext.ConfiguredDatabaseClientFactory;
import com.marklogic.client.ext.DatabaseClientConfig;
import com.marklogic.client.ext.DefaultConfiguredDatabaseClientFactory;
import com.marklogic.client.ext.SecurityContextType;
import com.marklogic.client.ext.modulesloader.ssl.SimpleX509TrustManager;
import com.marklogic.client.ext.tokenreplacer.DefaultTokenReplacer;
import com.marklogic.client.ext.tokenreplacer.PropertiesSource;
import com.marklogic.client.ext.tokenreplacer.RoxyTokenReplacer;
import com.marklogic.client.ext.tokenreplacer.TokenReplacer;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.springframework.util.StringUtils;

public class AppConfig {
    public static final String DEFAULT_APP_NAME = "my-app";
    public static final Integer DEFAULT_PORT = 8003;
    public static final String DEFAULT_MODULES_PATH = "src/main/ml-modules";
    public static final String DEFAULT_SCHEMAS_PATH = "src/main/ml-schemas";
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_GROUP = "Default";
    private String name = "my-app";
    @Deprecated
    public static final String DEFAULT_USERNAME = "admin";
    @Deprecated
    public static final String DEFAULT_PASSWORD = "admin";
    private String host = "localhost";
    private String cloudApiKey;
    private boolean catchDeployExceptions = false;
    private boolean catchUndeployExceptions = false;
    private CmaConfig cmaConfig;
    private boolean mergeResources = true;
    private boolean addHostNameTokens = false;
    private ConfiguredDatabaseClientFactory configuredDatabaseClientFactory = new DefaultConfiguredDatabaseClientFactory();
    private DatabaseClient.ConnectionType restConnectionType;
    private SecurityContextType restSecurityContextType = SecurityContextType.DIGEST;
    private String restAdminUsername;
    private String restAdminPassword;
    private SSLContext restSslContext;
    private DatabaseClientFactory.SSLHostnameVerifier restSslHostnameVerifier;
    private String restCertFile;
    private String restCertPassword;
    private String restExternalName;
    private String restSamlToken;
    private X509TrustManager restTrustManager;
    private boolean restUseDefaultKeystore;
    private String restSslProtocol;
    private String restTrustManagementAlgorithm;
    private String restBasePath;
    private String restKeyStorePath;
    private String restKeyStorePassword;
    private String restKeyStoreType;
    private String restKeyStoreAlgorithm;
    private String restTrustStorePath;
    private String restTrustStorePassword;
    private String restTrustStoreType;
    private String restTrustStoreAlgorithm;
    private Integer restPort = DEFAULT_PORT;
    private Integer testRestPort;
    private String testRestBasePath;
    private DatabaseClient.ConnectionType appServicesConnectionType;
    private SecurityContextType appServicesSecurityContextType = SecurityContextType.DIGEST;
    private String appServicesUsername;
    private String appServicesPassword;
    private Integer appServicesPort = 8000;
    private SSLContext appServicesSslContext;
    private DatabaseClientFactory.SSLHostnameVerifier appServicesSslHostnameVerifier;
    private String appServicesCertFile;
    private String appServicesCertPassword;
    private String appServicesExternalName;
    private String appServicesSamlToken;
    private X509TrustManager appServicesTrustManager;
    private boolean appServicesUseDefaultKeystore;
    private String appServicesSslProtocol;
    private String appServicesTrustManagementAlgorithm;
    private String appServicesBasePath;
    private String appServicesKeyStorePath;
    private String appServicesKeyStorePassword;
    private String appServicesKeyStoreType;
    private String appServicesKeyStoreAlgorithm;
    private String appServicesTrustStorePath;
    private String appServicesTrustStorePassword;
    private String appServicesTrustStoreType;
    private String appServicesTrustStoreAlgorithm;
    private String groupName = "Default";
    private boolean noRestServer = false;
    private String restServerName;
    private String testRestServerName;
    private String contentDatabaseName;
    private String testContentDatabaseName;
    private String modulesDatabaseName;
    private String triggersDatabaseName;
    private String cpfDatabaseName;
    private String schemasDatabaseName;
    private boolean cascadeCollections;
    private boolean cascadePermissions;
    private List<String> modulePaths;
    private boolean staticCheckAssets = false;
    private boolean staticCheckLibraryAssets = false;
    private boolean bulkLoadAssets = true;
    private String moduleTimestampsPath;
    private boolean moduleTimestampsUseHost = true;
    private boolean deleteTestModules = false;
    private String deleteTestModulesPattern = "/test/**";
    private int modulesLoaderThreadCount = 1;
    private Integer modulesLoaderBatchSize;
    private String moduleUriPrefix;
    private String modulePermissions = "rest-admin,read,rest-admin,update,rest-extension-user,execute";
    private boolean incrementalDeploy = false;
    private List<String> schemaPaths;
    private boolean tdeValidationEnabled = true;
    private List<ConfigDir> configDirs;
    private Map<String, String> customTokens = new HashMap<String, String>();
    private boolean createForests = true;
    private boolean deleteForests = true;
    private boolean deleteReplicas = true;
    private boolean sortOtherDatabaseByDependencies = true;
    private FileFilter assetFileFilter;
    private FileFilter schemasFileFilter;
    private String[] additionalBinaryExtensions;
    private Integer contentForestsPerHost;
    private Map<String, Integer> databaseNamesAndReplicaCounts;
    private Set<String> databasesWithForestsOnOneHost;
    private Map<String, List<String>> databaseHosts;
    private Map<String, List<String>> databaseGroups;
    private Map<String, String> hostGroups;
    private String forestDataDirectory;
    private String forestFastDataDirectory;
    private String forestLargeDataDirectory;
    private Map<String, List<String>> databaseDataDirectories;
    private Map<String, String> databaseFastDataDirectories;
    private Map<String, String> databaseLargeDataDirectories;
    private Map<String, List<String>> databaseReplicaDataDirectories;
    private Map<String, String> databaseReplicaFastDataDirectories;
    private Map<String, String> databaseReplicaLargeDataDirectories;
    private String replicaForestDataDirectory;
    private String replicaForestLargeDataDirectory;
    private String replicaForestFastDataDirectory;
    private Map<String, ForestNamingStrategy> forestNamingStrategies = new HashMap<String, ForestNamingStrategy>();
    private ReplicaBuilderStrategy replicaBuilderStrategy;
    private String flexrepPath;
    private boolean replaceTokensInModules = true;
    private boolean useRoxyTokenPrefix = false;
    private Pattern moduleFilenamesIncludePattern;
    private Map<String, Integer> forestCounts = new HashMap<String, Integer>();
    private String modelsPath = "data/entity-services";
    private String instanceConverterPath = "ext/entity-services";
    private boolean generateInstanceConverter = true;
    private boolean generateSchema = true;
    private boolean generateDatabaseProperties = true;
    private boolean generateExtractionTemplate = true;
    private boolean generateSearchOptions = true;
    private String modelsDatabase;
    private String[] resourceFilenamesToIgnore;
    private Pattern resourceFilenamesExcludePattern;
    private Pattern resourceFilenamesIncludePattern;
    private String[] excludeProperties;
    private String[] includeProperties;
    private boolean updateMimetypeWhenPropertiesAreEqual = false;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    private File projectDir;
    private DataConfig dataConfig;
    private PluginConfig pluginConfig;

    public AppConfig() {
        this(null);
    }

    public AppConfig(File projectDir) {
        this.projectDir = projectDir;
        this.dataConfig = new DataConfig(projectDir);
        this.pluginConfig = new PluginConfig(projectDir);
        this.cmaConfig = new CmaConfig(true);
        this.cmaConfig.setDeployServers(false);
        this.modulePaths = new ArrayList<String>();
        String path = projectDir != null ? new File(projectDir, DEFAULT_MODULES_PATH).getAbsolutePath() : DEFAULT_MODULES_PATH;
        this.modulePaths.add(path);
        String defaultSchemasPath = projectDir != null ? new File(projectDir, DEFAULT_SCHEMAS_PATH).getAbsolutePath() : DEFAULT_SCHEMAS_PATH;
        this.schemaPaths = new ArrayList<String>();
        this.schemaPaths.add(defaultSchemasPath);
        this.configDirs = new ArrayList<ConfigDir>();
        this.configDirs.add(ConfigDir.withProjectDir(projectDir));
        this.moduleTimestampsPath = projectDir != null ? new File(projectDir, "build/ml-javaclient-util/module-timestamps.properties").getAbsolutePath() : "build/ml-javaclient-util/module-timestamps.properties";
    }

    public void populateCustomTokens(PropertiesSource propertiesSource) {
        this.populateCustomTokens(propertiesSource, "%%", "%%");
    }

    public void populateCustomTokens(PropertiesSource propertiesSource, String prefix, String suffix) {
        Properties props = propertiesSource.getProperties();
        if (props != null) {
            if (this.customTokens == null) {
                this.customTokens = new HashMap<String, String>();
            }
            for (Object key : props.keySet()) {
                String skey = (String)key;
                String value = props.getProperty(skey);
                if (value == null) continue;
                String token = skey;
                if (prefix != null) {
                    token = prefix + token;
                }
                if (suffix != null) {
                    token = token + suffix;
                }
                this.customTokens.put(token, value);
            }
        }
    }

    public TokenReplacer buildTokenReplacer() {
        RoxyTokenReplacer r = this.isUseRoxyTokenPrefix() ? new RoxyTokenReplacer() : new DefaultTokenReplacer();
        Map<String, String> customTokens = this.getCustomTokens();
        if (customTokens != null) {
            r.addPropertiesSource((PropertiesSource)new MapPropertiesSource(customTokens));
        }
        return r;
    }

    public void setSimpleSslConfig() {
        this.setSimpleSslConfig(null);
    }

    public void setSimpleSslConfig(String protocol) {
        this.setRestSslContext(protocol != null ? SimpleX509TrustManager.newSSLContext((String)protocol) : SimpleX509TrustManager.newSSLContext());
        this.setRestSslHostnameVerifier((DatabaseClientFactory.SSLHostnameVerifier)DatabaseClientFactory.SSLHostnameVerifier.ANY);
        this.setRestTrustManager((X509TrustManager)new SimpleX509TrustManager());
    }

    public void setAppServicesSimpleSslConfig() {
        this.setAppServicesSimpleSslConfig(null);
    }

    public void setAppServicesSimpleSslConfig(String protocol) {
        this.setAppServicesSslContext(protocol != null ? SimpleX509TrustManager.newSSLContext((String)protocol) : SimpleX509TrustManager.newSSLContext());
        this.setAppServicesSslHostnameVerifier((DatabaseClientFactory.SSLHostnameVerifier)DatabaseClientFactory.SSLHostnameVerifier.ANY);
        this.setAppServicesTrustManager((X509TrustManager)new SimpleX509TrustManager());
    }

    public DatabaseClient newDatabaseClient() {
        return this.configuredDatabaseClientFactory.newDatabaseClient(this.newRestDatabaseClientConfig(this.getRestPort()));
    }

    public DatabaseClient newTestDatabaseClient() {
        DatabaseClientConfig config = this.newRestDatabaseClientConfig(this.getTestRestPort());
        if (StringUtils.hasText((String)this.getTestRestBasePath())) {
            config.setBasePath(this.getTestRestBasePath());
        }
        return this.configuredDatabaseClientFactory.newDatabaseClient(config);
    }

    public DatabaseClientConfig newRestDatabaseClientConfig(int port) {
        DatabaseClientConfig config = new DatabaseClientConfig(this.host, port, this.restAdminUsername, this.restAdminPassword);
        config.setCertFile(this.restCertFile);
        config.setCertPassword(this.restCertPassword);
        config.setConnectionType(this.restConnectionType);
        config.setExternalName(this.restExternalName);
        config.setSamlToken(this.restSamlToken);
        config.setSecurityContextType(this.restSecurityContextType);
        config.setCloudApiKey(this.cloudApiKey);
        config.setBasePath(this.restBasePath);
        config.setKeyStorePath(this.restKeyStorePath);
        config.setKeyStorePassword(this.restKeyStorePassword);
        config.setKeyStoreType(this.restKeyStoreType);
        config.setKeyStoreAlgorithm(this.restKeyStoreAlgorithm);
        config.setTrustStorePath(this.restTrustStorePath);
        config.setTrustStorePassword(this.restTrustStorePassword);
        config.setTrustStoreType(this.restTrustStoreType);
        config.setTrustStoreAlgorithm(this.restTrustStoreAlgorithm);
        if (this.restUseDefaultKeystore) {
            config.setSslProtocol(StringUtils.hasText((String)this.restSslProtocol) ? this.restSslProtocol : "TLSv1.2");
            config.setTrustManagementAlgorithm(this.restTrustManagementAlgorithm);
            config.setSslHostnameVerifier((DatabaseClientFactory.SSLHostnameVerifier)(this.restSslHostnameVerifier != null ? this.restSslHostnameVerifier : DatabaseClientFactory.SSLHostnameVerifier.ANY));
        } else {
            config.setSslContext(this.restSslContext);
            config.setTrustManager(this.restTrustManager);
            config.setSslHostnameVerifier(this.restSslHostnameVerifier);
        }
        return config;
    }

    public DatabaseClient newModulesDatabaseClient() {
        return this.newAppServicesDatabaseClient(this.getModulesDatabaseName());
    }

    public DatabaseClient newSchemasDatabaseClient() {
        return this.newAppServicesDatabaseClient(this.getSchemasDatabaseName());
    }

    public DatabaseClient newAppServicesDatabaseClient(String databaseName) {
        DatabaseClientConfig config = new DatabaseClientConfig(this.host, this.appServicesPort.intValue(), this.appServicesUsername, this.appServicesPassword);
        config.setCertFile(this.appServicesCertFile);
        config.setCertPassword(this.appServicesCertPassword);
        config.setConnectionType(this.appServicesConnectionType);
        config.setDatabase(databaseName);
        config.setExternalName(this.appServicesExternalName);
        config.setSamlToken(this.appServicesSamlToken);
        config.setSecurityContextType(this.appServicesSecurityContextType);
        config.setCloudApiKey(this.cloudApiKey);
        config.setBasePath(this.appServicesBasePath);
        config.setKeyStorePath(this.appServicesKeyStorePath);
        config.setKeyStorePassword(this.appServicesKeyStorePassword);
        config.setKeyStoreType(this.appServicesKeyStoreType);
        config.setKeyStoreAlgorithm(this.appServicesKeyStoreAlgorithm);
        config.setTrustStorePath(this.appServicesTrustStorePath);
        config.setTrustStorePassword(this.appServicesTrustStorePassword);
        config.setTrustStoreType(this.appServicesTrustStoreType);
        config.setTrustStoreAlgorithm(this.appServicesTrustStoreAlgorithm);
        if (this.appServicesUseDefaultKeystore) {
            config.setSslProtocol(StringUtils.hasText((String)this.appServicesSslProtocol) ? this.appServicesSslProtocol : "TLSv1.2");
            config.setTrustManagementAlgorithm(this.appServicesTrustManagementAlgorithm);
            config.setSslHostnameVerifier((DatabaseClientFactory.SSLHostnameVerifier)(this.appServicesSslHostnameVerifier != null ? this.appServicesSslHostnameVerifier : DatabaseClientFactory.SSLHostnameVerifier.ANY));
        } else {
            config.setSslContext(this.appServicesSslContext);
            config.setTrustManager(this.appServicesTrustManager);
            config.setSslHostnameVerifier(this.appServicesSslHostnameVerifier);
        }
        return this.configuredDatabaseClientFactory.newDatabaseClient(config);
    }

    public boolean isTestPortSet() {
        return this.testRestPort != null && this.testRestPort > 0;
    }

    public String getRestServerName() {
        return this.restServerName != null ? this.restServerName : this.name;
    }

    public void setRestServerName(String restServerName) {
        this.restServerName = restServerName;
    }

    public String getTestRestServerName() {
        return this.testRestServerName != null ? this.testRestServerName : this.name + "-test";
    }

    public void setTestRestServerName(String testRestServerName) {
        this.testRestServerName = testRestServerName;
    }

    public String getContentDatabaseName() {
        return this.contentDatabaseName != null ? this.contentDatabaseName : this.name + "-content";
    }

    public void setContentDatabaseName(String contentDatabaseName) {
        this.contentDatabaseName = contentDatabaseName;
    }

    public String getTestContentDatabaseName() {
        return this.testContentDatabaseName != null ? this.testContentDatabaseName : this.name + "-test-content";
    }

    public void setTestContentDatabaseName(String testContentDatabaseName) {
        this.testContentDatabaseName = testContentDatabaseName;
    }

    public String getModulesDatabaseName() {
        return this.modulesDatabaseName != null ? this.modulesDatabaseName : this.name + "-modules";
    }

    public void setModulesDatabaseName(String modulesDatabaseName) {
        this.modulesDatabaseName = modulesDatabaseName;
    }

    public String getTriggersDatabaseName() {
        return this.triggersDatabaseName != null ? this.triggersDatabaseName : this.name + "-triggers";
    }

    public void setTriggersDatabaseName(String triggersDatabaseName) {
        this.triggersDatabaseName = triggersDatabaseName;
    }

    public String getSchemasDatabaseName() {
        return this.schemasDatabaseName != null ? this.schemasDatabaseName : this.name + "-schemas";
    }

    public void setSchemasDatabaseName(String schemasDatabaseName) {
        this.schemasDatabaseName = schemasDatabaseName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getRestAdminUsername() {
        return this.restAdminUsername;
    }

    public void setRestAdminUsername(String username) {
        this.restAdminUsername = username;
    }

    public String getRestAdminPassword() {
        return this.restAdminPassword;
    }

    public void setRestAdminPassword(String password) {
        this.restAdminPassword = password;
    }

    public Integer getRestPort() {
        return this.restPort;
    }

    public void setRestPort(Integer restPort) {
        this.restPort = restPort;
    }

    public Integer getTestRestPort() {
        return this.testRestPort;
    }

    public void setTestRestPort(Integer testRestPort) {
        this.testRestPort = testRestPort;
    }

    public List<String> getModulePaths() {
        return this.modulePaths;
    }

    public void setModulePaths(List<String> modulePaths) {
        this.modulePaths = modulePaths;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public ConfigDir getFirstConfigDir() {
        if (this.configDirs == null || this.configDirs.isEmpty()) {
            this.configDirs = new ArrayList<ConfigDir>();
            this.configDirs.add(ConfigDir.withProjectDir(this.projectDir));
        }
        return this.configDirs.get(0);
    }

    public void setConfigDir(ConfigDir configDir) {
        this.configDirs = new ArrayList<ConfigDir>();
        this.configDirs.add(configDir);
    }

    public Map<String, String> getCustomTokens() {
        return this.customTokens;
    }

    public void setCustomTokens(Map<String, String> customTokens) {
        this.customTokens = customTokens;
    }

    public SSLContext getRestSslContext() {
        return this.restSslContext;
    }

    public void setRestSslContext(SSLContext restSslContext) {
        this.restSslContext = restSslContext;
    }

    public DatabaseClientFactory.SSLHostnameVerifier getRestSslHostnameVerifier() {
        return this.restSslHostnameVerifier;
    }

    public void setRestSslHostnameVerifier(DatabaseClientFactory.SSLHostnameVerifier restSslHostnameVerifier) {
        this.restSslHostnameVerifier = restSslHostnameVerifier;
    }

    public String[] getAdditionalBinaryExtensions() {
        return this.additionalBinaryExtensions;
    }

    public void setAdditionalBinaryExtensions(String[] additionalBinaryExtensions) {
        this.additionalBinaryExtensions = additionalBinaryExtensions;
    }

    public Integer getContentForestsPerHost() {
        return this.contentForestsPerHost;
    }

    public void setContentForestsPerHost(Integer contentForestsPerHost) {
        this.contentForestsPerHost = contentForestsPerHost;
    }

    public String getModulePermissions() {
        return this.modulePermissions;
    }

    public void setModulePermissions(String assetPermissions) {
        this.modulePermissions = assetPermissions;
    }

    public FileFilter getAssetFileFilter() {
        return this.assetFileFilter;
    }

    public void setAssetFileFilter(FileFilter assetFileFilter) {
        this.assetFileFilter = assetFileFilter;
    }

    public FileFilter getSchemasFileFilter() {
        return this.schemasFileFilter;
    }

    public void setSchemasFileFilter(FileFilter schemasFileFilter) {
        this.schemasFileFilter = schemasFileFilter;
    }

    public String getFlexrepPath() {
        return this.flexrepPath;
    }

    public void setFlexrepPath(String flexrepPath) {
        this.flexrepPath = flexrepPath;
    }

    public Map<String, Integer> getForestCounts() {
        return this.forestCounts;
    }

    public void setForestCounts(Map<String, Integer> forestCounts) {
        this.forestCounts = forestCounts;
    }

    public Integer getAppServicesPort() {
        return this.appServicesPort;
    }

    public void setAppServicesPort(Integer appServicesPort) {
        this.appServicesPort = appServicesPort;
    }

    public boolean isReplaceTokensInModules() {
        return this.replaceTokensInModules;
    }

    public void setReplaceTokensInModules(boolean replaceTokensInModules) {
        this.replaceTokensInModules = replaceTokensInModules;
    }

    public boolean isUseRoxyTokenPrefix() {
        return this.useRoxyTokenPrefix;
    }

    public void setUseRoxyTokenPrefix(boolean useRoxyTokenPrefix) {
        this.useRoxyTokenPrefix = useRoxyTokenPrefix;
    }

    public boolean isStaticCheckAssets() {
        return this.staticCheckAssets;
    }

    public void setStaticCheckAssets(boolean staticCheckAssets) {
        this.staticCheckAssets = staticCheckAssets;
    }

    public boolean isStaticCheckLibraryAssets() {
        return this.staticCheckLibraryAssets;
    }

    public void setStaticCheckLibraryAssets(boolean staticCheckLibraryAssets) {
        this.staticCheckLibraryAssets = staticCheckLibraryAssets;
    }

    public boolean isBulkLoadAssets() {
        return this.bulkLoadAssets;
    }

    public void setBulkLoadAssets(boolean bulkLoadAssets) {
        this.bulkLoadAssets = bulkLoadAssets;
    }

    public String getModelsPath() {
        return this.modelsPath;
    }

    public void setModelsPath(String modelsPath) {
        this.modelsPath = modelsPath;
    }

    public String getInstanceConverterPath() {
        return this.instanceConverterPath;
    }

    public void setInstanceConverterPath(String instanceConverterPath) {
        this.instanceConverterPath = instanceConverterPath;
    }

    public void setGenerateInstanceConverter(boolean generateInstanceConverter) {
        this.generateInstanceConverter = generateInstanceConverter;
    }

    public void setGenerateSchema(boolean generateSchema) {
        this.generateSchema = generateSchema;
    }

    public void setGenerateDatabaseProperties(boolean generateDatabaseProperties) {
        this.generateDatabaseProperties = generateDatabaseProperties;
    }

    public void setGenerateExtractionTemplate(boolean generateExtractionTemplate) {
        this.generateExtractionTemplate = generateExtractionTemplate;
    }

    public void setGenerateSearchOptions(boolean generateSearchOptions) {
        this.generateSearchOptions = generateSearchOptions;
    }

    public boolean isGenerateInstanceConverter() {
        return this.generateInstanceConverter;
    }

    public boolean isGenerateSchema() {
        return this.generateSchema;
    }

    public boolean isGenerateDatabaseProperties() {
        return this.generateDatabaseProperties;
    }

    public boolean isGenerateExtractionTemplate() {
        return this.generateExtractionTemplate;
    }

    public boolean isGenerateSearchOptions() {
        return this.generateSearchOptions;
    }

    public String getModuleTimestampsPath() {
        return this.moduleTimestampsPath;
    }

    public void setModuleTimestampsPath(String moduleTimestampsPath) {
        this.moduleTimestampsPath = moduleTimestampsPath;
    }

    public String[] getResourceFilenamesToIgnore() {
        return this.resourceFilenamesToIgnore;
    }

    public void setResourceFilenamesToIgnore(String ... resourceFilenamesToIgnore) {
        this.resourceFilenamesToIgnore = resourceFilenamesToIgnore;
    }

    public boolean isDeleteReplicas() {
        return this.deleteReplicas;
    }

    public void setDeleteReplicas(boolean deleteReplicas) {
        this.deleteReplicas = deleteReplicas;
    }

    public boolean isDeleteForests() {
        return this.deleteForests;
    }

    public void setDeleteForests(boolean deleteForests) {
        this.deleteForests = deleteForests;
    }

    public boolean isCreateForests() {
        return this.createForests;
    }

    public void setCreateForests(boolean createForests) {
        this.createForests = createForests;
    }

    public boolean isNoRestServer() {
        return this.noRestServer;
    }

    public void setNoRestServer(boolean noRestServer) {
        this.noRestServer = noRestServer;
    }

    public SSLContext getAppServicesSslContext() {
        return this.appServicesSslContext;
    }

    public void setAppServicesSslContext(SSLContext appServicesSslContext) {
        this.appServicesSslContext = appServicesSslContext;
    }

    public DatabaseClientFactory.SSLHostnameVerifier getAppServicesSslHostnameVerifier() {
        return this.appServicesSslHostnameVerifier;
    }

    public void setAppServicesSslHostnameVerifier(DatabaseClientFactory.SSLHostnameVerifier appServicesSslHostnameVerifier) {
        this.appServicesSslHostnameVerifier = appServicesSslHostnameVerifier;
    }

    public String getReplicaForestDataDirectory() {
        return this.replicaForestDataDirectory;
    }

    public void setReplicaForestDataDirectory(String replicaForestDataDirectory) {
        this.replicaForestDataDirectory = replicaForestDataDirectory;
    }

    public String getReplicaForestLargeDataDirectory() {
        return this.replicaForestLargeDataDirectory;
    }

    public void setReplicaForestLargeDataDirectory(String replicaForestLargeDataDirectory) {
        this.replicaForestLargeDataDirectory = replicaForestLargeDataDirectory;
    }

    public String getReplicaForestFastDataDirectory() {
        return this.replicaForestFastDataDirectory;
    }

    public void setReplicaForestFastDataDirectory(String replicaForestFastDataDirectory) {
        this.replicaForestFastDataDirectory = replicaForestFastDataDirectory;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public String getAppServicesUsername() {
        return this.appServicesUsername;
    }

    public void setAppServicesUsername(String appServicesUsername) {
        this.appServicesUsername = appServicesUsername;
    }

    public String getAppServicesPassword() {
        return this.appServicesPassword;
    }

    public void setAppServicesPassword(String appServicesPassword) {
        this.appServicesPassword = appServicesPassword;
    }

    public boolean isDeleteTestModules() {
        return this.deleteTestModules;
    }

    public void setDeleteTestModules(boolean deleteTestModules) {
        this.deleteTestModules = deleteTestModules;
    }

    public String getDeleteTestModulesPattern() {
        return this.deleteTestModulesPattern;
    }

    public void setDeleteTestModulesPattern(String deleteTestModulesPattern) {
        this.deleteTestModulesPattern = deleteTestModulesPattern;
    }

    public SecurityContextType getRestSecurityContextType() {
        return this.restSecurityContextType;
    }

    public void setRestSecurityContextType(SecurityContextType restSecurityContextType) {
        this.restSecurityContextType = restSecurityContextType;
    }

    public SecurityContextType getAppServicesSecurityContextType() {
        return this.appServicesSecurityContextType;
    }

    public void setAppServicesSecurityContextType(SecurityContextType appServicesSecurityContextType) {
        this.appServicesSecurityContextType = appServicesSecurityContextType;
    }

    public String getRestCertFile() {
        return this.restCertFile;
    }

    public void setRestCertFile(String restCertFile) {
        this.restCertFile = restCertFile;
    }

    public String getRestCertPassword() {
        return this.restCertPassword;
    }

    public void setRestCertPassword(String restCertPassword) {
        this.restCertPassword = restCertPassword;
    }

    public String getAppServicesCertFile() {
        return this.appServicesCertFile;
    }

    public void setAppServicesCertFile(String appServicesCertFile) {
        this.appServicesCertFile = appServicesCertFile;
    }

    public String getAppServicesCertPassword() {
        return this.appServicesCertPassword;
    }

    public void setAppServicesCertPassword(String appServicesCertPassword) {
        this.appServicesCertPassword = appServicesCertPassword;
    }

    public String getRestExternalName() {
        return this.restExternalName;
    }

    public void setRestExternalName(String restExternalName) {
        this.restExternalName = restExternalName;
    }

    public String getAppServicesExternalName() {
        return this.appServicesExternalName;
    }

    public void setAppServicesExternalName(String appServicesExternalName) {
        this.appServicesExternalName = appServicesExternalName;
    }

    public ConfiguredDatabaseClientFactory getConfiguredDatabaseClientFactory() {
        return this.configuredDatabaseClientFactory;
    }

    public void setConfiguredDatabaseClientFactory(ConfiguredDatabaseClientFactory configuredDatabaseClientFactory) {
        this.configuredDatabaseClientFactory = configuredDatabaseClientFactory;
    }

    public Pattern getResourceFilenamesExcludePattern() {
        return this.resourceFilenamesExcludePattern;
    }

    public void setResourceFilenamesExcludePattern(Pattern resourceFilenamesExcludePattern) {
        this.resourceFilenamesExcludePattern = resourceFilenamesExcludePattern;
    }

    public Pattern getResourceFilenamesIncludePattern() {
        return this.resourceFilenamesIncludePattern;
    }

    public void setResourceFilenamesIncludePattern(Pattern resourceFilenamesIncludePattern) {
        this.resourceFilenamesIncludePattern = resourceFilenamesIncludePattern;
    }

    public int getModulesLoaderThreadCount() {
        return this.modulesLoaderThreadCount;
    }

    public void setModulesLoaderThreadCount(int modulesLoaderThreadCount) {
        this.modulesLoaderThreadCount = modulesLoaderThreadCount;
    }

    public Map<String, List<String>> getDatabaseDataDirectories() {
        return this.databaseDataDirectories;
    }

    public void setDatabaseDataDirectories(Map<String, List<String>> databaseDataDirectories) {
        this.databaseDataDirectories = databaseDataDirectories;
    }

    public Map<String, String> getDatabaseFastDataDirectories() {
        return this.databaseFastDataDirectories;
    }

    public void setDatabaseFastDataDirectories(Map<String, String> databaseFastDataDirectories) {
        this.databaseFastDataDirectories = databaseFastDataDirectories;
    }

    public Map<String, String> getDatabaseLargeDataDirectories() {
        return this.databaseLargeDataDirectories;
    }

    public void setDatabaseLargeDataDirectories(Map<String, String> databaseLargeDataDirectories) {
        this.databaseLargeDataDirectories = databaseLargeDataDirectories;
    }

    public String getForestDataDirectory() {
        return this.forestDataDirectory;
    }

    public void setForestDataDirectory(String forestDataDirectory) {
        this.forestDataDirectory = forestDataDirectory;
    }

    public String getForestFastDataDirectory() {
        return this.forestFastDataDirectory;
    }

    public void setForestFastDataDirectory(String forestFastDataDirectory) {
        this.forestFastDataDirectory = forestFastDataDirectory;
    }

    public String getForestLargeDataDirectory() {
        return this.forestLargeDataDirectory;
    }

    public void setForestLargeDataDirectory(String forestLargeDataDirectory) {
        this.forestLargeDataDirectory = forestLargeDataDirectory;
    }

    public Map<String, List<String>> getDatabaseReplicaDataDirectories() {
        return this.databaseReplicaDataDirectories;
    }

    public void setDatabaseReplicaDataDirectories(Map<String, List<String>> databaseReplicaDataDirectories) {
        this.databaseReplicaDataDirectories = databaseReplicaDataDirectories;
    }

    public Map<String, String> getDatabaseReplicaFastDataDirectories() {
        return this.databaseReplicaFastDataDirectories;
    }

    public void setDatabaseReplicaFastDataDirectories(Map<String, String> databaseReplicaFastDataDirectories) {
        this.databaseReplicaFastDataDirectories = databaseReplicaFastDataDirectories;
    }

    public Map<String, String> getDatabaseReplicaLargeDataDirectories() {
        return this.databaseReplicaLargeDataDirectories;
    }

    public void setDatabaseReplicaLargeDataDirectories(Map<String, String> databaseReplicaLargeDataDirectories) {
        this.databaseReplicaLargeDataDirectories = databaseReplicaLargeDataDirectories;
    }

    public boolean isCatchDeployExceptions() {
        return this.catchDeployExceptions;
    }

    public void setCatchDeployExceptions(boolean catchDeployExceptions) {
        this.catchDeployExceptions = catchDeployExceptions;
    }

    public boolean isCatchUndeployExceptions() {
        return this.catchUndeployExceptions;
    }

    public void setCatchUndeployExceptions(boolean catchUndeployExceptions) {
        this.catchUndeployExceptions = catchUndeployExceptions;
    }

    public boolean isDatabaseWithForestsOnOneHost(String databaseName) {
        if (this.databasesWithForestsOnOneHost == null) {
            return false;
        }
        return this.databasesWithForestsOnOneHost.contains(databaseName);
    }

    public void addDatabaseWithForestsOnOneHost(String databaseName) {
        if (this.databasesWithForestsOnOneHost == null) {
            this.databasesWithForestsOnOneHost = new HashSet<String>();
        }
        this.databasesWithForestsOnOneHost.add(databaseName);
    }

    public Set<String> getDatabasesWithForestsOnOneHost() {
        return this.databasesWithForestsOnOneHost;
    }

    public void setDatabasesWithForestsOnOneHost(Set<String> databasesWithForestsOnOneHost) {
        this.databasesWithForestsOnOneHost = databasesWithForestsOnOneHost;
    }

    public Map<String, List<String>> getDatabaseHosts() {
        return this.databaseHosts;
    }

    public void setDatabaseHosts(Map<String, List<String>> databaseHosts) {
        this.databaseHosts = databaseHosts;
    }

    public void setExcludeProperties(String ... excludeProperties) {
        if (this.includeProperties != null && this.includeProperties.length > 0) {
            throw new IllegalStateException("Setting excludeProperties and includeProperties at the same time is not permitted");
        }
        this.excludeProperties = excludeProperties;
    }

    public String[] getExcludeProperties() {
        return this.excludeProperties;
    }

    public void setIncludeProperties(String ... includeProperties) {
        if (this.excludeProperties != null && this.excludeProperties.length > 0) {
            throw new IllegalStateException("Setting excludeProperties and includeProperties at the same time is not permitted");
        }
        this.includeProperties = includeProperties;
    }

    public String[] getIncludeProperties() {
        return this.includeProperties;
    }

    public Map<String, List<String>> getDatabaseGroups() {
        return this.databaseGroups;
    }

    public void setDatabaseGroups(Map<String, List<String>> databaseGroups) {
        this.databaseGroups = databaseGroups;
    }

    public Map<String, String> getHostGroups() {
        return this.hostGroups;
    }

    public void setHostGroups(Map<String, String> hostGroups) {
        this.hostGroups = hostGroups;
    }

    public List<ConfigDir> getConfigDirs() {
        return this.configDirs;
    }

    public void setConfigDirs(List<ConfigDir> configDirs) {
        this.configDirs = configDirs;
    }

    public Pattern getModuleFilenamesIncludePattern() {
        return this.moduleFilenamesIncludePattern;
    }

    public void setModuleFilenamesIncludePattern(Pattern moduleFilenamesIncludePattern) {
        this.moduleFilenamesIncludePattern = moduleFilenamesIncludePattern;
    }

    public boolean isSortOtherDatabaseByDependencies() {
        return this.sortOtherDatabaseByDependencies;
    }

    public void setSortOtherDatabaseByDependencies(boolean sortOtherDatabaseByDependencies) {
        this.sortOtherDatabaseByDependencies = sortOtherDatabaseByDependencies;
    }

    public Integer getModulesLoaderBatchSize() {
        return this.modulesLoaderBatchSize;
    }

    public void setModulesLoaderBatchSize(Integer modulesLoaderBatchSize) {
        this.modulesLoaderBatchSize = modulesLoaderBatchSize;
    }

    public boolean isIncrementalDeploy() {
        return this.incrementalDeploy;
    }

    public void setIncrementalDeploy(boolean incrementalDeploy) {
        this.incrementalDeploy = incrementalDeploy;
    }

    public String getModelsDatabase() {
        return this.modelsDatabase;
    }

    public void setModelsDatabase(String modelsDatabase) {
        this.modelsDatabase = modelsDatabase;
    }

    public String getCpfDatabaseName() {
        return this.cpfDatabaseName != null ? this.cpfDatabaseName : this.getTriggersDatabaseName();
    }

    public void setCpfDatabaseName(String cpfDatabaseName) {
        this.cpfDatabaseName = cpfDatabaseName;
    }

    public Map<String, Integer> getDatabaseNamesAndReplicaCounts() {
        return this.databaseNamesAndReplicaCounts;
    }

    public void setDatabaseNamesAndReplicaCounts(Map<String, Integer> databaseNamesAndReplicaCounts) {
        this.databaseNamesAndReplicaCounts = databaseNamesAndReplicaCounts;
    }

    public Map<String, ForestNamingStrategy> getForestNamingStrategies() {
        return this.forestNamingStrategies;
    }

    public void setForestNamingStrategies(Map<String, ForestNamingStrategy> forestNamingStrategies) {
        this.forestNamingStrategies = forestNamingStrategies;
    }

    public boolean isUpdateMimetypeWhenPropertiesAreEqual() {
        return this.updateMimetypeWhenPropertiesAreEqual;
    }

    public void setUpdateMimetypeWhenPropertiesAreEqual(boolean updateMimetypeWhenPropertiesAreEqual) {
        this.updateMimetypeWhenPropertiesAreEqual = updateMimetypeWhenPropertiesAreEqual;
    }

    public X509TrustManager getRestTrustManager() {
        return this.restTrustManager;
    }

    public void setRestTrustManager(X509TrustManager restTrustManager) {
        this.restTrustManager = restTrustManager;
    }

    public X509TrustManager getAppServicesTrustManager() {
        return this.appServicesTrustManager;
    }

    public void setAppServicesTrustManager(X509TrustManager appServicesTrustManager) {
        this.appServicesTrustManager = appServicesTrustManager;
    }

    public ReplicaBuilderStrategy getReplicaBuilderStrategy() {
        return this.replicaBuilderStrategy;
    }

    public void setReplicaBuilderStrategy(ReplicaBuilderStrategy replicaBuilderStrategy) {
        this.replicaBuilderStrategy = replicaBuilderStrategy;
    }

    public boolean isTdeValidationEnabled() {
        return this.tdeValidationEnabled;
    }

    public void setTdeValidationEnabled(boolean tdeValidationEnabled) {
        this.tdeValidationEnabled = tdeValidationEnabled;
    }

    public boolean isAddHostNameTokens() {
        return this.addHostNameTokens;
    }

    public void setAddHostNameTokens(boolean addHostNameTokens) {
        this.addHostNameTokens = addHostNameTokens;
    }

    public DataConfig getDataConfig() {
        return this.dataConfig;
    }

    public void setDataConfig(DataConfig dataConfig) {
        this.dataConfig = dataConfig;
    }

    public PluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    public void setPluginConfig(PluginConfig pluginConfig) {
        this.pluginConfig = pluginConfig;
    }

    public List<String> getSchemaPaths() {
        return this.schemaPaths;
    }

    public void setSchemaPaths(List<String> schemaPaths) {
        this.schemaPaths = schemaPaths;
    }

    public boolean isMergeResources() {
        return this.mergeResources;
    }

    public void setMergeResources(boolean mergeResources) {
        this.mergeResources = mergeResources;
    }

    public boolean isModuleTimestampsUseHost() {
        return this.moduleTimestampsUseHost;
    }

    public void setModuleTimestampsUseHost(boolean moduleTimestampsUseHost) {
        this.moduleTimestampsUseHost = moduleTimestampsUseHost;
    }

    public DatabaseClient.ConnectionType getRestConnectionType() {
        return this.restConnectionType;
    }

    public void setRestConnectionType(DatabaseClient.ConnectionType restConnectionType) {
        this.restConnectionType = restConnectionType;
    }

    public DatabaseClient.ConnectionType getAppServicesConnectionType() {
        return this.appServicesConnectionType;
    }

    public void setAppServicesConnectionType(DatabaseClient.ConnectionType appServicesConnectionType) {
        this.appServicesConnectionType = appServicesConnectionType;
    }

    public CmaConfig getCmaConfig() {
        return this.cmaConfig;
    }

    public void setCmaConfig(CmaConfig cmaConfig) {
        this.cmaConfig = cmaConfig;
    }

    public boolean isRestUseDefaultKeystore() {
        return this.restUseDefaultKeystore;
    }

    public void setRestUseDefaultKeystore(boolean restUseDefaultKeystore) {
        this.restUseDefaultKeystore = restUseDefaultKeystore;
    }

    public String getRestSslProtocol() {
        return this.restSslProtocol;
    }

    public void setRestSslProtocol(String restSslProtocol) {
        this.restSslProtocol = restSslProtocol;
    }

    public String getRestTrustManagementAlgorithm() {
        return this.restTrustManagementAlgorithm;
    }

    public void setRestTrustManagementAlgorithm(String restTrustManagementAlgorithm) {
        this.restTrustManagementAlgorithm = restTrustManagementAlgorithm;
    }

    public boolean isAppServicesUseDefaultKeystore() {
        return this.appServicesUseDefaultKeystore;
    }

    public void setAppServicesUseDefaultKeystore(boolean appServicesUseDefaultKeystore) {
        this.appServicesUseDefaultKeystore = appServicesUseDefaultKeystore;
    }

    public String getAppServicesSslProtocol() {
        return this.appServicesSslProtocol;
    }

    public void setAppServicesSslProtocol(String appServicesSslProtocol) {
        this.appServicesSslProtocol = appServicesSslProtocol;
    }

    public String getAppServicesTrustManagementAlgorithm() {
        return this.appServicesTrustManagementAlgorithm;
    }

    public void setAppServicesTrustManagementAlgorithm(String appServicesTrustManagementAlgorithm) {
        this.appServicesTrustManagementAlgorithm = appServicesTrustManagementAlgorithm;
    }

    public String getModuleUriPrefix() {
        return this.moduleUriPrefix;
    }

    public void setModuleUriPrefix(String moduleUriPrefix) {
        this.moduleUriPrefix = moduleUriPrefix;
    }

    public String getCloudApiKey() {
        return this.cloudApiKey;
    }

    public void setCloudApiKey(String cloudApiKey) {
        this.cloudApiKey = cloudApiKey;
    }

    public String getRestBasePath() {
        return this.restBasePath;
    }

    public void setRestBasePath(String restBasePath) {
        this.restBasePath = restBasePath;
    }

    public String getAppServicesBasePath() {
        return this.appServicesBasePath;
    }

    public void setAppServicesBasePath(String appServicesBasePath) {
        this.appServicesBasePath = appServicesBasePath;
    }

    public String getTestRestBasePath() {
        return this.testRestBasePath;
    }

    public void setTestRestBasePath(String testRestBasePath) {
        this.testRestBasePath = testRestBasePath;
    }

    public String getRestSamlToken() {
        return this.restSamlToken;
    }

    public void setRestSamlToken(String restSamlToken) {
        this.restSamlToken = restSamlToken;
    }

    public String getAppServicesSamlToken() {
        return this.appServicesSamlToken;
    }

    public void setAppServicesSamlToken(String appServicesSamlToken) {
        this.appServicesSamlToken = appServicesSamlToken;
    }

    public boolean isCascadeCollections() {
        return this.cascadeCollections;
    }

    public void setCascadeCollections(boolean cascadeCollections) {
        this.cascadeCollections = cascadeCollections;
    }

    public boolean isCascadePermissions() {
        return this.cascadePermissions;
    }

    public void setCascadePermissions(boolean cascadePermissions) {
        this.cascadePermissions = cascadePermissions;
    }

    public String getRestKeyStorePath() {
        return this.restKeyStorePath;
    }

    public void setRestKeyStorePath(String restKeyStorePath) {
        this.restKeyStorePath = restKeyStorePath;
    }

    public String getRestKeyStorePassword() {
        return this.restKeyStorePassword;
    }

    public void setRestKeyStorePassword(String restKeyStorePassword) {
        this.restKeyStorePassword = restKeyStorePassword;
    }

    public String getRestKeyStoreType() {
        return this.restKeyStoreType;
    }

    public void setRestKeyStoreType(String restKeyStoreType) {
        this.restKeyStoreType = restKeyStoreType;
    }

    public String getRestKeyStoreAlgorithm() {
        return this.restKeyStoreAlgorithm;
    }

    public void setRestKeyStoreAlgorithm(String restKeyStoreAlgorithm) {
        this.restKeyStoreAlgorithm = restKeyStoreAlgorithm;
    }

    public String getRestTrustStorePath() {
        return this.restTrustStorePath;
    }

    public void setRestTrustStorePath(String restTrustStorePath) {
        this.restTrustStorePath = restTrustStorePath;
    }

    public String getRestTrustStorePassword() {
        return this.restTrustStorePassword;
    }

    public void setRestTrustStorePassword(String restTrustStorePassword) {
        this.restTrustStorePassword = restTrustStorePassword;
    }

    public String getRestTrustStoreType() {
        return this.restTrustStoreType;
    }

    public void setRestTrustStoreType(String restTrustStoreType) {
        this.restTrustStoreType = restTrustStoreType;
    }

    public String getRestTrustStoreAlgorithm() {
        return this.restTrustStoreAlgorithm;
    }

    public void setRestTrustStoreAlgorithm(String restTrustStoreAlgorithm) {
        this.restTrustStoreAlgorithm = restTrustStoreAlgorithm;
    }

    public String getAppServicesKeyStorePath() {
        return this.appServicesKeyStorePath;
    }

    public void setAppServicesKeyStorePath(String appServicesKeyStorePath) {
        this.appServicesKeyStorePath = appServicesKeyStorePath;
    }

    public String getAppServicesKeyStorePassword() {
        return this.appServicesKeyStorePassword;
    }

    public void setAppServicesKeyStorePassword(String appServicesKeyStorePassword) {
        this.appServicesKeyStorePassword = appServicesKeyStorePassword;
    }

    public String getAppServicesKeyStoreType() {
        return this.appServicesKeyStoreType;
    }

    public void setAppServicesKeyStoreType(String appServicesKeyStoreType) {
        this.appServicesKeyStoreType = appServicesKeyStoreType;
    }

    public String getAppServicesKeyStoreAlgorithm() {
        return this.appServicesKeyStoreAlgorithm;
    }

    public void setAppServicesKeyStoreAlgorithm(String appServicesKeyStoreAlgorithm) {
        this.appServicesKeyStoreAlgorithm = appServicesKeyStoreAlgorithm;
    }

    public String getAppServicesTrustStorePath() {
        return this.appServicesTrustStorePath;
    }

    public void setAppServicesTrustStorePath(String appServicesTrustStorePath) {
        this.appServicesTrustStorePath = appServicesTrustStorePath;
    }

    public String getAppServicesTrustStorePassword() {
        return this.appServicesTrustStorePassword;
    }

    public void setAppServicesTrustStorePassword(String appServicesTrustStorePassword) {
        this.appServicesTrustStorePassword = appServicesTrustStorePassword;
    }

    public String getAppServicesTrustStoreType() {
        return this.appServicesTrustStoreType;
    }

    public void setAppServicesTrustStoreType(String appServicesTrustStoreType) {
        this.appServicesTrustStoreType = appServicesTrustStoreType;
    }

    public String getAppServicesTrustStoreAlgorithm() {
        return this.appServicesTrustStoreAlgorithm;
    }

    public void setAppServicesTrustStoreAlgorithm(String appServicesTrustStoreAlgorithm) {
        this.appServicesTrustStoreAlgorithm = appServicesTrustStoreAlgorithm;
    }
}

