/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl.handlers;

import com.marklogic.http.HttpChannel;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.exceptions.MLCloudRequestException;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.impl.ContentSourceImpl;
import com.marklogic.xcc.impl.Credentials;
import com.marklogic.xcc.impl.SessionImpl;
import com.marklogic.xcc.impl.handlers.AbstractRequestController;
import com.marklogic.xcc.impl.handlers.MLCloudForbiddenHandler;
import com.marklogic.xcc.impl.handlers.MLCloudGoneHandler;
import com.marklogic.xcc.impl.handlers.MLCloudSuccessResponseHandler;
import com.marklogic.xcc.impl.handlers.NotFoundCodeHandler;
import com.marklogic.xcc.impl.handlers.ResponseHandler;
import com.marklogic.xcc.impl.handlers.ServerExceptionHandler;
import com.marklogic.xcc.impl.handlers.ServiceUnavailableHandler;
import com.marklogic.xcc.impl.handlers.UnauthorizedHandler;
import com.marklogic.xcc.impl.handlers.UnrecognizedCodeHandler;
import com.marklogic.xcc.spi.ConnectionProvider;
import com.marklogic.xcc.spi.ServerConnection;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MLCloudRequestController
extends AbstractRequestController {
    private static final int MAX_RETRY = 5;
    private static final int RETRY_DELAY_MILLIS = 125;
    private static final Map<Integer, ResponseHandler> handlers = new HashMap<Integer, ResponseHandler>();
    private Credentials.MLCloudAuthConfig mlCloudAuthConfig;
    private String boundary;

    public MLCloudRequestController(Credentials.MLCloudAuthConfig mlCloudAuthConfig) {
        super(handlers, "/", mlCloudAuthConfig.getTokenEndpoint());
        this.mlCloudAuthConfig = mlCloudAuthConfig;
    }

    @Override
    public ResultSequence runRequest(ConnectionProvider provider, Request request, Logger logger) throws RequestException {
        int t;
        SessionImpl session = (SessionImpl)request.getSession();
        RequestOptions options = request.getEffectiveOptions();
        ServerConnection connection = null;
        RequestException re = null;
        for (t = 0; t < 5; ++t) {
            if (t > 0 && logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Retrying connecting to MarkLogic Cloud (" + t + ").");
            }
            try {
                this.sleepFor(this.interTryDelay(125L, t), logger);
                connection = provider.obtainConnection(session, request, logger);
                ResultSequence rs = this.serverDialog(connection, request, options, logger);
                if (rs == null || rs.isCached()) {
                    provider.returnConnection(connection, logger);
                }
                return rs;
            }
            catch (RequestException e) {
                logger.log(Level.WARNING, "Request exception connecting to MarkLogic Cloud. Cannot obtain session token.", e);
                provider.returnConnection(connection, logger);
                if (e instanceof MLCloudRequestException) {
                    if (!e.isRetryable()) {
                        throw e;
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Retryable exception caught.", e);
                    }
                    re = e;
                    continue;
                }
                throw e;
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Connection IOException caught. Cannot obtain session token.", e);
                if (connection != null) {
                    provider.returnErrorConnection(connection, e, logger);
                }
                re = new MLCloudRequestException(e.getMessage(), request, e, true);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception connecting to MarkLogic Cloud. Cannot obtain session token.", e);
                re = new MLCloudRequestException(e.getMessage(), request, e, true);
            }
        }
        logger.log(Level.WARNING, "Automatic connecting to MarkLogic Cloud retries (" + t + ") exhausted, throwing: " + re, re);
        throw re;
    }

    @Override
    public ResultSequence serverDialog(ServerConnection connection, Request request, RequestOptions options, Logger logger) throws IOException, RequestException {
        SessionImpl session = (SessionImpl)request.getSession();
        byte[] bodyBytes = this.buildFormBody().getBytes();
        String reqUri = this.addTokenDurationToPath(this.httpPath);
        HttpChannel http = this.buildChannel(connection, reqUri, session, bodyBytes.length, options, logger);
        http.write(bodyBytes);
        if (HttpChannel.isUseHTTP()) {
            http.write("\r\n".getBytes());
        }
        int code = http.getResponseCode();
        ResponseHandler handler = this.findHandler(code);
        handler.handleResponse(http, code, request, this.mlCloudAuthConfig, logger);
        return null;
    }

    private HttpChannel buildChannel(ServerConnection connection, String path, SessionImpl session, int bufferSize, RequestOptions options, Logger logger) {
        String method = "POST";
        HttpChannel http = new HttpChannel(connection.channel(), method, path, bufferSize, options.getTimeoutMillis(), logger);
        ContentSourceImpl contentSource = (ContentSourceImpl)session.getContentSource();
        if (HttpChannel.isUseHTTP()) {
            ConnectionProvider cp = contentSource.getConnectionProvider();
            http.setRequestHeader("Host", cp.getHostName() + ":" + cp.getPort());
        }
        http.setRequestHeader("User-Agent", session.userAgentString());
        http.setRequestHeader("Accept", session.getAcceptedContentTypes());
        http.setRequestContentType("multipart/form-data; boundary=" + this.boundary);
        return http;
    }

    private String buildFormBody() {
        HttpChannel.MultipartFormBody formBody = new HttpChannel.MultipartFormBody();
        this.boundary = formBody.getBoundary();
        formBody.addTextBody("key", new String(this.mlCloudAuthConfig.getApiKey()));
        formBody.addTextBody("grant_type", this.mlCloudAuthConfig.getGrantType());
        return formBody.buildFormBody();
    }

    private String addTokenDurationToPath(String httpPath) {
        StringBuilder sb = new StringBuilder(httpPath);
        int tokenDuration = this.mlCloudAuthConfig.getTokenDuration();
        if (tokenDuration != 60) {
            sb.append("?duration=");
            sb.append(tokenDuration);
        }
        return sb.toString();
    }

    static {
        MLCloudRequestController.addDefaultHandler(handlers, new UnrecognizedCodeHandler());
        MLCloudRequestController.addHandler(handlers, 200, new MLCloudSuccessResponseHandler());
        MLCloudRequestController.addHandler(handlers, 401, new UnauthorizedHandler());
        MLCloudRequestController.addHandler(handlers, 403, new MLCloudForbiddenHandler());
        MLCloudRequestController.addHandler(handlers, 404, new NotFoundCodeHandler());
        MLCloudRequestController.addHandler(handlers, 410, new MLCloudGoneHandler());
        MLCloudRequestController.addHandler(handlers, 500, new ServerExceptionHandler());
        MLCloudRequestController.addHandler(handlers, 502, new ServiceUnavailableHandler());
        MLCloudRequestController.addHandler(handlers, 503, new ServiceUnavailableHandler());
        MLCloudRequestController.addHandler(handlers, 504, new ServiceUnavailableHandler());
    }
}

