/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl;

import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.impl.handlers.MLCloudRequestController;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MLCloudAuthManager {
    private static final long RENEW_OFFSET_MINUTES = 1L;
    private static final Logger logger;
    private static final ScheduledExecutorService scheduler;
    private static final ConcurrentHashMap<Integer, MLCloudAuthContext> contextMap;

    private MLCloudAuthManager() {
    }

    public static synchronized void createMLCloudAuthContext(ContentSource cs) {
        int apiKeyHash = new String(cs.getUserCredentials().getMLCloudAuthConfig().getApiKey()).hashCode();
        if (!contextMap.containsKey(apiKeyHash)) {
            contextMap.put(apiKeyHash, new MLCloudAuthContext(cs));
            MLCloudAuthManager.runObtainSessionTokenOneTime(apiKeyHash);
            MLCloudAuthManager.runRenewSessionToken(apiKeyHash);
        }
    }

    private static void runObtainSessionTokenOneTime(int hash) {
        block4: {
            MLCloudAuthContext context = contextMap.get(hash);
            if (context != null && context.tokenConfig != null && !context.tokenToExpire()) {
                return;
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Scheduled to obtain session token one time.");
            }
            ScheduledFuture<?> handle = scheduler.schedule(new TokenRunner(hash), 0L, TimeUnit.MINUTES);
            try {
                handle.get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (!logger.isLoggable(Level.WARNING)) break block4;
                logger.log(Level.WARNING, "Exception obtaining session token from MarkLogic Cloud token endpoint. " + e.getMessage());
            }
        }
    }

    private static void runRenewSessionToken(int hash) {
        MLCloudAuthContext context = contextMap.get(hash);
        if (context != null && context.tokenConfig != null) {
            long initDelay = context.getInitDelay();
            long period = context.getPeriod();
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Scheduled to renew session token periodically. initDelay=" + initDelay + " minutes, period=" + period + " minutes.");
            }
            scheduler.scheduleWithFixedDelay(new TokenRunner(hash), initDelay, period, TimeUnit.MINUTES);
        }
    }

    public static void setTokenConfig(char[] apiKey, char[] curToken, long tokenExpiration, long tokenDuration) {
        int hash = new String(apiKey).hashCode();
        MLCloudAuthContext context = contextMap.get(hash);
        if (context != null) {
            context.setTokenConfig(curToken, tokenExpiration, tokenDuration);
        }
    }

    public static String getSessionToken(char[] apiKey) {
        int hash = new String(apiKey).hashCode();
        MLCloudAuthContext context = contextMap.get(hash);
        if (context != null && context.tokenConfig != null) {
            return new String(context.tokenConfig.curToken);
        }
        return null;
    }

    public static long getTokenExpiration(char[] apiKey) {
        int hash = new String(apiKey).hashCode();
        MLCloudAuthContext context = contextMap.get(hash);
        if (context != null && context.tokenConfig != null) {
            return context.tokenConfig.tokenExpiration;
        }
        return 0L;
    }

    public static long getTokenDuration(char[] apiKey) {
        int hash = new String(apiKey).hashCode();
        MLCloudAuthContext context = contextMap.get(hash);
        if (context != null && context.tokenConfig != null) {
            return context.tokenConfig.tokenDuration;
        }
        return 0L;
    }

    static {
        contextMap = new ConcurrentHashMap();
        logger = Logger.getLogger(MLCloudAuthManager.class.getName());
        scheduler = Executors.newScheduledThreadPool(1, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setPriority(10);
            return t;
        });
    }

    private static class TokenRunner
    implements Runnable {
        private final int apiKeyHash;

        public TokenRunner(int apiKeyHash) {
            this.apiKeyHash = apiKeyHash;
        }

        @Override
        public void run() {
            MLCloudAuthContext context = (MLCloudAuthContext)contextMap.get(this.apiKeyHash);
            if (context == null) {
                throw new RuntimeException("Unrecognized user api key.");
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Connecting to MarkLogic Cloud to obtain session token.");
            }
            Session session = context.cs.newSession();
            AdhocQuery request = session.newAdhocQuery("()");
            MLCloudRequestController controller = new MLCloudRequestController(session.getUserCredentials().getMLCloudAuthConfig());
            try {
                controller.runRequest(session.getContentSource().getConnectionProvider(), request, session.getLogger());
            }
            catch (RequestException e) {
                throw new RuntimeException("Exception obtaining session token.", e);
            }
        }
    }

    private static class MLCloudAuthContext {
        private final ContentSource cs;
        private TokenConfig tokenConfig;

        private MLCloudAuthContext(ContentSource cs) {
            this.cs = cs;
        }

        private void setTokenConfig(char[] curToken, long tokenExpiration, long tokenDuration) {
            this.tokenConfig = new TokenConfig(curToken, tokenExpiration, tokenDuration);
        }

        private long getInitDelay() {
            return TimeUnit.MILLISECONDS.toMinutes(this.tokenConfig.tokenExpiration - System.currentTimeMillis()) - 1L;
        }

        private long getPeriod() {
            return this.tokenConfig.tokenDuration - 1L;
        }

        private boolean tokenToExpire() {
            return TimeUnit.MILLISECONDS.toMinutes(this.tokenConfig.tokenExpiration - System.currentTimeMillis()) - 1L <= 0L;
        }

        private static class TokenConfig {
            private final char[] curToken;
            private final long tokenExpiration;
            private final long tokenDuration;

            private TokenConfig(char[] curToken, long tokenExpiration, long tokenDuration) {
                this.curToken = curToken;
                this.tokenExpiration = tokenExpiration;
                this.tokenDuration = tokenDuration;
            }
        }
    }
}

