/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.job;

import com.marklogic.client.ext.datamovement.job.AbstractQueryBatcherJob;
import com.marklogic.client.ext.datamovement.listener.SetPermissionsListener;
import java.util.Arrays;

public class SetPermissionsJob
extends AbstractQueryBatcherJob {
    private String[] rolesAndCapabilities;

    public SetPermissionsJob() {
        this.addRequiredJobProperty("permissions", "Comma-delimited list of roles and capabilities defining permissions to set on selected records", value -> this.setRolesAndCapabilities(value.split(",")));
    }

    public SetPermissionsJob(String ... rolesAndCapabilities) {
        this();
        this.setRolesAndCapabilities(rolesAndCapabilities);
    }

    @Override
    protected String getJobDescription() {
        return "Setting permissions " + Arrays.asList(this.rolesAndCapabilities) + " on documents " + this.getQueryDescription();
    }

    public void setRolesAndCapabilities(String ... rolesAndCapabilities) {
        this.rolesAndCapabilities = rolesAndCapabilities;
        this.addUrisReadyListener(new SetPermissionsListener(rolesAndCapabilities));
    }
}

