/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.job;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.datamovement.ExportToWriterListener;
import com.marklogic.client.datamovement.QueryBatchListener;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.ext.datamovement.QueryBatcherJobTicket;
import com.marklogic.client.ext.datamovement.job.AbstractQueryBatcherJob;
import com.marklogic.client.ext.datamovement.listener.XmlOutputListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;

public class ExportToFileJob
extends AbstractQueryBatcherJob {
    private File exportFile;
    private String fileHeader;
    private String fileFooter;
    private FileWriter fileWriter;
    private ExportToWriterListener exportToWriterListener;
    private boolean includeXmlOutputListener = true;
    private String recordSuffix;
    private boolean omitLastRecordSuffix = false;

    public ExportToFileJob() {
        this.addRequiredJobProperty("exportPath", "The path of the file to which selected records are exported", value -> this.setExportFile(new File((String)value)));
        this.addJobProperty("fileHeader", "Optional content that should be written to the start of each file", value -> this.setFileHeader((String)value));
        this.addJobProperty("fileFooter", "Optional content that should be written to the end of each file", value -> this.setFileFooter((String)value));
        this.addJobProperty("omitLastRecordSuffix", "If a recordSuffix is specified, and this is set to true, then the record suffix will not be written after the last record is written to the file (the file footer will still be written)", value -> this.setOmitLastRecordSuffix(Boolean.parseBoolean(value)));
        this.addJobProperty("recordPrefix", "Optional content to be written before each record is written", value -> this.getExportListener().withRecordPrefix(value));
        this.addJobProperty("recordSuffix", "Optional content to be written after each record is written", value -> this.setRecordSuffix((String)value));
        this.addTransformJobProperty((value, transform) -> this.getExportListener().withTransform(transform));
    }

    public ExportToFileJob(File exportFile) {
        this();
        this.setExportFile(exportFile);
    }

    @Override
    protected String getJobDescription() {
        return "Exporting documents " + this.getQueryDescription() + " to file at: " + this.exportFile;
    }

    public void setRecordSuffix(String recordSuffix) {
        this.recordSuffix = recordSuffix;
        if (this.exportToWriterListener != null) {
            this.exportToWriterListener.withRecordSuffix(recordSuffix);
        }
    }

    public void setExportFile(File exportFile) {
        this.exportFile = exportFile;
        File parentFile = this.exportFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        try {
            this.fileWriter = new FileWriter(exportFile);
        }
        catch (IOException ie) {
            throw new RuntimeException("Unable to open FileWriter on file: " + exportFile + "; cause: " + ie.getMessage(), ie);
        }
        this.exportToWriterListener = new ExportToWriterListener((Writer)this.fileWriter);
        if (this.recordSuffix != null) {
            this.exportToWriterListener.withRecordSuffix(this.recordSuffix);
        }
        this.addUrisReadyListener((QueryBatchListener)this.exportToWriterListener);
    }

    @Override
    protected void prepareQueryBatcher(QueryBatcher queryBatcher) {
        super.prepareQueryBatcher(queryBatcher);
        if (this.includeXmlOutputListener) {
            this.exportToWriterListener.onGenerateOutput((ExportToWriterListener.OutputListener)new XmlOutputListener());
        }
        try {
            if (this.fileHeader != null) {
                this.fileWriter.write(this.fileHeader);
                this.fileWriter.write("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public QueryBatcherJobTicket run(DatabaseClient databaseClient) {
        QueryBatcherJobTicket ticket = super.run(databaseClient);
        if (ticket.getQueryBatcher().isStopped()) {
            if (this.omitLastRecordSuffix && this.recordSuffix != null) {
                this.removeLastRecordSuffixAndWriteFileFooter(this.fileWriter, this.recordSuffix, this.fileFooter);
            } else {
                this.writeFileFooter(this.fileWriter, this.fileFooter);
            }
        }
        return ticket;
    }

    protected void removeLastRecordSuffixAndWriteFileFooter(FileWriter fileWriter, String recordSuffix, String fileFooter) {
        this.closeFileWriter(fileWriter);
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.exportFile, "rw");
            int len = recordSuffix.length();
            raf.seek(raf.length() - (long)len);
            if (fileFooter != null) {
                raf.write(fileFooter.getBytes());
            } else {
                for (int i = 0; i < len; ++i) {
                    raf.write(" ".getBytes());
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected void writeFileFooter(FileWriter fileWriter, String fileFooter) {
        try {
            if (fileFooter != null) {
                fileWriter.write(fileFooter);
            }
        }
        catch (IOException ie) {
            throw new RuntimeException(ie);
        }
        finally {
            this.closeFileWriter(fileWriter);
        }
    }

    protected void closeFileWriter(FileWriter fileWriter) {
        try {
            fileWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FileWriter getFileWriter() {
        return this.fileWriter;
    }

    public File getExportFile() {
        return this.exportFile;
    }

    public ExportToWriterListener getExportListener() {
        return this.exportToWriterListener;
    }

    public void setFileHeader(String fileHeader) {
        this.fileHeader = fileHeader;
    }

    public void setFileFooter(String fileFooter) {
        this.fileFooter = fileFooter;
    }

    public void setIncludeXmlOutputListener(boolean includeXmlOutputListener) {
        this.includeXmlOutputListener = includeXmlOutputListener;
    }

    public void setOmitLastRecordSuffix(boolean omitLastRecordSuffix) {
        this.omitLastRecordSuffix = omitLastRecordSuffix;
    }
}

