/**
 Copyright (c) 2021 MarkLogic Corporation

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
// No privilege required: No special privilege is needed for this endpoint
import entityLib from "/data-hub/5/impl/entity-lib.mjs";
import graphUtils from "/data-hub/5/impl/graph-utils.mjs";
import httpUtils from "/data-hub/5/impl/http-utils.mjs";

const sem = require("/MarkLogic/semantics.xqy");

const queryParam = external.query;
const startParam = external.start;
const pageLengthParam = external.pageLength;

if (!queryParam) {
  httpUtils.throwBadRequest("Request cannot be empty");
}

let queryObj = queryParam.toObject() || {};
let start = startParam;
let pageLength = pageLengthParam;
let structuredQuery = external.structuredQuery;
let queryOptions = external.queryOptions;

let relatedEntityTypeIds = queryObj.relatedEntityTypeIds || [];
let relatedEntityTypeIRIs = [];
let entityTypeIRIs = [];
let entitiesDifferentsFromBaseAndRelated = [];
let allRelatedPredicateList = [];
let predicateConceptList = [];
start = start || 0;
pageLength = pageLength || 100;

for (const modelNode of fn.collection(entityLib.getModelCollection())) {
  const model = modelNode.toObject();
  const entityName = model.info.title;
  const entityNameIri = entityLib.getEntityTypeId(model, entityName);

  if (relatedEntityTypeIds.includes(entityName)) {
    relatedEntityTypeIRIs.push(sem.iri(entityNameIri));
  }
  if (queryObj.entityTypeIds.includes(entityName)) {
    //get predicate from concepts
    predicateConceptList = predicateConceptList.concat(entityLib.getConceptPredicatesByModel(model));
    if (relatedEntityTypeIds.length > 0) {
      const predicateListBaseEntities = entityLib.getPredicatesByModelAndBaseEntities(model, relatedEntityTypeIds);
      allRelatedPredicateList = allRelatedPredicateList.concat(predicateListBaseEntities);
    }
    entityTypeIRIs.push(sem.iri(entityNameIri));
  }
  if (!queryObj.entityTypeIds.includes(entityName) && !(relatedEntityTypeIds && relatedEntityTypeIds.includes(entityName))) {
    entitiesDifferentsFromBaseAndRelated.push(sem.iri(entityNameIri));
  }
}


let ctsQuery = graphUtils.buildCtsQuery(structuredQuery, queryObj.searchText, queryOptions);

let conceptFacetList = [];
if (queryObj.conceptsFilterTypeIds != null) {
  queryObj.conceptsFilterTypeIds.map(item => {
    conceptFacetList.push(sem.iri(item));
  });
}

const result = graphUtils.getEntityNodesWithRelated(entityTypeIRIs, relatedEntityTypeIRIs, predicateConceptList, entitiesDifferentsFromBaseAndRelated, conceptFacetList, ctsQuery, pageLength);
//get total from base entities
let resultBaseCounting = graphUtils.getEntityTypeIRIsCounting(entityTypeIRIs, ctsQuery);
let totalCount = fn.head(resultBaseCounting).total;

if (relatedEntityTypeIRIs.length) {
  //get total from related entities
  let totalRelatedEntities = graphUtils.getRelatedEntitiesCounting(allRelatedPredicateList, ctsQuery);
  let totalRelated = fn.head(totalRelatedEntities).total;
  totalCount += totalRelated;
}
if (predicateConceptList.length) {
  //get total Concepts
  let totalConcepts = graphUtils.getConceptCounting(entityTypeIRIs, predicateConceptList, ctsQuery);
  let totalConcept = fn.head(totalConcepts).total;
  totalCount += totalConcept;
}

const totalEstimate = totalCount;
const relatedEntitiesAreFiltered = entitiesDifferentsFromBaseAndRelated.length > 0;
const {data, count} = graphUtils.graphResultsToNodesAndEdges(result, relatedEntitiesAreFiltered);

const supportsGraphConceptsSearch = true;
const response = {
  supportsGraphConceptsSearch,
  'total': (start === 0 && (!pageLength || totalEstimate < pageLength)) ? count: totalEstimate,
  'start': start,
  'limit': count,
  data
};

response;
