/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.util.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONObject {
    private static final Logger logger = LoggerFactory.getLogger(JSONObject.class);
    ObjectMapper mapper;
    JsonNode json;

    public JSONObject() {
        this(false);
    }

    public JSONObject(boolean createMapper) {
        if (createMapper) {
            this.mapper = new ObjectMapper();
        }
        this.json = JsonNodeFactory.instance.objectNode();
    }

    public JSONObject(Object dataVal) throws IOException {
        block6: {
            try {
                this.mapper = new ObjectMapper();
                if (dataVal instanceof String) {
                    this.json = (JsonNode)this.mapper.readValue((String)dataVal, JsonNode.class);
                    break block6;
                }
                if (dataVal instanceof byte[]) {
                    this.json = (JsonNode)this.mapper.readValue((byte[])dataVal, JsonNode.class);
                    break block6;
                }
                if (dataVal instanceof JsonNode) {
                    this.json = (JsonNode)dataVal;
                    break block6;
                }
                if (dataVal instanceof File) {
                    this.json = (JsonNode)this.mapper.readValue((File)dataVal, JsonNode.class);
                    break block6;
                }
                throw new IOException("Unknown type");
            }
            catch (JsonParseException e) {
                throw new IOException(e);
            }
        }
    }

    public JSONObject(JsonNode json) {
        this.json = json == null ? JsonNodeFactory.instance.objectNode() : json;
    }

    public static JsonNode readInput(String jsonString) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (JsonNode)mapper.readValue(jsonString, JsonNode.class);
    }

    public static JsonNode readInput(InputStream istream) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readTree(istream);
    }

    public static JsonNode readInput(Reader reader) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readTree(reader);
    }

    public static String writeValueAsString(Object obj) throws JsonProcessingException {
        return JSONObject.writeValueAsString(obj, true);
    }

    public static String writeValueAsString(Object obj, boolean hasPrettyPrint) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        if (hasPrettyPrint) {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        return mapper.writeValueAsString(obj);
    }

    public JsonNode jsonNode() {
        return this.json;
    }

    @JsonIgnore
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public String toString() {
        return this.json.toString();
    }

    public boolean isExist(String key) {
        return this.json.has(key);
    }

    public int getJsonArraySize(String key) {
        if (this.json.get(key).isArray()) {
            return this.json.get(key).size();
        }
        return 0;
    }

    public JsonNode getNode(Object key) {
        return this.getNode(key, null);
    }

    public JsonNode getNode(Object key, JsonNode defaultVal) {
        if (key == null) {
            return null;
        }
        if (key instanceof String) {
            return this.json.get((String)key) == null ? defaultVal : this.json.get((String)key);
        }
        if (key instanceof Integer) {
            return this.json.get(((Integer)key).intValue()) == null ? defaultVal : this.json.get(((Integer)key).intValue());
        }
        logger.error("Object key: {} is not part of any known type", key);
        return null;
    }

    public String getString(Object key) {
        return this.getString(key, null);
    }

    public String getString(Object key, String defaultVal) {
        if (key instanceof String) {
            return this.json.get((String)key) == null ? defaultVal : this.json.get((String)key).asText();
        }
        if (key instanceof Integer) {
            return this.json.get(((Integer)key).intValue()) == null ? defaultVal : this.json.get(((Integer)key).intValue()).asText();
        }
        return null;
    }

    public Integer getIntValue(String key) {
        return this.json.get(key) == null ? null : Integer.valueOf(this.json.get(key).asInt());
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(Object key, int defaultVal) {
        return this.json.get((String)key) == null ? defaultVal : this.json.get((String)key).asInt();
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public Boolean getBoolean(Object key, Boolean defaultVal) {
        return this.json.get((String)key) == null ? defaultVal.booleanValue() : this.json.get((String)key).asBoolean();
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(Object key, long defaultVal) {
        JsonNode obj = this.json.get((String)key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof NullNode) {
            return defaultVal;
        }
        if (obj.isNumber()) {
            return obj.asLong();
        }
        if (obj.isTextual()) {
            return Long.parseLong(obj.asText());
        }
        throw new ClassCastException("get failed for " + key + ", expected long, got " + obj.getClass().getName());
    }

    public List<Object> getArray(String key) {
        ArrayList<Object> listObj = new ArrayList<Object>();
        for (JsonNode s : this.json.get(key)) {
            listObj.add(s);
        }
        return listObj;
    }

    public Map<String, Object> getMap(String key) {
        HashMap<String, Object> mapObj = new HashMap<String, Object>();
        if (this.json.get(key) == null) {
            return mapObj;
        }
        Iterator entryIterator = this.json.get(key).fields();
        while (entryIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)entryIterator.next();
            mapObj.put((String)entry.getKey(), entry.getValue());
        }
        return mapObj;
    }

    public String convertMapToJsonString(Map<String, Object> map) throws JsonProcessingException {
        if (map == null) {
            return null;
        }
        this.putMap(map);
        this.mapper = new ObjectMapper();
        return this.mapper.writeValueAsString((Object)this.json);
    }

    public void putMap(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public List<String> getArrayString(String key, boolean allowNull) {
        ArrayList<String> listString = new ArrayList<String>();
        for (JsonNode s : this.json.get(key)) {
            if (!allowNull && s.isNull()) continue;
            listString.add(s.asText());
        }
        return listString;
    }

    public List<String> getArrayString(String key) {
        return this.getArrayString(key, true);
    }

    public void put(String key, Object val) {
        if (val instanceof String) {
            ((ObjectNode)this.json).put(key, (String)val);
        } else if (val instanceof Integer) {
            ((ObjectNode)this.json).put(key, (Integer)val);
        } else if (val instanceof Long) {
            ((ObjectNode)this.json).put(key, (Long)val);
        } else if (val instanceof Float) {
            ((ObjectNode)this.json).put(key, (Float)val);
        } else if (val instanceof Double) {
            ((ObjectNode)this.json).put(key, (Double)val);
        } else if (val instanceof Boolean) {
            ((ObjectNode)this.json).put(key, (Boolean)val);
        } else if (val instanceof JsonNode) {
            ((ObjectNode)this.json).set(key, (JsonNode)val);
        } else if (val instanceof JSONObject) {
            ((ObjectNode)this.json).set(key, ((JSONObject)val).jsonNode());
        } else {
            throw new ClassCastException("put failed for" + key + ", got " + val.getClass().getName());
        }
    }

    public void putArray(String key, Object ... vals) {
        ArrayList lstVal = new ArrayList();
        Collections.addAll(lstVal, vals);
        this.putArray(key, lstVal);
    }

    public void putArray(String key, List<?> valList) {
        ArrayNode array = ((ObjectNode)this.json).putArray(key);
        for (Object val : valList) {
            if (val instanceof String) {
                array.add((String)val);
                continue;
            }
            if (val instanceof Integer) {
                array.add((Integer)val);
                continue;
            }
            if (val instanceof Long) {
                array.add((Long)val);
                continue;
            }
            if (val instanceof Float) {
                array.add((Float)val);
                continue;
            }
            if (val instanceof JsonNode) {
                array.add((JsonNode)val);
                continue;
            }
            if (val instanceof JSONObject) {
                array.add(((JSONObject)val).jsonNode());
                continue;
            }
            throw new ClassCastException("put failed for " + key + ", got " + val.getClass().getName());
        }
    }

    public void prettyPrint() {
        try {
            logger.info(this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.json));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

