/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class FileUtil {
    public static void copy(InputStream source, File destination) {
        try {
            FileUtils.copyInputStreamToFile((InputStream)source, (File)destination);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> listDirectFolders(File rootDirectory) {
        ArrayList<String> folders = new ArrayList<String>();
        if (rootDirectory.exists() && rootDirectory.isDirectory()) {
            File[] files = rootDirectory.listFiles();
            if (files == null) {
                return folders;
            }
            for (File file : files) {
                if (!file.isDirectory() || file.isHidden()) continue;
                folders.add(file.getName());
            }
        }
        Collections.sort(folders);
        return folders;
    }

    public static List<String> listDirectFolders(String rootDirectoryName) {
        return FileUtil.listDirectFolders(new File(rootDirectoryName));
    }

    public static List<String> listDirectFolders(Path rootDirectoryPath) {
        return FileUtil.listDirectFolders(rootDirectoryPath.toFile());
    }

    public static List<String> listDirectFiles(File rootDirectory) {
        ArrayList<String> filenames = new ArrayList<String>();
        if (rootDirectory.exists() && rootDirectory.isDirectory()) {
            File[] files = rootDirectory.listFiles();
            if (files == null) {
                return filenames;
            }
            for (File file : files) {
                if (file.isDirectory() || file.isHidden()) continue;
                filenames.add(file.getName());
            }
        }
        Collections.sort(filenames);
        return filenames;
    }

    public static List<String> listDirectFiles(String rootDirectoryName) {
        return FileUtil.listDirectFiles(new File(rootDirectoryName));
    }

    public static List<String> listDirectFiles(Path rootDirectoryPath) {
        return FileUtil.listDirectFiles(rootDirectoryPath.toFile());
    }
}

