/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.hub.HubClient;
import com.marklogic.hub.dataservices.SystemService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class VersionInfo {
    private String hubVersion;
    private String markLogicVersion;
    private String clusterName;
    private String stagingDbName;
    private String finalDbName;
    private String jobsDbName;
    private Boolean supportConcepts;

    public VersionInfo(String hubVersion, String markLogicVersion, String stagingDbName, String finalDbName, String jobsDbName, String supportConcepts) {
    }

    public static VersionInfo newVersionInfo(HubClient hubClient) {
        JsonNode json = SystemService.on(hubClient.getStagingClient()).getVersions();
        return new VersionInfo(json.get("hubVersion").asText(), json.get("markLogicVersion").asText(), json.get("clusterName").asText(), json.get("stagingDbName").asText(), json.get("finalDbName").asText(), json.get("jobsDbName").asText(), json.get("supportConcepts").asBoolean());
    }

    private VersionInfo(String hubVersion, String markLogicVersion, String clusterName, String stagingDbName, String finalDbName, String jobsDbName, Boolean supportConcepts) {
        this.hubVersion = hubVersion;
        this.markLogicVersion = markLogicVersion;
        this.clusterName = clusterName;
        this.stagingDbName = stagingDbName;
        this.finalDbName = finalDbName;
        this.jobsDbName = jobsDbName;
        this.supportConcepts = supportConcepts;
    }

    public String getHubVersion() {
        return this.hubVersion;
    }

    public String getMarkLogicVersion() {
        return this.markLogicVersion;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getStagingDbName() {
        return this.stagingDbName;
    }

    public String getFinalDbName() {
        return this.finalDbName;
    }

    public String getJobsDbName() {
        return this.jobsDbName;
    }

    public Boolean getSupportConcepts() {
        return this.supportConcepts;
    }

    public static String getBuildVersion() {
        Properties properties = new Properties();
        try (InputStream inputStream = VersionInfo.class.getClassLoader().getResourceAsStream("version.properties");){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get library version from version.properties, cause: " + e.getMessage(), e);
        }
        String version = properties.getProperty("version");
        return "${project.version}".equals(version) ? "6.1.1" : version;
    }
}

