/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.dataservices.StepService;
import com.marklogic.hub.error.DataHubProjectException;
import com.marklogic.hub.impl.HubConfigImpl;
import com.marklogic.hub.impl.Scaffolding;
import com.marklogic.hub.impl.StepDefinitionManagerImpl;
import com.marklogic.hub.impl.Versions;
import com.marklogic.hub.step.StepDefinition;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ScaffoldingImpl
extends LoggingObject
implements Scaffolding {
    private static final Pattern placeholderPattern = Pattern.compile("placeholder", 16);
    @Autowired
    HubConfig hubConfig;
    Versions versions;

    public ScaffoldingImpl() {
    }

    public ScaffoldingImpl(HubConfig hubConfig) {
        this();
        this.hubConfig = hubConfig;
    }

    public static String getAbsolutePath(String first, String ... more) {
        StringBuilder absolutePath = new StringBuilder(first);
        for (String path : more) {
            absolutePath.append(File.separator);
            absolutePath.append(path);
        }
        return absolutePath.toString();
    }

    public StepDefinition createStepDefinition(String name, String type, String format) {
        StepDefinitionManagerImpl stepDefinitionManager = new StepDefinitionManagerImpl(this.hubConfig);
        StepDefinition stepDef = StepDefinition.create(name, Objects.requireNonNull(StepDefinition.StepDefinitionType.getStepDefinitionType(type)));
        if (stepDefinitionManager.getStepDefinition(name, stepDef.getType()) != null) {
            throw new IllegalArgumentException(this.format("A step definition already exists with the name '%s' and type '%s'", new Object[]{name, type}));
        }
        stepDef.setModulePath(String.format("/custom-modules/%s/%s/main.%s", type.toLowerCase(), name, format));
        stepDefinitionManager.saveStepDefinition(stepDef);
        this.createCustomModule(name, type, format);
        return stepDef;
    }

    public Pair<File, String> createStepFile(String stepName, String stepType, String stepDefName, String entityType) {
        return this.createStepFile(stepName, stepType, stepDefName, entityType, false);
    }

    public Pair<File, String> createStepFile(String stepName, String stepType, String stepDefName, String entityType, boolean acceptSourceModule) {
        String message = "";
        JsonNode stepPayLoad = this.getStepConfig(stepName, stepType, stepDefName, entityType, acceptSourceModule);
        String stepDefMessage = this.saveStepDefinition(stepName, stepDefName, stepType);
        Pair<File, String> step = this.saveStep(stepType, stepPayLoad);
        message = message.concat(stepDefMessage).concat((String)step.getRight());
        return Pair.of((Object)step.getLeft(), (Object)message);
    }

    public JsonNode getStepConfig(String stepName, String stepType, String stepDefName, String entityType, boolean acceptSourceModule) {
        StepDefinition.StepDefinitionType stepDefType = StepDefinition.StepDefinitionType.getStepDefinitionType(stepType);
        Assert.notNull((Object)((Object)stepDefType), (String)("Unrecognized step type: " + stepType));
        File stepFile = this.hubConfig.getHubProject().getStepFile(stepDefType, stepName);
        if (stepFile.exists()) {
            throw new IllegalArgumentException("Cannot create step; a step file already exists at: " + stepFile.getAbsolutePath() + ". Please choose a different name for your step.");
        }
        stepFile.getParentFile().mkdirs();
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode stepPayLoad = objectMapper.createObjectNode();
        stepPayLoad.put("name", stepName);
        stepPayLoad.put("description", "");
        stepPayLoad.put("stepDefinitionType", stepType);
        if (stepDefName != null) {
            stepPayLoad.put("stepDefinitionName", stepDefName);
        } else if (StepDefinition.StepDefinitionType.CUSTOM.equals((Object)stepDefType)) {
            stepDefName = stepName;
            stepPayLoad.put("stepDefinitionName", stepDefName);
        }
        if ("ingestion".equalsIgnoreCase(stepType)) {
            stepPayLoad.put("sourceFormat", "json");
            stepPayLoad.put("targetFormat", "json");
        } else {
            stepPayLoad.put("selectedSource", "query");
            if ("custom".equalsIgnoreCase(stepType) || "mapping".equalsIgnoreCase(stepType)) {
                if (acceptSourceModule) {
                    stepPayLoad.put("selectedSource", "sourceModule");
                    ObjectNode node = objectMapper.createObjectNode();
                    node.put("modulePath", "");
                    node.put("functionName", "");
                    stepPayLoad.put("sourceModule", (JsonNode)node);
                } else {
                    stepPayLoad.put("sourceQuery", "cts.collectionQuery('changeme')");
                }
                if (entityType != null) {
                    stepPayLoad.put("entityType", entityType);
                }
                if ("mapping".equalsIgnoreCase(stepType)) {
                    stepPayLoad.put("attachSourceDocument", false);
                }
            }
        }
        return stepPayLoad;
    }

    public String saveStepDefinition(String stepName, String stepDefName, String stepType) {
        return this.saveStepDefinition(stepName, stepDefName, stepType, false);
    }

    public String saveStepDefinition(String stepName, String stepDefName, String stepType, boolean legacyUpgrade) {
        StepDefinitionManagerImpl stepDefinitionManager = new StepDefinitionManagerImpl(this.hubConfig);
        StringBuilder messageBuilder = new StringBuilder(256);
        if (stepDefName != null && stepDefinitionManager.getStepDefinition(stepDefName, StepDefinition.StepDefinitionType.getStepDefinitionType(stepType)) == null) {
            try {
                StepDefinition stepDefinition = StepDefinition.create(stepDefName, Objects.requireNonNull(StepDefinition.StepDefinitionType.getStepDefinitionType(stepType)));
                stepDefinition.setModulePath("/custom-modules/" + stepType.toLowerCase() + "/" + stepDefName + "/main.mjs");
                if (legacyUpgrade) {
                    Map<String, Object> options = stepDefinition.getOptions();
                    HubConfigImpl config = (HubConfigImpl)this.hubConfig;
                    if (stepDefinition.getType().toString().equalsIgnoreCase("custom")) {
                        options.put("sourceDatabase", config.getStagingDbName());
                        options.put("targetDatabase", config.getFinalDbName());
                    }
                    if (stepDefinition.getType().toString().equalsIgnoreCase("ingestion")) {
                        options.put("targetDatabase", config.getStagingDbName());
                    }
                    stepDefinition.setOptions(options);
                    stepDefinitionManager.saveLocalStepDefinition(stepDefinition);
                } else {
                    stepDefinitionManager.saveStepDefinition(stepDefinition);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to write step definition to database; cause: " + e.getMessage(), e);
            }
            this.createCustomModule(stepDefName, stepType, legacyUpgrade);
            messageBuilder.append(String.format("Created step definition '%s' of type '%s'.\n", stepName, stepType));
            messageBuilder.append("The module file for the step definition is available at /custom-modules/").append(stepType.toLowerCase()).append("/").append(stepDefName).append("/main.mjs").append(". \n");
            messageBuilder.append("It is recommended to run './gradlew -i mlWatch' so that as you modify the module, it will be automatically loaded into your application's modules database.\n");
        }
        return messageBuilder.toString();
    }

    public Pair<File, String> saveStep(String stepType, JsonNode stepPayLoad) {
        JsonNode step;
        DatabaseClient stagingClient = this.hubConfig.newHubClient().getStagingClient();
        String stepName = stepPayLoad.get("name").asText();
        File stepFile = this.hubConfig.getHubProject().getStepFile(StepDefinition.StepDefinitionType.getStepDefinitionType(stepType), stepName);
        StringBuilder messageBuilder = new StringBuilder();
        try {
            StepService stepService = StepService.on(stagingClient);
            step = stepService.saveStep(stepType, stepPayLoad, false, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to write step to database; cause: " + e.getMessage(), e);
        }
        messageBuilder.append("Created step '").append(stepName).append("' of type '").append(stepType).append("' with default properties. The step has been deployed to staging and final databases.");
        try {
            new ObjectMapper().writerWithDefaultPrettyPrinter().writeValue(stepFile, (Object)step);
            return Pair.of((Object)stepFile, (Object)messageBuilder.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write step to file: " + stepFile.getAbsolutePath() + "; cause: " + e.getMessage(), e);
        }
    }

    public void saveLocalStep(String stepType, JsonNode stepPayLoad) {
        String stepName = stepPayLoad.get("name").asText();
        File stepFile = this.hubConfig.getHubProject().getStepFile(StepDefinition.StepDefinitionType.getStepDefinitionType(stepType), stepName);
        try {
            new ObjectMapper().writerWithDefaultPrettyPrinter().writeValue(stepFile, (Object)stepPayLoad);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write step to file: " + stepFile.getAbsolutePath() + "; cause: " + e.getMessage(), e);
        }
    }

    @Override
    public void createEntity(String entityName) {
        Path entityDir = this.hubConfig.getHubProject().getHubEntitiesDir();
        File entityFile = entityDir.resolve(entityName + ".entity.json").toFile();
        if (entityFile.exists()) {
            throw new DataHubProjectException("Entity with that name already exists.");
        }
        File entityDirFile = entityDir.toFile();
        if (!entityDirFile.exists()) {
            entityDirFile.mkdirs();
        }
        String fileContents = ScaffoldingImpl.getFileContent("scaffolding/Entity.json", entityName);
        ScaffoldingImpl.writeToFile(fileContents, entityFile);
    }

    @Override
    public void createMappingDir(String mappingName) {
        Path mappingDir = this.hubConfig.getHubProject().getMappingDir(mappingName);
        mappingDir.toFile().mkdirs();
    }

    @Override
    public void createCustomModule(String stepName, String stepType) {
        this.createCustomModule(stepName, stepType, "mjs");
    }

    @Override
    public void createCustomModule(String stepName, String stepType, String format) {
        this.createCustomModule(stepName, stepType, format, false);
    }

    public void createCustomModule(String stepName, String stepType, boolean legacyUpgrade) {
        this.createCustomModule(stepName, stepType, "mjs", legacyUpgrade);
    }

    public void createCustomModule(String stepName, String stepType, String format, boolean legacyUpgrade) {
        Path customModuleDir = this.hubConfig.getHubProject().getCustomModuleDir(stepName, stepType.toLowerCase());
        customModuleDir.toFile().mkdirs();
        if (customModuleDir.toFile().exists()) {
            String moduleScaffoldingSrcFile;
            String legacyUpgradeExt = legacyUpgrade ? "-legacy-upgrade" : "";
            String libScaffoldingSrcFile = null;
            if ("sjs".equalsIgnoreCase(format)) {
                moduleScaffoldingSrcFile = "scaffolding/custom-module/sjs/main-" + stepType.toLowerCase() + legacyUpgradeExt + ".sjs";
            } else if ("mjs".equalsIgnoreCase(format)) {
                moduleScaffoldingSrcFile = "scaffolding/custom-module/mjs/main-" + stepType.toLowerCase() + legacyUpgradeExt + ".mjs";
            } else if ("xqy".equalsIgnoreCase(format)) {
                moduleScaffoldingSrcFile = "scaffolding/custom-module/xqy/main-" + stepType.toLowerCase() + ".sjs";
                libScaffoldingSrcFile = "scaffolding/custom-module/xqy/lib-" + stepType.toLowerCase() + ".xqy";
            } else {
                throw new RuntimeException("Invalid code format. The allowed formats are 'xqy' , 'sjs' or 'mjs'");
            }
            File moduleFile = customModuleDir.resolve("main.mjs").toFile();
            InputStream inputStream = ScaffoldingImpl.class.getClassLoader().getResourceAsStream(moduleScaffoldingSrcFile);
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(this.format("Writing module to: %s", new Object[]{moduleFile.getAbsolutePath()}));
                }
                assert (inputStream != null);
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)moduleFile);
                File libFile = customModuleDir.resolve("lib.xqy").toFile();
                if (libScaffoldingSrcFile != null) {
                    InputStream libInputStream = ScaffoldingImpl.class.getClassLoader().getResourceAsStream(libScaffoldingSrcFile);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info(this.format("Writing module to: %s", new Object[]{libFile.getAbsolutePath()}));
                    }
                    assert (libInputStream != null);
                    FileUtils.copyInputStreamToFile((InputStream)libInputStream, (File)libFile);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public File createDefaultFlow(String flowName) {
        Path flowsDir = this.hubConfig.getHubProject().getFlowsDir();
        flowsDir.toFile().mkdirs();
        File flowFile = flowsDir.resolve(flowName + ".flow.json").toFile();
        if (flowsDir.toFile().exists()) {
            HashMap<String, String> customTokens = new HashMap<String, String>();
            customTokens.put("%%mlStagingDbName%%", this.hubConfig.getDbName(DatabaseKind.STAGING));
            customTokens.put("%%mlFinalDbName%%", this.hubConfig.getDbName(DatabaseKind.FINAL));
            customTokens.put("%%mlFlowName%%", flowName);
            try {
                String fileContents = ScaffoldingImpl.buildFlowFromDefaultFlow(customTokens);
                try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(flowFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
                    writer.write(fileContents);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return flowFile;
    }

    protected static String buildFlowFromDefaultFlow(Map<String, String> customTokens) throws IOException {
        String fileContents;
        String flowSrcFile = "scaffolding/defaultFlow.flow.json";
        try (InputStream inputStream = ScaffoldingImpl.class.getClassLoader().getResourceAsStream(flowSrcFile);){
            assert (inputStream != null);
            fileContents = IOUtils.toString((InputStream)inputStream);
            for (Map.Entry<String, String> entry : customTokens.entrySet()) {
                String value = entry.getValue();
                if (value == null) continue;
                fileContents = fileContents.replace(entry.getKey(), value);
            }
        }
        return fileContents;
    }

    private static void writeToFile(String fileContent, File dstFile) {
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(dstFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            bw.write(fileContent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getFileContent(String srcFile, String placeholder) {
        StringBuilder output = new StringBuilder();
        try {
            String bufferedLine;
            InputStream inputStream = Scaffolding.class.getClassLoader().getResourceAsStream(srcFile);
            assert (inputStream != null);
            BufferedReader rdr = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            while ((bufferedLine = rdr.readLine()) != null) {
                if (bufferedLine.contains("placeholder")) {
                    bufferedLine = placeholderPattern.matcher(bufferedLine).replaceAll(Matcher.quoteReplacement(placeholder));
                }
                output.append(bufferedLine);
                output.append("\n");
            }
            inputStream.close();
            rdr.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toString();
    }
}

