/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.Command;
import com.marklogic.appdeployer.command.CommandMapBuilder;
import com.marklogic.appdeployer.command.appservers.DeployOtherServersCommand;
import com.marklogic.appdeployer.command.appservers.UpdateRestApiServersCommand;
import com.marklogic.appdeployer.command.databases.DeployDatabaseCommandFactory;
import com.marklogic.appdeployer.command.databases.DeployOtherDatabasesCommand;
import com.marklogic.appdeployer.command.forests.DeployCustomForestsCommand;
import com.marklogic.appdeployer.command.modules.DeleteTestModulesCommand;
import com.marklogic.appdeployer.command.modules.LoadModulesCommand;
import com.marklogic.appdeployer.command.security.DeployAmpsCommand;
import com.marklogic.appdeployer.command.security.DeployCertificateAuthoritiesCommand;
import com.marklogic.appdeployer.command.security.DeployCertificateTemplatesCommand;
import com.marklogic.appdeployer.command.security.DeployExternalSecurityCommand;
import com.marklogic.appdeployer.command.security.DeployPrivilegesCommand;
import com.marklogic.appdeployer.command.security.DeployProtectedCollectionsCommand;
import com.marklogic.appdeployer.command.security.DeployProtectedPathsCommand;
import com.marklogic.appdeployer.command.security.DeployQueryRolesetsCommand;
import com.marklogic.appdeployer.command.security.DeployRolesCommand;
import com.marklogic.appdeployer.command.security.DeployUsersCommand;
import com.marklogic.appdeployer.command.security.InsertCertificateHostsTemplateCommand;
import com.marklogic.appdeployer.impl.SimpleAppDeployer;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.admin.QueryOptionsManager;
import com.marklogic.client.admin.ResourceExtensionsManager;
import com.marklogic.client.admin.ServerConfigurationManager;
import com.marklogic.client.admin.TransformExtensionsManager;
import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.document.DocumentWriteSet;
import com.marklogic.client.document.JSONDocumentManager;
import com.marklogic.client.eval.EvalResultIterator;
import com.marklogic.client.eval.ServerEvaluationCall;
import com.marklogic.client.impl.DocumentWriteOperationImpl;
import com.marklogic.client.io.DocumentMetadataHandle;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.QueryOptionsListHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.DocumentMetadataReadHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import com.marklogic.client.io.marker.QueryOptionsListReadHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.query.DeleteQueryDefinition;
import com.marklogic.client.query.QueryManager;
import com.marklogic.hub.DataHub;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.HubClient;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.HubProject;
import com.marklogic.hub.InstallInfo;
import com.marklogic.hub.MarkLogicVersion;
import com.marklogic.hub.dataservices.ArtifactService;
import com.marklogic.hub.deploy.commands.ConfigureAppServerBasePaths;
import com.marklogic.hub.deploy.commands.CreateGranularPrivilegesCommand;
import com.marklogic.hub.deploy.commands.DeployHubAppServersCommand;
import com.marklogic.hub.deploy.commands.DeployHubTriggersCommand;
import com.marklogic.hub.deploy.commands.FinishHubDeploymentCommand;
import com.marklogic.hub.deploy.commands.GenerateFunctionMetadataCommand;
import com.marklogic.hub.deploy.commands.HubDeployDatabaseCommandFactory;
import com.marklogic.hub.deploy.commands.LoadHubArtifactsCommand;
import com.marklogic.hub.deploy.commands.LoadHubModulesCommand;
import com.marklogic.hub.deploy.commands.LoadUserArtifactsCommand;
import com.marklogic.hub.deploy.commands.LoadUserModulesCommand;
import com.marklogic.hub.deploy.commands.RemoveOldTriggersCommand;
import com.marklogic.hub.error.DataHubConfigurationException;
import com.marklogic.hub.error.InvalidDBOperationError;
import com.marklogic.hub.flow.FlowRunner;
import com.marklogic.hub.impl.FlowManagerImpl;
import com.marklogic.hub.impl.HubConfigImpl;
import com.marklogic.hub.impl.Versions;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.admin.AdminManager;
import com.marklogic.mgmt.resource.appservers.ServerManager;
import com.marklogic.mgmt.resource.databases.DatabaseManager;
import com.marklogic.rest.util.Fragment;
import com.marklogic.rest.util.ResourcesFragment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResourceAccessException;

@Component
public class DataHubImpl
implements DataHub,
InitializingBean {
    private static final Pattern xmlPattern = Pattern.compile(".xml", 16);
    private static final Pattern modulePattern = Pattern.compile("\\.(sjs|mjs|xqy)$");
    @Autowired
    private HubConfig hubConfig;
    private HubClient hubClient;
    private LoadHubModulesCommand loadHubModulesCommand;
    private LoadUserModulesCommand loadUserModulesCommand;
    private LoadUserArtifactsCommand loadUserArtifactsCommand;
    private LoadHubArtifactsCommand loadHubArtifactsCommand;
    private GenerateFunctionMetadataCommand generateFunctionMetadataCommand;
    private Versions versions;
    @Autowired
    FlowRunner flowRunner;
    @Autowired
    FlowManagerImpl flowManager;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean stagingPortInUse;
    private String stagingPortInUseBy;
    private boolean finalPortInUse;
    private String finalPortInUseBy;
    private boolean jobPortInUse;
    private String jobPortInUseBy;
    private boolean serverVersionOk;
    private String serverVersion;

    public DataHubImpl() {
    }

    public DataHubImpl(HubConfig hubConfig) {
        this();
        this.hubConfig = hubConfig;
        this.afterPropertiesSet();
    }

    public DataHubImpl(HubClient hubClient) {
        this();
        this.hubClient = hubClient;
    }

    public void afterPropertiesSet() {
        this.versions = new Versions(this.hubConfig);
        this.generateFunctionMetadataCommand = new GenerateFunctionMetadataCommand(this.hubConfig);
        this.loadHubModulesCommand = new LoadHubModulesCommand(this.hubConfig);
        this.loadUserModulesCommand = new LoadUserModulesCommand(this.hubConfig);
        this.loadUserArtifactsCommand = new LoadUserArtifactsCommand(this.hubConfig);
        this.loadHubArtifactsCommand = new LoadHubArtifactsCommand(this.hubConfig);
    }

    protected static ServerManager constructServerManager(HubConfig hubConfig) {
        AppConfig appConfig = hubConfig.getAppConfig();
        return appConfig != null ? new ServerManager(hubConfig.getManageClient(), appConfig.getGroupName()) : new ServerManager(hubConfig.getManageClient());
    }

    private AdminManager getAdminManager() {
        return this.hubConfig.getAdminManager();
    }

    private ManageClient getManageClient() {
        return this.hubConfig.getManageClient();
    }

    private DatabaseManager getDatabaseManager() {
        return new DatabaseManager(this.getManageClient());
    }

    @Override
    public FlowRunner getFlowRunner() {
        return this.flowRunner;
    }

    @Override
    public InstallInfo isInstalled() throws ResourceAccessException {
        Fragment f;
        ResourcesFragment srf;
        InstallInfo installInfo;
        block7: {
            installInfo = InstallInfo.create();
            if (this.hubConfig.getIsProvisionedEnvironment().booleanValue()) {
                return DataHubImpl.assumedProvisionedInstallInfo(installInfo);
            }
            srf = null;
            try {
                srf = DataHubImpl.constructServerManager(this.hubConfig).getAsXml();
            }
            catch (HttpClientErrorException e) {
                if (e.getStatusCode() != HttpStatus.UNAUTHORIZED) break block7;
                throw new RuntimeException("Unable to determine if Data Hub is already installed due to unauthorized user; please verify the username and password (mlUsername and mlPassword if using Gradle)");
            }
        }
        if (srf != null) {
            installInfo.setAppServerExistent(DatabaseKind.STAGING, srf.resourceExists(this.hubConfig.getHttpName(DatabaseKind.STAGING)));
            installInfo.setAppServerExistent(DatabaseKind.FINAL, srf.resourceExists(this.hubConfig.getHttpName(DatabaseKind.FINAL)));
            installInfo.setAppServerExistent(DatabaseKind.JOB, srf.resourceExists(this.hubConfig.getHttpName(DatabaseKind.JOB)));
        }
        ResourcesFragment drf = this.getDatabaseManager().getAsXml();
        installInfo.setDbExistent(DatabaseKind.STAGING, drf.resourceExists(this.hubConfig.getDbName(DatabaseKind.STAGING)));
        installInfo.setDbExistent(DatabaseKind.FINAL, drf.resourceExists(this.hubConfig.getDbName(DatabaseKind.FINAL)));
        installInfo.setDbExistent(DatabaseKind.JOB, drf.resourceExists(this.hubConfig.getDbName(DatabaseKind.JOB)));
        installInfo.setDbExistent(DatabaseKind.MODULES, drf.resourceExists(this.hubConfig.getDbName(DatabaseKind.MODULES)));
        installInfo.setDbExistent(DatabaseKind.STAGING_SCHEMAS, drf.resourceExists(this.hubConfig.getDbName(DatabaseKind.STAGING_SCHEMAS)));
        installInfo.setDbExistent(DatabaseKind.STAGING_TRIGGERS, drf.resourceExists(this.hubConfig.getDbName(DatabaseKind.STAGING_TRIGGERS)));
        if (installInfo.isDbExistent(DatabaseKind.STAGING)) {
            f = this.getDatabaseManager().getPropertiesAsXml(this.hubConfig.getDbName(DatabaseKind.STAGING), new String[0]);
            installInfo.setTripleIndexOn(DatabaseKind.STAGING, Boolean.parseBoolean(f.getElementValue("//m:triple-index")));
            installInfo.setCollectionLexiconOn(DatabaseKind.STAGING, Boolean.parseBoolean(f.getElementValue("//m:collection-lexicon")));
            installInfo.setForestsExistent(DatabaseKind.STAGING, !f.getElements("//m:forest").isEmpty());
        }
        if (installInfo.isDbExistent(DatabaseKind.FINAL)) {
            f = this.getDatabaseManager().getPropertiesAsXml(this.hubConfig.getDbName(DatabaseKind.FINAL), new String[0]);
            installInfo.setTripleIndexOn(DatabaseKind.FINAL, Boolean.parseBoolean(f.getElementValue("//m:triple-index")));
            installInfo.setCollectionLexiconOn(DatabaseKind.FINAL, Boolean.parseBoolean(f.getElementValue("//m:collection-lexicon")));
            installInfo.setForestsExistent(DatabaseKind.FINAL, !f.getElements("//m:forest").isEmpty());
        }
        if (installInfo.isDbExistent(DatabaseKind.JOB)) {
            f = this.getDatabaseManager().getPropertiesAsXml(this.hubConfig.getDbName(DatabaseKind.JOB), new String[0]);
            installInfo.setForestsExistent(DatabaseKind.JOB, !f.getElements("//m:forest").isEmpty());
        }
        this.logger.info(installInfo.toString());
        return installInfo;
    }

    private static InstallInfo assumedProvisionedInstallInfo(InstallInfo installInfo) {
        installInfo.setAppServerExistent(DatabaseKind.STAGING, true);
        installInfo.setAppServerExistent(DatabaseKind.FINAL, true);
        installInfo.setAppServerExistent(DatabaseKind.JOB, true);
        installInfo.setDbExistent(DatabaseKind.STAGING, true);
        installInfo.setDbExistent(DatabaseKind.FINAL, true);
        installInfo.setDbExistent(DatabaseKind.JOB, true);
        installInfo.setDbExistent(DatabaseKind.MODULES, true);
        installInfo.setDbExistent(DatabaseKind.STAGING_SCHEMAS, true);
        installInfo.setDbExistent(DatabaseKind.STAGING_TRIGGERS, true);
        installInfo.setTripleIndexOn(DatabaseKind.STAGING, true);
        installInfo.setCollectionLexiconOn(DatabaseKind.STAGING, true);
        installInfo.setForestsExistent(DatabaseKind.STAGING, true);
        installInfo.setTripleIndexOn(DatabaseKind.FINAL, true);
        installInfo.setCollectionLexiconOn(DatabaseKind.FINAL, true);
        installInfo.setForestsExistent(DatabaseKind.FINAL, true);
        installInfo.setForestsExistent(DatabaseKind.JOB, true);
        return installInfo;
    }

    @Override
    public boolean isServerVersionValid(String versionString) {
        return new MarkLogicVersion(versionString).supportsDataHubFramework();
    }

    @Override
    public void initProject() {
        this.logger.info("Initializing the Hub Project");
        this.hubConfig.initHubProject();
    }

    @Override
    public void clearUserModules() {
        this.clearUserModules(null);
    }

    public void clearUserModules(List<String> resourceNamesToNotDelete) {
        long start = System.currentTimeMillis();
        this.logger.info("Clearing user modules");
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(DataHub.class.getClassLoader());
        try {
            HashSet<String> dataHubOptions = new HashSet<String>();
            for (Resource r : resolver.getResources("classpath*:/ml-modules/options/*.xml")) {
                dataHubOptions.add(xmlPattern.matcher(Objects.requireNonNull(r.getFilename())).replaceAll(""));
            }
            for (Resource r : resolver.getResources("classpath*:/ml-modules-final/options/*.xml")) {
                dataHubOptions.add(xmlPattern.matcher(Objects.requireNonNull(r.getFilename())).replaceAll(""));
            }
            for (Resource r : resolver.getResources("classpath*:/ml-modules-traces/options/*.xml")) {
                dataHubOptions.add(xmlPattern.matcher(Objects.requireNonNull(r.getFilename())).replaceAll(""));
            }
            for (Resource r : resolver.getResources("classpath*:/ml-modules-jobs/options/*.xml")) {
                dataHubOptions.add(xmlPattern.matcher(Objects.requireNonNull(r.getFilename())).replaceAll(""));
            }
            HashSet<String> dataHubServices = new HashSet<String>();
            for (Resource r : resolver.getResources("classpath*:/ml-modules/services/*")) {
                dataHubServices.add(modulePattern.matcher(Objects.requireNonNull(r.getFilename())).replaceAll(""));
            }
            HashSet<String> dataHubTransforms = new HashSet<String>();
            for (Resource r : resolver.getResources("classpath*:/ml-modules/transforms/*")) {
                dataHubTransforms.add(modulePattern.matcher(Objects.requireNonNull(r.getFilename())).replaceAll(""));
            }
            ServerConfigurationManager configMgr = this.hubConfig.newStagingClient().newServerConfigManager();
            QueryOptionsManager stagingOptionsManager = configMgr.newQueryOptionsManager();
            QueryOptionsListHandle handle = (QueryOptionsListHandle)stagingOptionsManager.optionsList((QueryOptionsListReadHandle)new QueryOptionsListHandle());
            HashMap optionsMap = handle.getValuesMap();
            optionsMap.keySet().forEach(optionsName -> {
                if (!dataHubOptions.contains(optionsName)) {
                    stagingOptionsManager.deleteOptions(optionsName);
                }
            });
            ServerConfigurationManager finalConfigMgr = this.hubConfig.newFinalClient().newServerConfigManager();
            QueryOptionsManager finalOptionsManager = finalConfigMgr.newQueryOptionsManager();
            QueryOptionsListHandle finalHandle = (QueryOptionsListHandle)finalOptionsManager.optionsList((QueryOptionsListReadHandle)new QueryOptionsListHandle());
            HashMap finalOptionsMap = finalHandle.getValuesMap();
            finalOptionsMap.keySet().forEach(optionsName -> {
                if (!dataHubOptions.contains(optionsName)) {
                    finalOptionsManager.deleteOptions(optionsName);
                }
            });
            TransformExtensionsManager transformExtensionsManager = configMgr.newTransformExtensionsManager();
            JsonNode transformsList = ((JacksonHandle)transformExtensionsManager.listTransforms((StructureReadHandle)new JacksonHandle(), false)).get();
            transformsList.findValuesAsText("name").forEach(x -> {
                if (!dataHubTransforms.contains(x) && !x.startsWith("ml")) {
                    transformExtensionsManager.deleteTransform(x);
                }
            });
            ResourceExtensionsManager resourceExtensionsManager = configMgr.newResourceExtensionsManager();
            JsonNode resourceExtensions = ((JacksonHandle)resourceExtensionsManager.listServices((StructureReadHandle)new JacksonHandle(), false)).get();
            if (resourceNamesToNotDelete == null) {
                resourceNamesToNotDelete = new ArrayList<String>();
            }
            for (String resourceName : resourceExtensions.findValuesAsText("name")) {
                if (dataHubServices.contains(resourceName) || resourceName.startsWith("ml") || resourceNamesToNotDelete.contains(resourceName)) continue;
                resourceExtensionsManager.deleteServices(resourceName);
            }
            String query = "cts:uris((),(),cts:not-query(cts:collection-query('hub-core-module')))[\n  fn:not(\n    fn:matches(., \"^.+options/(" + String.join((CharSequence)"|", dataHubOptions) + ").xml$\") or\n    fn:starts-with(., '/marklogic.rest.') or\n    fn:starts-with(., '/data-hub/5/mapping-functions/')\n  )\n] ! xdmp:document-delete(.)\n";
            this.runInDatabase(query, this.hubConfig.getDbName(DatabaseKind.MODULES));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to clear user modules, cause: " + e.getMessage(), e);
        }
        this.logger.info("Finished clearing user modules; time elapsed: " + (System.currentTimeMillis() - start));
    }

    public void clearUserArtifacts() {
        HubClient hubClientToUse = this.hubClient != null ? this.hubClient : this.hubConfig.newHubClient();
        long start = System.currentTimeMillis();
        this.logger.info("Clearing user artifacts as user: " + hubClientToUse.getUsername());
        ArtifactService.on(hubClientToUse.getStagingClient()).clearUserArtifacts();
        ArtifactService.on(hubClientToUse.getFinalClient()).clearUserArtifacts();
        this.logger.info("Finished clearing user artifacts; time elapsed: " + (System.currentTimeMillis() - start));
    }

    public List<Command> buildListOfCommands() {
        Map<String, List<Command>> commandMap = this.buildCommandMap();
        ArrayList<Command> commands = new ArrayList<Command>();
        for (Map.Entry<String, List<Command>> entry : commandMap.entrySet()) {
            commands.addAll((Collection<Command>)entry.getValue());
        }
        return commands;
    }

    public List<Command> getSecurityCommandList() {
        Map<String, List<Command>> commandMap = this.getSecurityCommands();
        ArrayList<Command> commands = new ArrayList<Command>();
        for (Map.Entry<String, List<Command>> entry : commandMap.entrySet()) {
            commands.addAll((Collection<Command>)entry.getValue());
        }
        return commands;
    }

    @Override
    public Map<String, Object> runPreInstallCheck() {
        return this.runPreInstallCheck(DataHubImpl.constructServerManager(this.hubConfig));
    }

    protected Map<String, Object> runPreInstallCheck(ServerManager serverManager) {
        Map<Integer, String> portsInUse;
        try {
            portsInUse = DataHubImpl.getServerPortsInUse(serverManager);
        }
        catch (HttpClientErrorException e) {
            this.logger.warn("Used non-existing user to verify data hub.  Usually this means a fresh system, ready to install.");
            return this.getResponseMap(true, true);
        }
        Set<Integer> ports = portsInUse.keySet();
        String serverName = portsInUse.get(this.hubConfig.getPort(DatabaseKind.STAGING));
        boolean bl = this.stagingPortInUse = ports.contains(this.hubConfig.getPort(DatabaseKind.STAGING)) && serverName != null && !serverName.equals(this.hubConfig.getHttpName(DatabaseKind.STAGING));
        if (this.stagingPortInUse) {
            this.stagingPortInUseBy = serverName;
        }
        serverName = portsInUse.get(this.hubConfig.getPort(DatabaseKind.FINAL));
        boolean bl2 = this.finalPortInUse = ports.contains(this.hubConfig.getPort(DatabaseKind.FINAL)) && serverName != null && !serverName.equals(this.hubConfig.getHttpName(DatabaseKind.FINAL));
        if (this.finalPortInUse) {
            this.finalPortInUseBy = serverName;
        }
        serverName = portsInUse.get(this.hubConfig.getPort(DatabaseKind.JOB));
        boolean bl3 = this.jobPortInUse = ports.contains(this.hubConfig.getPort(DatabaseKind.JOB)) && serverName != null && !serverName.equalsIgnoreCase(this.hubConfig.getHttpName(DatabaseKind.JOB));
        if (this.jobPortInUse) {
            this.jobPortInUseBy = serverName;
        }
        this.serverVersion = new MarkLogicVersion(this.hubConfig.getManageClient()).getVersionString();
        this.serverVersionOk = this.isServerVersionValid(this.serverVersion);
        return this.getResponseMap(this.serverVersionOk, this.isSafeToInstall());
    }

    @NotNull
    private Map<String, Object> getResponseMap(boolean serverVersionOk, boolean SafeToInstall) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("serverVersion", this.serverVersion);
        response.put("serverVersionOk", Optional.of(serverVersionOk));
        response.put("stagingPortInUse", Optional.of(this.stagingPortInUse));
        response.put("stagingPortInUseBy", this.stagingPortInUseBy);
        response.put("finalPortInUse", Optional.of(this.finalPortInUse));
        response.put("finalPortInUseBy", this.finalPortInUseBy);
        response.put("jobPortInUse", Optional.of(this.jobPortInUse));
        response.put("jobPortInUseBy", this.jobPortInUseBy);
        response.put("safeToInstall", Optional.of(SafeToInstall));
        return response;
    }

    @Override
    public void install() {
        if (!this.hubConfig.getHubProject().isInitialized()) {
            this.initProject();
        }
        this.logger.warn("Installing the Data Hub into MarkLogic");
        AppConfig appConfig = this.hubConfig.getAppConfig();
        DataHubImpl.disableSomeCmaUsage(appConfig);
        appConfig.setModulesLoaderBatchSize(Integer.valueOf(1));
        try {
            SimpleAppDeployer roleDeployer = new SimpleAppDeployer(this.hubConfig.getManageClient(), this.hubConfig.getAdminManager(), new Command[0]);
            roleDeployer.setCommands(this.getSecurityCommandList());
            roleDeployer.deploy(appConfig);
        }
        catch (HttpServerErrorException e) {
            if (e.getStatusCode() == HttpStatus.SERVICE_UNAVAILABLE) {
                this.logger.warn("No manage client for security installs.  Assuming DHS provisioning already there");
            }
            throw new DataHubConfigurationException(e);
        }
        SimpleAppDeployer deployer = new SimpleAppDeployer(this.hubConfig.getManageClient(), this.hubConfig.getAdminManager(), new Command[0]);
        deployer.setCommands(this.buildListOfCommands());
        deployer.deploy(appConfig);
    }

    protected static void disableSomeCmaUsage(AppConfig appConfig) {
        appConfig.getCmaConfig().setCombineRequests(false);
        appConfig.getCmaConfig().setDeployDatabases(false);
        appConfig.getCmaConfig().setDeployRoles(false);
        appConfig.getCmaConfig().setDeployUsers(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIndexes() {
        AppConfig appConfig = this.hubConfig.getAppConfig();
        new SimpleAppDeployer(this.getManageClient(), this.getAdminManager(), new Command[]{new DeployProtectedPathsCommand()}).deploy(appConfig);
        SimpleAppDeployer deployer = new SimpleAppDeployer(this.getManageClient(), this.getAdminManager(), new Command[0]);
        Map<String, List<Command>> commandMap = this.buildCommandMap();
        ArrayList indexRelatedCommands = new ArrayList(commandMap.get("mlDatabaseCommands"));
        deployer.setCommands(indexRelatedCommands);
        boolean originalCreateForests = appConfig.isCreateForests();
        Pattern originalIncludePattern = appConfig.getResourceFilenamesIncludePattern();
        try {
            appConfig.setCreateForests(false);
            if (this.hubConfig.getIsProvisionedEnvironment().booleanValue()) {
                appConfig.setResourceFilenamesIncludePattern(DataHubImpl.buildPatternForDatabasesToUpdateIndexesFor());
            }
            deployer.deploy(appConfig);
        }
        finally {
            appConfig.setCreateForests(originalCreateForests);
            appConfig.setResourceFilenamesIncludePattern(originalIncludePattern);
        }
    }

    protected static Pattern buildPatternForDatabasesToUpdateIndexesFor() {
        return Pattern.compile("(staging|final|job)-database.json");
    }

    private void runInDatabase(String query, String databaseName) {
        ServerEvaluationCall eval = this.hubConfig.newModulesDbClient().newServerEval();
        String xqy = "xdmp:invoke-function(function() {" + query + "},<options xmlns=\"xdmp:eval\">  <database>{xdmp:database(\"" + databaseName + "\")}</database>  <transaction-mode>update-auto-commit</transaction-mode></options>)";
        eval.xquery(xqy).eval().close();
    }

    public List<Command> buildCommandsForDeployingToReplica() {
        Map commandMap = new CommandMapBuilder().buildCommandMapForReplicaCluster();
        this.applyDataHubChangesToCommands(commandMap, true);
        return commandMap.values().stream().reduce(new ArrayList(), (a, b) -> {
            a.addAll(b);
            return a;
        });
    }

    public Map<String, List<Command>> buildCommandMap() {
        Map commandMap = new CommandMapBuilder().buildCommandMap();
        this.applyDataHubChangesToCommands(commandMap, false);
        return commandMap;
    }

    private void applyDataHubChangesToCommands(Map<String, List<Command>> commandMap, boolean isDeployingToReplica) {
        DataHubImpl.updateSecurityCommandList(commandMap);
        this.updateDatabaseCommandList(commandMap);
        this.updateServerCommandList(commandMap);
        commandMap.remove("mlRestApiCommands");
        List<Command> forestCommands = commandMap.get("mlForestCommands");
        DeployCustomForestsCommand deployCustomForestsCommand = (DeployCustomForestsCommand)forestCommands.get(0);
        deployCustomForestsCommand.setCustomForestsPath(this.hubConfig.getCustomForestPath());
        ArrayList<CreateGranularPrivilegesCommand> granularPrivilegeCommands = new ArrayList<CreateGranularPrivilegesCommand>();
        granularPrivilegeCommands.add(new CreateGranularPrivilegesCommand(this.hubConfig));
        commandMap.put("hubGranularPrivilegeCommands", granularPrivilegeCommands);
        if (!isDeployingToReplica) {
            this.updateTriggersCommandList(commandMap);
            this.updateModuleCommandList(commandMap);
            ArrayList<FinishHubDeploymentCommand> finishHubDeploymentCommands = new ArrayList<FinishHubDeploymentCommand>();
            finishHubDeploymentCommands.add(new FinishHubDeploymentCommand(this.hubConfig));
            commandMap.put("finishHubDeploymentCommands", finishHubDeploymentCommands);
        }
    }

    private static void updateSecurityCommandList(Map<String, List<Command>> commandMap) {
        for (Command c : commandMap.get("mlSecurityCommands")) {
            if (!(c instanceof DeployAmpsCommand)) continue;
            ((DeployAmpsCommand)c).setExecuteSortOrder(new LoadHubModulesCommand().getExecuteSortOrder() - 1);
        }
    }

    private void updateDatabaseCommandList(Map<String, List<Command>> commandMap) {
        ArrayList<Command> dbCommands = new ArrayList<Command>();
        for (Command c : commandMap.get("mlDatabaseCommands")) {
            dbCommands.add(c);
            if (!(c instanceof DeployOtherDatabasesCommand)) continue;
            ((DeployOtherDatabasesCommand)c).setDeployDatabaseCommandFactory((DeployDatabaseCommandFactory)new HubDeployDatabaseCommandFactory(this.hubConfig));
        }
        commandMap.put("mlDatabaseCommands", dbCommands);
    }

    private void updateServerCommandList(Map<String, List<Command>> commandMap) {
        String key = "mlServerCommands";
        ArrayList<Object> newCommands = new ArrayList<Object>();
        for (Command c : commandMap.get("mlServerCommands")) {
            if (c instanceof UpdateRestApiServersCommand || c instanceof DeployOtherServersCommand) continue;
            newCommands.add(c);
        }
        newCommands.add((Object)new DeployHubAppServersCommand(this.hubConfig));
        if (StringUtils.equals((CharSequence)((HubConfigImpl)this.hubConfig).getMlAuthentication(), (CharSequence)"cloud")) {
            newCommands.add((Object)new ConfigureAppServerBasePaths(this.hubConfig));
        }
        commandMap.put("mlServerCommands", newCommands);
    }

    private void updateTriggersCommandList(Map<String, List<Command>> commandMap) {
        List<Command> commands = commandMap.get("mlTriggerCommands");
        commands.add((Command)new RemoveOldTriggersCommand(this.hubConfig, this.hubConfig.getStagingTriggersDbName()));
        commands.add((Command)new DeployHubTriggersCommand(this.hubConfig.getStagingTriggersDbName()));
    }

    private void updateModuleCommandList(Map<String, List<Command>> commandsMap) {
        ArrayList<Object> commands = new ArrayList<Object>();
        commands.add((Object)this.loadHubModulesCommand);
        commands.add((Object)this.loadUserModulesCommand);
        commands.add((Object)this.loadUserArtifactsCommand);
        commands.add((Object)this.loadHubArtifactsCommand);
        commands.add((Object)this.generateFunctionMetadataCommand);
        for (Command c : commandsMap.get("mlModuleCommands")) {
            if (c instanceof LoadModulesCommand) continue;
            if (c instanceof DeleteTestModulesCommand) {
                ((DeleteTestModulesCommand)c).setExecuteSortOrder(this.loadUserModulesCommand.getExecuteSortOrder() + 1);
            }
            commands.add(c);
        }
        commandsMap.put("mlModuleCommands", commands);
    }

    private static Map<Integer, String> getServerPortsInUse(ServerManager serverManager) {
        HashMap<Integer, String> portsInUse = new HashMap<Integer, String>();
        ResourcesFragment srf = serverManager.getAsXml();
        srf.getListItemNameRefs().forEach(s -> {
            Fragment fragment = serverManager.getPropertiesAsXml(s, new String[0]);
            int port = Integer.parseInt(fragment.getElementValue("//m:port"));
            portsInUse.put(port, (String)s);
        });
        return portsInUse;
    }

    private Map<String, List<Command>> getSecurityCommands() {
        HashMap<String, List<Command>> commandMap = new HashMap<String, List<Command>>();
        ArrayList<Object> securityCommands = new ArrayList<Object>();
        securityCommands.add(new DeployRolesCommand());
        securityCommands.add(new DeployUsersCommand());
        securityCommands.add(new DeployCertificateTemplatesCommand());
        securityCommands.add(new DeployCertificateAuthoritiesCommand());
        securityCommands.add(new InsertCertificateHostsTemplateCommand());
        securityCommands.add(new DeployExternalSecurityCommand());
        securityCommands.add(new DeployPrivilegesCommand());
        securityCommands.add(new DeployProtectedCollectionsCommand());
        securityCommands.add(new DeployProtectedPathsCommand());
        securityCommands.add(new DeployQueryRolesetsCommand());
        commandMap.put("mlSecurityCommands", securityCommands);
        return commandMap;
    }

    @Override
    public boolean isSafeToInstall() {
        return !this.isPortInUse(DatabaseKind.FINAL) && !this.isPortInUse(DatabaseKind.STAGING) && !this.isPortInUse(DatabaseKind.JOB) && this.isServerVersionOk();
    }

    @Override
    public boolean isPortInUse(DatabaseKind kind) {
        boolean inUse;
        switch (kind) {
            case STAGING: {
                inUse = this.stagingPortInUse;
                break;
            }
            case FINAL: {
                inUse = this.finalPortInUse;
                break;
            }
            case JOB: {
                inUse = this.jobPortInUse;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "check for port use");
            }
        }
        return inUse;
    }

    @Override
    public String getPortInUseBy(DatabaseKind kind) {
        String inUseBy;
        switch (kind) {
            case STAGING: {
                inUseBy = this.stagingPortInUseBy;
                break;
            }
            case FINAL: {
                inUseBy = this.finalPortInUseBy;
                break;
            }
            case JOB: {
                inUseBy = this.jobPortInUseBy;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "check if port is in use");
            }
        }
        return inUseBy;
    }

    @Override
    public boolean isServerVersionOk() {
        return this.serverVersionOk;
    }

    @Override
    public String getServerVersion() {
        if (this.serverVersion == null) {
            this.serverVersion = new MarkLogicVersion(this.hubConfig.getManageClient()).getVersionString();
        }
        return this.serverVersion;
    }

    @Override
    public boolean upgradeHub() {
        boolean isHubInstalled;
        try {
            isHubInstalled = this.isInstalled().isInstalled();
        }
        catch (ResourceAccessException e) {
            isHubInstalled = false;
        }
        if (isHubInstalled) {
            String minUpgradeVersion = "4.3.0";
            String installedVersion = this.versions.getInstalledVersion();
            this.logger.warn("Currently installed DHF version: " + installedVersion);
            if (Versions.compare(installedVersion, "4.3.0") == -1) {
                throw new RuntimeException("Cannot upgrade installed Data Hub; its version is " + installedVersion + ", and must be at least version " + "4.3.0" + " or higher");
            }
        }
        this.verifyLocalProjectIs430OrGreater();
        boolean result = false;
        try {
            if (this.hubConfig.getHubProject().isInitialized()) {
                this.prepareProjectBeforeUpgrading(this.hubConfig.getHubProject(), this.hubConfig.getJarVersion());
                this.hubConfig.getHubSecurityDir().resolve("roles").resolve("flow-operator.json").toFile().delete();
            }
            this.hubConfig.initHubProject();
            this.hubConfig.getHubProject().upgradeProject(this.flowManager);
            System.out.println("Starting in version 5.2.0, the default value of mlModulePermissions has been changed to \"data-hub-module-reader,read,data-hub-module-reader,execute,data-hub-module-writer,update,rest-extension-user,execute\". It is recommended to remove this property from gradle.properties unless you must customize the value.");
            result = true;
        }
        catch (IOException e) {
            this.logger.error("Unable to upgrade project, cause: " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected void verifyLocalProjectIs430OrGreater() {
        File triggersDir = this.hubConfig.getHubProject().getHubTriggersDir().toFile();
        if (!triggersDir.exists()) {
            return;
        }
        File triggerFile = new File(triggersDir, "ml-dh-entity-create.json");
        boolean canBeUpgraded = true;
        try {
            JsonNode trigger = new ObjectMapper().readTree(triggerFile);
            String roleName = trigger.get("permission").get(0).get("role-name").asText();
            if ("%%mlHubAdminRole%%".equals(roleName) || "%%mlHubUserRole%%".equals(roleName)) {
                canBeUpgraded = false;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to upgrade project; while trying to verify that the local project is of version 4.3.0 or greater, was unable to read JSON from ml-dh-entity-create.json file; cause: " + ex.getMessage(), ex);
        }
        if (!canBeUpgraded) {
            throw new RuntimeException("Unable to upgrade current project, as its version is less than 4.3.0. Please first upgrade this project to 4.3.0. Consult the Data Hub documentation on performing this upgrade.");
        }
    }

    protected void prepareProjectBeforeUpgrading(HubProject hubProject, String newDataHubVersion) throws IOException {
        String backupPath = "src/main/hub-internal-config-pre-" + newDataHubVersion;
        FileUtils.moveDirectory((File)hubProject.getHubConfigDir().toFile(), (File)hubProject.getProjectDir().resolve(backupPath).toFile());
        this.logger.warn("The src/main/hub-internal-config directory has been moved to " + backupPath + " so that it can be re-initialized using the new version of Data Hub");
    }

    public void setHubConfig(HubConfigImpl hubConfig) {
        this.hubConfig = hubConfig;
        if (this.loadUserModulesCommand != null) {
            this.loadUserModulesCommand.setHubConfig(hubConfig);
        }
        if (this.loadHubModulesCommand != null) {
            this.loadHubModulesCommand.setHubConfig(hubConfig);
        }
        if (this.loadHubArtifactsCommand != null) {
            this.loadHubArtifactsCommand.setHubConfig(hubConfig);
        }
        if (this.loadUserArtifactsCommand != null) {
            this.loadUserArtifactsCommand.setHubConfig(hubConfig);
        }
        if (this.generateFunctionMetadataCommand != null) {
            this.generateFunctionMetadataCommand.setHubConfig(hubConfig);
        }
    }

    public HubConfig getHubConfig() {
        return this.hubConfig;
    }

    public void setVersions(Versions versions) {
        this.versions = versions;
    }

    public void clearUserData() {
        this.clearUserData(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUserData(String targetDatabase, String sourceCollection) {
        HubClient hubClientToUse = this.hubClient != null ? this.hubClient : this.hubConfig.newHubClient();
        long start = System.currentTimeMillis();
        this.logger.info("Clearing user data as user: " + hubClientToUse.getUsername());
        List<DocumentWriteOperation> userAndHubArtifacts = DataHubImpl.readUserAndHubArtifacts(hubClientToUse);
        this.logger.info("Count of user and hub artifacts read into memory: " + userAndHubArtifacts.size());
        DatabaseManager databaseManager = new DatabaseManager(hubClientToUse.getManageClient());
        if (StringUtils.isEmpty((CharSequence)targetDatabase)) {
            this.clearDatabase(databaseManager, hubClientToUse.getDbName(DatabaseKind.JOB));
        }
        String stagingDbName = hubClientToUse.getDbName(DatabaseKind.STAGING);
        if (StringUtils.isEmpty((CharSequence)targetDatabase) || targetDatabase.equals(stagingDbName)) {
            try {
                if (StringUtils.isEmpty((CharSequence)sourceCollection)) {
                    this.clearDatabase(databaseManager, stagingDbName);
                } else {
                    DataHubImpl.clearDatabaseCollection(sourceCollection, hubClientToUse.getStagingClient());
                }
            }
            finally {
                this.writeUserAndHubArtifacts(hubClientToUse.getStagingClient().newJSONDocumentManager(), userAndHubArtifacts, stagingDbName);
            }
        }
        String finalDbName = hubClientToUse.getDbName(DatabaseKind.FINAL);
        if (StringUtils.isEmpty((CharSequence)targetDatabase) || targetDatabase.equals(finalDbName)) {
            try {
                if (StringUtils.isEmpty((CharSequence)sourceCollection)) {
                    this.clearDatabase(databaseManager, finalDbName);
                } else {
                    DataHubImpl.clearDatabaseCollection(sourceCollection, hubClientToUse.getFinalClient());
                }
            }
            finally {
                this.writeUserAndHubArtifacts(hubClientToUse.getFinalClient().newJSONDocumentManager(), userAndHubArtifacts, finalDbName);
            }
        }
        this.logger.info("Finished clearing user data; time elapsed: " + (System.currentTimeMillis() - start));
    }

    private static void clearDatabaseCollection(String sourceName, DatabaseClient databaseClientToUse) {
        QueryManager qm = databaseClientToUse.newQueryManager();
        DeleteQueryDefinition def = qm.newDeleteDefinition();
        def.setCollections(new String[]{sourceName});
        qm.delete(def);
    }

    private void clearDatabase(DatabaseManager databaseManager, String databaseName) {
        long start = System.currentTimeMillis();
        this.logger.info("Clearing database: " + databaseName);
        boolean catchException = false;
        databaseManager.clearDatabase(databaseName, false);
        this.logger.info("Finished clearing database: " + databaseName + "; time elapsed: " + (System.currentTimeMillis() - start));
    }

    public void clearUserSchemas() {
        HubClient hubClientToUse = this.hubClient != null ? this.hubClient : this.hubConfig.newHubClient();
        long start = System.currentTimeMillis();
        this.logger.info("Clearing user schemas as user: " + hubClientToUse.getUsername());
        String xquery = "cts:not-query(cts:collection-query(('http://marklogic.com/xdmp/temporal/axis', 'http://marklogic.com/xdmp/temporal/collection', 'http://marklogic.com/xdmp/view')))";
        String fullQuery = "cts:uris((), (), " + xquery + ") ! xdmp:document-delete(.)";
        DatabaseClient stagingSchemasClient = this.hubConfig.newStagingClient(this.hubConfig.getDbName(DatabaseKind.STAGING_SCHEMAS));
        DatabaseClient finalSchemasClient = this.hubConfig.newFinalClient(this.hubConfig.getDbName(DatabaseKind.FINAL_SCHEMAS));
        Stream.of(stagingSchemasClient, finalSchemasClient).forEach(databaseClient -> {
            try {
                this.logger.info("Deleting user schemas in database '" + databaseClient.getDatabase() + "' via : " + fullQuery);
                databaseClient.newServerEval().xquery(fullQuery).eval().close();
            }
            finally {
                databaseClient.release();
            }
        });
        this.logger.info("Finished clearing user schemas; time elapsed: " + (System.currentTimeMillis() - start));
    }

    private static List<DocumentWriteOperation> readUserAndHubArtifacts(HubClient hubClientToUse) {
        ArrayList<DocumentWriteOperation> docs = new ArrayList<DocumentWriteOperation>();
        JSONDocumentManager mgr = hubClientToUse.getStagingClient().newJSONDocumentManager();
        String script = "import consts from '/data-hub/5/impl/consts.mjs';\ncts.uris(null, null,    cts.collectionQuery(consts.USER_ARTIFACT_COLLECTIONS.concat(consts.HUB_ARTIFACT_COLLECTION).concat('http://marklogic.com/data-hub/mappings')))";
        EvalResultIterator resultIterator = hubClientToUse.getStagingClient().newServerEval().javascript("import consts from '/data-hub/5/impl/consts.mjs';\ncts.uris(null, null,    cts.collectionQuery(consts.USER_ARTIFACT_COLLECTIONS.concat(consts.HUB_ARTIFACT_COLLECTION).concat('http://marklogic.com/data-hub/mappings')))").eval();
        resultIterator.iterator().forEachRemaining(item -> {
            String uri = item.getString();
            DocumentMetadataHandle metadata = new DocumentMetadataHandle();
            JacksonHandle content = new JacksonHandle();
            mgr.read(uri, (DocumentMetadataReadHandle)metadata, (AbstractReadHandle)content);
            docs.add((DocumentWriteOperation)new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, uri, (DocumentMetadataWriteHandle)metadata, (AbstractWriteHandle)content));
        });
        resultIterator.close();
        return docs;
    }

    private void writeUserAndHubArtifacts(JSONDocumentManager mgr, List<DocumentWriteOperation> userAndHubArtifacts, String databaseName) {
        DocumentWriteSet writeSet = mgr.newWriteSet();
        writeSet.addAll(userAndHubArtifacts);
        this.logger.info("Writing user and hub artifacts to " + databaseName + "; count: " + writeSet.size());
        mgr.write(writeSet);
        this.logger.info("Finished writing user and hub artifacts to " + databaseName);
    }
}

