/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.flow;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FlowInputs {
    private String flowName;
    private List<String> steps;
    private String jobId;
    private Map<String, Object> options;
    private Map<String, Object> stepConfig;

    public FlowInputs() {
    }

    public FlowInputs(String flowName) {
        this.flowName = flowName;
    }

    public FlowInputs(String flowName, String ... steps) {
        this.flowName = flowName;
        this.steps = Arrays.asList(steps);
    }

    public void setInputFilePath(String inputFilePath) {
        HashMap<String, String> fileLocations;
        if (this.stepConfig == null) {
            this.stepConfig = new HashMap<String, Object>();
        }
        if ((fileLocations = (HashMap<String, String>)this.stepConfig.get("fileLocations")) == null) {
            fileLocations = new HashMap<String, String>();
            this.stepConfig.put("fileLocations", fileLocations);
        }
        fileLocations.put("inputFilePath", inputFilePath);
    }

    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public List<String> getSteps() {
        return this.steps;
    }

    public void setSteps(List<String> steps) {
        this.steps = steps;
    }

    public FlowInputs withSteps(String ... steps) {
        this.setSteps(Arrays.asList(steps));
        return this;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public FlowInputs withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public FlowInputs withOption(String name, Object value) {
        if (this.options == null) {
            this.options = new HashMap<String, Object>();
        }
        this.options.put(name, value);
        return this;
    }

    public FlowInputs withOptions(Map<String, Object> options) {
        this.setOptions(options);
        return this;
    }

    public Map<String, Object> getStepConfig() {
        return this.stepConfig;
    }

    public void setStepConfig(Map<String, Object> stepConfig) {
        this.stepConfig = stepConfig;
    }

    public FlowInputs withStepConfig(Map<String, Object> stepConfig) {
        this.setStepConfig(stepConfig);
        return this;
    }
}

