/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.entity;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.hub.entity.JsonPojo;
import com.marklogic.hub.entity.PropertyType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefinitionType
extends JsonPojo {
    protected String name;
    protected String description;
    protected String primaryKey;
    protected String namespace;
    protected String namespacePrefix;
    protected List<String> required;
    protected List<String> pii;
    protected List<String> elementRangeIndex;
    protected List<String> rangeIndex;
    protected List<String> wordLexicon;
    protected List<PropertyType> properties;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public List<String> getRequired() {
        return this.required;
    }

    public void setRequired(List<String> required) {
        this.required = required;
    }

    public List<String> getPii() {
        return this.pii;
    }

    public void setPii(List<String> pii) {
        this.pii = pii;
    }

    public List<String> getRangeIndex() {
        return this.rangeIndex;
    }

    public void setRangeIndex(List<String> rangeIndex) {
        this.rangeIndex = rangeIndex;
    }

    public List<String> getElementRangeIndex() {
        return this.elementRangeIndex;
    }

    public void setElementRangeIndex(List<String> elementRangeIndex) {
        this.elementRangeIndex = elementRangeIndex;
    }

    public List<String> getWordLexicon() {
        return this.wordLexicon;
    }

    public void setWordLexicon(List<String> wordLexicon) {
        this.wordLexicon = wordLexicon;
    }

    public List<PropertyType> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyType> properties) {
        this.properties = properties;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void setNamespacePrefix(String namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    public static DefinitionType fromJson(String name, JsonNode node) {
        DefinitionType definitionType = new DefinitionType();
        definitionType.setName(name);
        definitionType.setDescription(DefinitionType.getValue(node, "description"));
        definitionType.setPrimaryKey(DefinitionType.getValue(node, "primaryKey"));
        definitionType.setNamespace(DefinitionType.getValue(node, "namespace"));
        definitionType.setNamespacePrefix(DefinitionType.getValue(node, "namespacePrefix"));
        ArrayList<String> required = new ArrayList<String>();
        JsonNode requiredNodes = node.get("required");
        if (requiredNodes != null) {
            for (JsonNode n : requiredNodes) {
                required.add(n.asText());
            }
        }
        definitionType.setRequired(required);
        ArrayList<String> pii = new ArrayList<String>();
        JsonNode piiNodes = node.get("pii");
        if (piiNodes != null) {
            for (JsonNode n : piiNodes) {
                pii.add(n.asText());
            }
        }
        definitionType.setPii(pii);
        ArrayList<String> elementRangeIndexes = new ArrayList<String>();
        JsonNode elementRangeIndexNodes = node.get("elementRangeIndex");
        if (elementRangeIndexNodes != null) {
            for (JsonNode n : elementRangeIndexNodes) {
                elementRangeIndexes.add(n.asText());
            }
        }
        definitionType.setElementRangeIndex(elementRangeIndexes);
        ArrayList<String> rangeIndexes = new ArrayList<String>();
        JsonNode rangeIndexNodes = node.get("rangeIndex");
        if (rangeIndexNodes != null) {
            for (JsonNode n : rangeIndexNodes) {
                rangeIndexes.add(n.asText());
            }
        }
        definitionType.setRangeIndex(rangeIndexes);
        ArrayList<String> wordLexicons = new ArrayList<String>();
        JsonNode wordLexiconNodes = node.get("wordLexicon");
        if (wordLexiconNodes != null) {
            for (JsonNode n : wordLexiconNodes) {
                wordLexicons.add(n.asText());
            }
        }
        definitionType.setWordLexicon(wordLexicons);
        ArrayList<PropertyType> properties = new ArrayList<PropertyType>();
        JsonNode propertiesNode = node.get("properties");
        if (propertiesNode != null) {
            Iterator fieldItr = propertiesNode.fieldNames();
            while (fieldItr.hasNext()) {
                String key = (String)fieldItr.next();
                JsonNode propertyNode = propertiesNode.get(key);
                if (propertyNode == null) continue;
                properties.add(PropertyType.fromJson(key, propertyNode));
            }
        }
        definitionType.setProperties(properties);
        return definitionType;
    }

    @Override
    public JsonNode toJson() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        DefinitionType.writeStringIf(node, "description", this.description);
        DefinitionType.writeStringIf(node, "primaryKey", this.primaryKey);
        DefinitionType.writeStringIf(node, "namespace", this.namespace);
        DefinitionType.writeStringIf(node, "namespacePrefix", this.namespacePrefix);
        ArrayNode requiredArray = JsonNodeFactory.instance.arrayNode();
        if (this.required != null) {
            this.required.forEach(arg_0 -> ((ArrayNode)requiredArray).add(arg_0));
        }
        node.set("required", (JsonNode)requiredArray);
        ArrayNode piiArray = JsonNodeFactory.instance.arrayNode();
        if (this.pii != null) {
            this.pii.forEach(arg_0 -> ((ArrayNode)piiArray).add(arg_0));
        }
        node.set("pii", (JsonNode)piiArray);
        ArrayNode elementRangeIndexArray = JsonNodeFactory.instance.arrayNode();
        if (this.elementRangeIndex != null) {
            this.elementRangeIndex.forEach(arg_0 -> ((ArrayNode)elementRangeIndexArray).add(arg_0));
        }
        node.set("elementRangeIndex", (JsonNode)elementRangeIndexArray);
        ArrayNode rangeIndexArray = JsonNodeFactory.instance.arrayNode();
        if (this.rangeIndex != null) {
            this.rangeIndex.forEach(arg_0 -> ((ArrayNode)rangeIndexArray).add(arg_0));
        }
        node.set("rangeIndex", (JsonNode)rangeIndexArray);
        ArrayNode wordLexiconArray = JsonNodeFactory.instance.arrayNode();
        if (this.wordLexicon != null) {
            this.wordLexicon.forEach(arg_0 -> ((ArrayNode)wordLexiconArray).add(arg_0));
        }
        node.set("wordLexicon", (JsonNode)wordLexiconArray);
        ObjectNode propertiesObj = JsonNodeFactory.instance.objectNode();
        for (PropertyType prop : this.properties) {
            propertiesObj.set(prop.getName(), prop.toJson());
        }
        node.set("properties", (JsonNode)propertiesObj);
        return node;
    }
}

