/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.modules.LoadModulesCommand;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.file.CacheBusterDocumentFileProcessor;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.modulesloader.ModulesFinder;
import com.marklogic.client.ext.modulesloader.ModulesManager;
import com.marklogic.client.ext.modulesloader.impl.AssetFileLoader;
import com.marklogic.client.ext.modulesloader.impl.DefaultModulesLoader;
import com.marklogic.client.ext.modulesloader.impl.PropertiesModuleManager;
import com.marklogic.client.ext.modulesloader.impl.SearchOptionsFinder;
import com.marklogic.client.ext.modulesloader.impl.UserModulesFinder;
import com.marklogic.hub.EntityManager;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.deploy.util.HubFileFilter;
import com.marklogic.hub.impl.EntityManagerImpl;
import java.io.File;
import java.io.FileFilter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class LoadUserModulesCommand
extends LoadModulesCommand {
    private static final Pattern inputDirectoryPattern = Pattern.compile(".*[/\\\\]input[/\\\\].*");
    private static final Pattern harmonizeDirectoryPattern = Pattern.compile(".*[/\\\\]harmonize[/\\\\].*");
    private static final Pattern inputOrHarmonizePattern = Pattern.compile(".*[/\\\\](input|harmonize)[/\\\\][^/\\\\]+$");
    @Autowired
    private HubConfig hubConfig;
    @Autowired
    protected EntityManager entityManager;
    private boolean loadQueryOptions = true;
    private boolean loadAllModules = true;
    private boolean forceLoad = false;

    public void setForceLoad(boolean forceLoad) {
        this.forceLoad = forceLoad;
    }

    public LoadUserModulesCommand() {
        this.setExecuteSortOrder(460);
    }

    public LoadUserModulesCommand(HubConfig hubConfig) {
        this();
        this.hubConfig = hubConfig;
        this.entityManager = new EntityManagerImpl(hubConfig);
    }

    private PropertiesModuleManager getModulesManager() {
        String hubUserTimestampFilePath = this.hubConfig.getHubProject().getUserModulesDeployTimestampFile();
        String appConfigTimestampFilePath = this.hubConfig.getAppConfig().getModuleTimestampsPath();
        PropertiesModuleManager pmm = new PropertiesModuleManager(hubUserTimestampFilePath);
        this.logger.info("Initializing PropertiesModuleManager with properties timestamp file: {}", (Object)hubUserTimestampFilePath);
        if (this.forceLoad) {
            File defaultTimestampFile;
            this.logger.info("Deleting properties timestamp file as part of force load: {}", (Object)hubUserTimestampFilePath);
            pmm.deletePropertiesFile();
            if (appConfigTimestampFilePath != null && (defaultTimestampFile = new File(appConfigTimestampFilePath)).exists() && !defaultTimestampFile.delete()) {
                this.logger.info("Unable to delete module timestamp file: {}", (Object)defaultTimestampFile.getAbsolutePath());
            }
        }
        pmm.initialize();
        return pmm;
    }

    private AssetFileLoader getAssetFileLoader(AppConfig config, PropertiesModuleManager moduleManager) {
        AssetFileLoader assetFileLoader = new AssetFileLoader(this.hubConfig.newModulesDbClient(), (ModulesManager)moduleManager);
        assetFileLoader.addDocumentFileProcessor((DocumentFileProcessor)new CacheBusterDocumentFileProcessor());
        assetFileLoader.addFileFilter((FileFilter)new HubFileFilter());
        assetFileLoader.setPermissions(config.getModulePermissions());
        return assetFileLoader;
    }

    private DefaultModulesLoader getStagingModulesLoader(AppConfig config) {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(16);
        threadPoolTaskExecutor.setAwaitTerminationSeconds(600);
        threadPoolTaskExecutor.setWaitForTasksToCompleteOnShutdown(true);
        threadPoolTaskExecutor.afterPropertiesSet();
        PropertiesModuleManager moduleManager = this.getModulesManager();
        AssetFileLoader assetFileLoader = this.getAssetFileLoader(config, moduleManager);
        DefaultModulesLoader modulesLoader = new DefaultModulesLoader(assetFileLoader);
        modulesLoader.setModulesManager((ModulesManager)moduleManager);
        modulesLoader.setTaskExecutor((TaskExecutor)threadPoolTaskExecutor);
        modulesLoader.setShutdownTaskExecutorAfterLoadingModules(false);
        return modulesLoader;
    }

    static boolean isInputRestDir(Path dir) {
        return dir.endsWith("REST") && inputDirectoryPattern.matcher(dir.toString()).matches();
    }

    static boolean isHarmonizeRestDir(Path dir) {
        return dir.endsWith("REST") && harmonizeDirectoryPattern.matcher(dir.toString()).matches();
    }

    static boolean isFlowPropertiesFile(@NotNull Path dir) {
        Path parentFileName;
        Path dirFileName = dir.getFileName();
        Path parent = dir.getParent();
        Path path = parentFileName = parent != null ? parent.getFileName() : null;
        if (dirFileName == null || parentFileName == null) {
            return false;
        }
        String fileNameStr = dir.getFileName().toString();
        String parentFileNameStr = parentFileName.toString();
        String parentStr = parent.toString();
        return dir.toFile().isFile() && fileNameStr.endsWith(".properties") && inputOrHarmonizePattern.matcher(parentStr).matches() && fileNameStr.equals(parentFileNameStr + ".properties");
    }

    private void loadModulesFromStandardMlGradleLocations(CommandContext context) {
        super.execute(context);
    }

    public void execute(CommandContext context) {
        AppConfig config = context.getAppConfig();
        DatabaseClient stagingClient = this.hubConfig.newStagingClient();
        DatabaseClient finalClient = this.hubConfig.newFinalClient();
        Path userModulesPath = this.hubConfig.getHubPluginsDir();
        String baseDir = "";
        String encodedBaseDir = userModulesPath.normalize().toAbsolutePath().toString();
        try {
            baseDir = URLDecoder.decode(encodedBaseDir, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            this.logger.warn("Issue decoding directory path.", (Throwable)e);
        }
        DefaultModulesLoader modulesLoader = this.getStagingModulesLoader(config);
        if (this.loadAllModules) {
            this.loadModulesFromStandardMlGradleLocations(context);
        }
        modulesLoader.loadModules(baseDir, (ModulesFinder)new UserModulesFinder(), stagingClient);
        if (this.loadQueryOptions) {
            modulesLoader.loadModules("classpath*:/ml-modules-final", (ModulesFinder)new SearchOptionsFinder(), finalClient);
        }
        if (this.loadQueryOptions) {
            String gerProjectDir = this.hubConfig.getHubProject().getProjectDirString();
            String decodedFileName = null;
            try {
                decodedFileName = URLDecoder.decode(gerProjectDir, StandardCharsets.UTF_8.name());
            }
            catch (Exception e) {
                this.logger.warn("Issue decoding directory path.", (Throwable)e);
            }
            assert (decodedFileName != null);
            Path entityConfigDir = Paths.get(decodedFileName, "src/main/entity-config");
            if (!entityConfigDir.toFile().exists() && !entityConfigDir.toFile().mkdirs()) {
                this.logger.warn("Unable to create entity directory: {}", (Object)entityConfigDir.toAbsolutePath());
            }
            this.entityManager.deployQueryOptions();
        }
    }

    public void setHubConfig(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
        if (this.entityManager == null) {
            this.entityManager = new EntityManagerImpl(hubConfig);
        }
    }

    public void setLoadQueryOptions(boolean loadQueryOptions) {
        this.loadQueryOptions = loadQueryOptions;
    }

    public void setLoadAllModules(boolean loadAllModules) {
        this.loadAllModules = loadAllModules;
    }
}

