/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.command.AbstractUndoableCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.deploy.util.CloudUtil;
import com.marklogic.hub.impl.HubConfigImpl;

public class ConfigureAppServerBasePaths
extends AbstractUndoableCommand {
    private final HubConfigImpl hubConfig;
    private ObjectMapper mapper = new ObjectMapper();
    private CloudUtil cloudUtil;
    private static final String DATAHUB_CLOUD_SERVICE_ENDPOINT = "/api/service/dataHubEndpoints";

    public ConfigureAppServerBasePaths(HubConfig hubConfig) {
        this.hubConfig = (HubConfigImpl)hubConfig;
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_OTHER_SERVERS + 1);
        this.cloudUtil = new CloudUtil(this.hubConfig);
    }

    public void execute(CommandContext context) {
        this.updateAppServersBasePaths();
        this.cloudUtil.waitForGateWayToRestart();
    }

    public void undo(CommandContext context) {
        String[] adminBasePath = this.hubConfig.getAdminConfig().getBasePath().split("/");
        String env = adminBasePath[2];
        String mlDns = adminBasePath[3];
        this.cloudUtil.deleteRequest(DATAHUB_CLOUD_SERVICE_ENDPOINT.concat("/").concat(env).concat("/").concat(mlDns));
        this.cloudUtil.waitForGateWayToRestart();
    }

    private void updateAppServersBasePaths() {
        this.cloudUtil.jsonPostRequest(DATAHUB_CLOUD_SERVICE_ENDPOINT, this.getBasePathConfig());
    }

    private String getBasePathConfig() {
        ObjectNode baseConfig = this.mapper.createObjectNode();
        ObjectNode appServers = this.mapper.createObjectNode();
        ObjectNode jobServer = this.mapper.createObjectNode();
        ObjectNode stagingServer = this.mapper.createObjectNode();
        ObjectNode finalServer = this.mapper.createObjectNode();
        String[] stagingBasePathArray = this.hubConfig.getStagingBasePath().split("/");
        String stagingBasePath = stagingBasePathArray[stagingBasePathArray.length - 1];
        String[] finalBasePathArray = this.hubConfig.getFinalBasePath().split("/");
        String finalBasePath = finalBasePathArray[finalBasePathArray.length - 1];
        String[] jobBasePathArray = this.hubConfig.getJobBasePath().split("/");
        String jobBasePath = jobBasePathArray[jobBasePathArray.length - 1];
        baseConfig.put("adminPath", this.hubConfig.getAdminConfig().getBasePath());
        baseConfig.putIfAbsent("appServers", (JsonNode)appServers);
        appServers.putIfAbsent("staging", (JsonNode)stagingServer);
        appServers.putIfAbsent("final", (JsonNode)finalServer);
        appServers.putIfAbsent("jobs", (JsonNode)jobServer);
        stagingServer.put("name", this.hubConfig.getStagingDbName());
        stagingServer.put("path", stagingBasePath.concat("/"));
        finalServer.put("name", this.hubConfig.getFinalDbName());
        finalServer.put("path", finalBasePath.concat("/"));
        jobServer.put("name", this.hubConfig.getJobDbName());
        jobServer.put("path", jobBasePath.concat("/"));
        return baseConfig.toString();
    }
}

