/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.dataservices;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.SessionState;
import com.marklogic.client.impl.BaseProxy;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.InputStreamHandle;
import com.marklogic.client.io.marker.BufferableContentHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import java.io.InputStream;
import java.io.Reader;
import java.util.stream.Stream;

public interface StepRunnerService {
    public static StepRunnerService on(DatabaseClient db) {
        return StepRunnerService.on(db, null);
    }

    public static StepRunnerService on(DatabaseClient db, JSONWriteHandle serviceDeclaration) {
        final class StepRunnerServiceImpl
        implements StepRunnerService {
            private DatabaseClient dbClient;
            private BaseProxy baseProxy;
            private BaseProxy.DBFunctionRequest req_collector;
            private BaseProxy.DBFunctionRequest req_processIngestBatch;
            private BaseProxy.DBFunctionRequest req_processQueryBatch;
            private BaseProxy.DBFunctionRequest req_processBatch;

            StepRunnerServiceImpl(DatabaseClient dbClient, JSONWriteHandle servDecl) {
                this.dbClient = dbClient;
                this.baseProxy = new BaseProxy("/data-hub/data-services/stepRunner/", servDecl);
                this.req_collector = this.baseProxy.request("collector.mjs", BaseProxy.ParameterValuesKind.MULTIPLE_ATOMICS);
                this.req_processIngestBatch = this.baseProxy.request("processIngestBatch.mjs", BaseProxy.ParameterValuesKind.MULTIPLE_NODES);
                this.req_processQueryBatch = this.baseProxy.request("processQueryBatch.mjs", BaseProxy.ParameterValuesKind.MULTIPLE_NODES);
                this.req_processBatch = this.baseProxy.request("processBatch.mjs", BaseProxy.ParameterValuesKind.SINGLE_NODE);
            }

            @Override
            public SessionState newSessionState() {
                return this.baseProxy.newSessionState();
            }

            @Override
            public Stream<InputStreamHandle> collector(SessionState api_session, String flowName, String step, String options, String database) {
                return this.collector(this.req_collector.on(this.dbClient), api_session, flowName, step, options, database);
            }

            private Stream<InputStreamHandle> collector(BaseProxy.DBFunctionRequest request, SessionState api_session, String flowName, String step, String options, String database) {
                return request.withSession("api_session", api_session, false).withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"flowName", (boolean)false, (String)BaseProxy.StringType.fromString((String)flowName)), BaseProxy.atomicParam((String)"step", (boolean)false, (String)BaseProxy.StringType.fromString((String)step)), BaseProxy.atomicParam((String)"options", (boolean)true, (String)BaseProxy.StringType.fromString((String)options)), BaseProxy.atomicParam((String)"database", (boolean)false, (String)BaseProxy.StringType.fromString((String)database))}).responseMultiple(true, Format.UNKNOWN).asStreamOfHandles(null, (BufferableContentHandle)new InputStreamHandle());
            }

            @Override
            public JsonNode processIngestBatch(SessionState session, Stream<InputStream> input, Reader endpointState, Reader endpointConstants) {
                return this.processIngestBatch(this.req_processIngestBatch.on(this.dbClient), session, input, endpointState, endpointConstants);
            }

            private JsonNode processIngestBatch(BaseProxy.DBFunctionRequest request, SessionState session, Stream<InputStream> input, Reader endpointState, Reader endpointConstants) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withSession("session", session, true).withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"input", (boolean)true, (Stream)BaseProxy.BinaryDocumentType.fromInputStream(input)), BaseProxy.documentParam((String)"endpointState", (boolean)true, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromReader((Reader)endpointState)), BaseProxy.documentParam((String)"endpointConstants", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromReader((Reader)endpointConstants))}).responseSingle(true, Format.JSON));
            }

            @Override
            public JsonNode processQueryBatch(SessionState session, Reader endpointState, Reader endpointConstants) {
                return this.processQueryBatch(this.req_processQueryBatch.on(this.dbClient), session, endpointState, endpointConstants);
            }

            private JsonNode processQueryBatch(BaseProxy.DBFunctionRequest request, SessionState session, Reader endpointState, Reader endpointConstants) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withSession("session", session, true).withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"endpointState", (boolean)true, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromReader((Reader)endpointState)), BaseProxy.documentParam((String)"endpointConstants", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromReader((Reader)endpointConstants))}).responseSingle(true, Format.JSON));
            }

            @Override
            public JsonNode processBatch(SessionState api_session, JsonNode inputs) {
                return this.processBatch(this.req_processBatch.on(this.dbClient), api_session, inputs);
            }

            private JsonNode processBatch(BaseProxy.DBFunctionRequest request, SessionState api_session, JsonNode inputs) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withSession("api_session", api_session, false).withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"inputs", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)inputs))}).responseSingle(false, Format.JSON));
            }
        }
        return new StepRunnerServiceImpl(db, serviceDeclaration);
    }

    public SessionState newSessionState();

    public Stream<InputStreamHandle> collector(SessionState var1, String var2, String var3, String var4, String var5);

    public JsonNode processIngestBatch(SessionState var1, Stream<InputStream> var2, Reader var3, Reader var4);

    public JsonNode processQueryBatch(SessionState var1, Reader var2, Reader var3);

    public JsonNode processBatch(SessionState var1, JsonNode var2);
}

