/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.ext.ConfiguredDatabaseClientFactory;
import com.marklogic.client.ext.DatabaseClientConfig;
import com.marklogic.client.ext.DefaultConfiguredDatabaseClientFactory;
import com.marklogic.client.ext.SecurityContextType;
import com.marklogic.client.ext.modulesloader.ssl.SimpleX509TrustManager;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.mgmt.DefaultManageConfigFactory;
import com.marklogic.mgmt.ManageConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubClientConfig {
    private ConfiguredDatabaseClientFactory configuredDatabaseClientFactory = new DefaultConfiguredDatabaseClientFactory();
    private static final Logger logger = LoggerFactory.getLogger(HubClientConfig.class);
    private String host;
    private String username;
    private String password;
    private String cloudApiKey;
    private String mlAuthentication;
    private String stagingDbName;
    private Integer stagingPort;
    private String stagingBasePath;
    private String stagingAuthMethod;
    private Boolean stagingSimpleSsl;
    private SSLContext stagingSslContext;
    private DatabaseClientFactory.SSLHostnameVerifier stagingSslHostnameVerifier;
    private String stagingCertFile;
    private String stagingCertPassword;
    private String stagingExternalName;
    private X509TrustManager stagingTrustManager;
    private String finalDbName;
    private Integer finalPort;
    private String finalBasePath;
    private String finalAuthMethod;
    private Boolean finalSimpleSsl;
    private SSLContext finalSslContext;
    private DatabaseClientFactory.SSLHostnameVerifier finalSslHostnameVerifier;
    private String finalCertFile;
    private String finalCertPassword;
    private String finalExternalName;
    private X509TrustManager finalTrustManager;
    private String jobDbName;
    private Integer jobPort;
    private String jobBasePath;
    private String jobAuthMethod;
    private Boolean jobSimpleSsl;
    private SSLContext jobSslContext;
    private DatabaseClientFactory.SSLHostnameVerifier jobSslHostnameVerifier;
    private String jobCertFile;
    private String jobCertPassword;
    private String jobExternalName;
    private X509TrustManager jobTrustManager;
    private String modulesDbName;
    private String stagingTriggersDbName;
    private String finalTriggersDbName;
    private String stagingSchemasDbName;
    private String finalSchemasDbName;
    private Integer maxStringsInMemory;
    private String collectorTmpDir;
    private String modulePermissions;
    private Boolean isHostLoadBalancer;
    private Boolean supportMlColonPrefix;
    private ManageConfig manageConfig;
    private Map<String, Consumer<String>> propertyConsumerMap;

    public HubClientConfig() {
        this.applyDefaultPropertyValues();
    }

    public HubClientConfig(String host, String username, String password) {
        this();
        Properties props = new Properties();
        if (host != null) {
            props.setProperty("mlHost", host);
        }
        props.setProperty("mlUsername", username);
        props.setProperty("mlPassword", password);
        this.applyProperties(props);
    }

    public HubClientConfig(Properties props) {
        this();
        this.applyProperties(props);
    }

    public void applyProperties(Properties properties) {
        this.applyProperties(propertyName -> properties.getProperty((String)propertyName), null);
    }

    public void applyProperties(Function<String, String> propertySource, ManageConfig manageConfigToReuse) {
        this.manageConfig = manageConfigToReuse != null ? manageConfigToReuse : new DefaultManageConfigFactory(propertyName -> (String)propertySource.apply(propertyName)).newManageConfig();
        if (this.propertyConsumerMap == null) {
            this.initializePropertyConsumerMap();
        }
        for (Map.Entry<String, Consumer<String>> propertyEntry : this.propertyConsumerMap.entrySet()) {
            String value = propertySource.apply(propertyEntry.getKey());
            if (value == null) continue;
            propertyEntry.getValue().accept(value);
        }
        this.instantiateSslObjects();
    }

    @JsonIgnore
    protected Map<String, Consumer<String>> getPropertyConsumerMap() {
        return this.propertyConsumerMap;
    }

    public void registerLowerCasedPropertyConsumers() {
        if (this.propertyConsumerMap == null) {
            this.initializePropertyConsumerMap();
        }
        HashSet<String> propertyNames = new HashSet<String>(this.propertyConsumerMap.keySet());
        propertyNames.forEach(propertyName -> this.propertyConsumerMap.put(propertyName.toLowerCase(), this.propertyConsumerMap.get(propertyName)));
    }

    public DatabaseClient newStagingClient(String dbName) {
        DatabaseClientConfig config = new DatabaseClientConfig(this.host, this.stagingPort.intValue(), this.username, this.password);
        if (dbName != null) {
            config.setDatabase(dbName);
        }
        config.setSecurityContextType(SecurityContextType.valueOf((String)this.stagingAuthMethod.toUpperCase()));
        config.setSslHostnameVerifier(this.stagingSslHostnameVerifier);
        config.setSslContext(this.stagingSslContext);
        config.setCertFile(this.stagingCertFile);
        config.setCertPassword(this.stagingCertPassword);
        config.setExternalName(this.stagingExternalName);
        config.setTrustManager(this.stagingTrustManager);
        if (this.mlAuthentication.equals("cloud")) {
            config.setSecurityContextType(SecurityContextType.CLOUD);
            config.setCloudApiKey(this.cloudApiKey);
            config.setBasePath(this.stagingBasePath);
            config.setPort(443);
            config.setConnectionType(DatabaseClient.ConnectionType.GATEWAY);
        }
        if (this.isHostLoadBalancer.booleanValue()) {
            config.setConnectionType(DatabaseClient.ConnectionType.GATEWAY);
        }
        return this.configuredDatabaseClientFactory.newDatabaseClient(config);
    }

    public DatabaseClient newFinalClient(String dbName) {
        DatabaseClientConfig config = new DatabaseClientConfig(this.host, this.finalPort.intValue(), this.username, this.password);
        if (dbName != null) {
            config.setDatabase(dbName);
        }
        config.setSecurityContextType(SecurityContextType.valueOf((String)this.finalAuthMethod.toUpperCase()));
        config.setSslHostnameVerifier(this.finalSslHostnameVerifier);
        config.setSslContext(this.finalSslContext);
        config.setCertFile(this.finalCertFile);
        config.setCertPassword(this.finalCertPassword);
        config.setExternalName(this.finalExternalName);
        config.setTrustManager(this.finalTrustManager);
        if (this.mlAuthentication.equals("cloud")) {
            config.setSecurityContextType(SecurityContextType.CLOUD);
            config.setCloudApiKey(this.cloudApiKey);
            config.setBasePath(this.finalBasePath);
            config.setPort(443);
            config.setConnectionType(DatabaseClient.ConnectionType.GATEWAY);
        }
        if (this.isHostLoadBalancer.booleanValue()) {
            config.setConnectionType(DatabaseClient.ConnectionType.GATEWAY);
        }
        return this.configuredDatabaseClientFactory.newDatabaseClient(config);
    }

    public DatabaseClient newJobDbClient() {
        DatabaseClientConfig config = new DatabaseClientConfig(this.host, this.jobPort.intValue(), this.username, this.password);
        config.setSecurityContextType(SecurityContextType.valueOf((String)this.jobAuthMethod.toUpperCase()));
        config.setSslHostnameVerifier(this.jobSslHostnameVerifier);
        config.setSslContext(this.jobSslContext);
        config.setCertFile(this.jobCertFile);
        config.setCertPassword(this.jobCertPassword);
        config.setExternalName(this.jobExternalName);
        config.setTrustManager(this.jobTrustManager);
        if (this.mlAuthentication.equals("cloud")) {
            config.setSecurityContextType(SecurityContextType.CLOUD);
            config.setCloudApiKey(this.cloudApiKey);
            config.setBasePath(this.jobBasePath);
            config.setPort(443);
            config.setConnectionType(DatabaseClient.ConnectionType.GATEWAY);
        }
        if (this.isHostLoadBalancer.booleanValue()) {
            config.setConnectionType(DatabaseClient.ConnectionType.GATEWAY);
        }
        return this.configuredDatabaseClientFactory.newDatabaseClient(config);
    }

    public DatabaseClient newModulesDbClient() {
        return this.newFinalClient(this.modulesDbName);
    }

    @JsonIgnore
    public Map<DatabaseKind, String> getDatabaseNames() {
        HashMap<DatabaseKind, String> databaseNames = new HashMap<DatabaseKind, String>();
        databaseNames.put(DatabaseKind.STAGING, this.getStagingDbName());
        databaseNames.put(DatabaseKind.FINAL, this.getFinalDbName());
        databaseNames.put(DatabaseKind.JOB, this.getJobDbName());
        databaseNames.put(DatabaseKind.MODULES, this.getModulesDbName());
        databaseNames.put(DatabaseKind.STAGING_TRIGGERS, this.getStagingTriggersDbName());
        databaseNames.put(DatabaseKind.STAGING_SCHEMAS, this.getStagingSchemasDbName());
        databaseNames.put(DatabaseKind.FINAL_TRIGGERS, this.getFinalTriggersDbName());
        databaseNames.put(DatabaseKind.FINAL_SCHEMAS, this.getFinalSchemasDbName());
        return databaseNames;
    }

    public void applyDefaultPropertyValues() {
        this.host = "localhost";
        this.isHostLoadBalancer = false;
        this.manageConfig = null;
        this.mlAuthentication = "local";
        this.stagingDbName = "data-hub-STAGING";
        this.stagingPort = 8010;
        this.stagingBasePath = "";
        this.stagingAuthMethod = "digest";
        this.stagingSimpleSsl = false;
        this.stagingSslContext = null;
        this.stagingSslHostnameVerifier = null;
        this.stagingCertFile = null;
        this.stagingCertPassword = null;
        this.stagingExternalName = null;
        this.stagingTrustManager = null;
        this.finalDbName = "data-hub-FINAL";
        this.finalPort = 8011;
        this.finalBasePath = "";
        this.finalAuthMethod = "digest";
        this.finalSimpleSsl = false;
        this.finalSslContext = null;
        this.finalSslHostnameVerifier = null;
        this.finalCertFile = null;
        this.finalCertPassword = null;
        this.finalExternalName = null;
        this.finalTrustManager = null;
        this.jobDbName = "data-hub-JOBS";
        this.jobPort = 8013;
        this.jobBasePath = "";
        this.jobAuthMethod = "digest";
        this.jobSimpleSsl = false;
        this.jobSslContext = null;
        this.jobSslHostnameVerifier = null;
        this.jobCertFile = null;
        this.jobCertPassword = null;
        this.jobExternalName = null;
        this.jobTrustManager = null;
        this.modulesDbName = "data-hub-MODULES";
        this.stagingTriggersDbName = "data-hub-staging-TRIGGERS";
        this.finalTriggersDbName = "data-hub-final-TRIGGERS";
        this.stagingSchemasDbName = "data-hub-staging-SCHEMAS";
        this.finalSchemasDbName = "data-hub-final-SCHEMAS";
        this.maxStringsInMemory = 0;
        this.collectorTmpDir = "";
        this.modulePermissions = "data-hub-module-reader,read,data-hub-module-reader,execute,data-hub-module-writer,update,rest-extension-user,execute";
        this.supportMlColonPrefix = false;
    }

    public void configureForDhs() {
        this.isHostLoadBalancer = true;
        this.finalAuthMethod = "basic";
        this.stagingAuthMethod = "basic";
        this.jobAuthMethod = "basic";
        this.enableSimpleSsl();
    }

    public void enableSimpleSsl() {
        this.finalSimpleSsl = true;
        this.stagingSimpleSsl = true;
        this.jobSimpleSsl = true;
        this.manageConfig.setScheme("https");
        this.manageConfig.setConfigureSimpleSsl(true);
    }

    public void disableSimpleSsl() {
        this.finalSimpleSsl = false;
        this.stagingSimpleSsl = false;
        this.jobSimpleSsl = false;
        this.manageConfig.setScheme("http");
        this.manageConfig.setConfigureSimpleSsl(false);
    }

    protected void initializePropertyConsumerMap() {
        this.propertyConsumerMap = new LinkedHashMap<String, Consumer<String>>();
        this.propertyConsumerMap.put("mlUsername", prop -> {
            this.username = prop;
        });
        this.propertyConsumerMap.put("mlPassword", prop -> {
            this.password = prop;
        });
        this.propertyConsumerMap.put("mlCloudApiKey", prop -> {
            this.cloudApiKey = prop;
        });
        this.propertyConsumerMap.put("mlAuthentication", prop -> {
            if (prop.equals("cloud")) {
                this.initializeSslConfigForCloud();
            }
            this.mlAuthentication = prop;
        });
        this.propertyConsumerMap.put("mlDHFVersion", prop -> logger.warn("mlDHFVersion no longer has any impact starting in version 5.3.0. You may safely remove this from your properties file."));
        this.propertyConsumerMap.put("mlHost", prop -> {
            this.host = prop;
        });
        this.propertyConsumerMap.put("mlIsHostLoadBalancer", prop -> {
            this.isHostLoadBalancer = Boolean.parseBoolean(prop);
        });
        this.propertyConsumerMap.put("mlLoadBalancerHosts", prop -> logger.warn("mlLoadBalancerHosts was deprecated in version 4.0.1 and does not have any impact on Data Hub functionality. It can be safely removed from your set of properties."));
        this.propertyConsumerMap.put("mlStagingDbName", prop -> {
            this.stagingDbName = prop;
        });
        this.propertyConsumerMap.put("mlStagingPort", prop -> {
            this.stagingPort = Integer.parseInt(prop);
        });
        this.propertyConsumerMap.put("mlStagingBasePath", prop -> {
            this.stagingBasePath = prop;
        });
        this.propertyConsumerMap.put("mlStagingAuth", prop -> {
            this.stagingAuthMethod = prop;
        });
        this.propertyConsumerMap.put("mlStagingSimpleSsl", prop -> {
            this.stagingSimpleSsl = Boolean.parseBoolean(prop);
        });
        this.propertyConsumerMap.put("mlStagingCertFile", prop -> {
            this.stagingCertFile = prop;
        });
        this.propertyConsumerMap.put("mlStagingCertPassword", prop -> {
            this.stagingCertPassword = prop;
        });
        this.propertyConsumerMap.put("mlStagingExternalName", prop -> {
            this.stagingExternalName = prop;
        });
        this.propertyConsumerMap.put("mlFinalDbName", prop -> {
            this.finalDbName = prop;
        });
        this.propertyConsumerMap.put("mlFinalPort", prop -> {
            this.finalPort = Integer.parseInt(prop);
        });
        this.propertyConsumerMap.put("mlFinalBasePath", prop -> {
            this.finalBasePath = prop;
        });
        this.propertyConsumerMap.put("mlFinalAuth", prop -> {
            this.finalAuthMethod = prop;
        });
        this.propertyConsumerMap.put("mlFinalSimpleSsl", prop -> {
            this.finalSimpleSsl = Boolean.parseBoolean(prop);
        });
        this.propertyConsumerMap.put("mlFinalCertFile", prop -> {
            this.finalCertFile = prop;
        });
        this.propertyConsumerMap.put("mlFinalCertPassword", prop -> {
            this.finalCertPassword = prop;
        });
        this.propertyConsumerMap.put("mlFinalExternalName", prop -> {
            this.finalExternalName = prop;
        });
        this.propertyConsumerMap.put("mlJobDbName", prop -> {
            this.jobDbName = prop;
        });
        this.propertyConsumerMap.put("mlJobPort", prop -> {
            this.jobPort = Integer.parseInt(prop);
        });
        this.propertyConsumerMap.put("mlJobBasePath", prop -> {
            this.jobBasePath = prop;
        });
        this.propertyConsumerMap.put("mlJobAuth", prop -> {
            this.jobAuthMethod = prop;
        });
        this.propertyConsumerMap.put("mlJobSimpleSsl", prop -> {
            this.jobSimpleSsl = Boolean.parseBoolean(prop);
        });
        this.propertyConsumerMap.put("mlJobCertFile", prop -> {
            this.jobCertFile = prop;
        });
        this.propertyConsumerMap.put("mlJobCertPassword", prop -> {
            this.jobCertPassword = prop;
        });
        this.propertyConsumerMap.put("mlJobExternalName", prop -> {
            this.jobExternalName = prop;
        });
        this.propertyConsumerMap.put("mlModulesDbName", prop -> {
            this.modulesDbName = prop;
        });
        this.propertyConsumerMap.put("mlStagingTriggersDbName", prop -> {
            this.stagingTriggersDbName = prop;
        });
        this.propertyConsumerMap.put("mlStagingSchemasDbName", prop -> {
            this.stagingSchemasDbName = prop;
        });
        this.propertyConsumerMap.put("mlFinalTriggersDbName", prop -> {
            this.finalTriggersDbName = prop;
        });
        this.propertyConsumerMap.put("mlFinalSchemasDbName", prop -> {
            this.finalSchemasDbName = prop;
        });
        this.propertyConsumerMap.put("hubMaxStringsInMemory", prop -> {
            this.maxStringsInMemory = Integer.parseInt(prop);
        });
        this.propertyConsumerMap.put("hubCollectorTmpDir", prop -> {
            this.collectorTmpDir = prop;
        });
        this.propertyConsumerMap.put("mlModulePermissions", prop -> {
            this.modulePermissions = prop;
        });
        this.propertyConsumerMap.put("hubSupportMlColonPrefix", prop -> {
            this.supportMlColonPrefix = Boolean.parseBoolean(prop);
        });
        this.propertyConsumerMap.put("hubDhs", prop -> {
            if (Boolean.parseBoolean(prop)) {
                this.configureForDhs();
            }
        });
        this.propertyConsumerMap.put("hubSsl", prop -> {
            if (Boolean.parseBoolean(prop)) {
                this.enableSimpleSsl();
            } else {
                this.disableSimpleSsl();
            }
        });
    }

    private void instantiateSslObjects() {
        if (this.stagingSimpleSsl != null && this.stagingSimpleSsl.booleanValue()) {
            this.stagingSslContext = SimpleX509TrustManager.newSSLContext();
            this.stagingSslHostnameVerifier = DatabaseClientFactory.SSLHostnameVerifier.ANY;
            this.stagingTrustManager = new SimpleX509TrustManager();
        }
        if (this.finalSimpleSsl != null && this.finalSimpleSsl.booleanValue()) {
            this.finalSslContext = SimpleX509TrustManager.newSSLContext();
            this.finalSslHostnameVerifier = DatabaseClientFactory.SSLHostnameVerifier.ANY;
            this.finalTrustManager = new SimpleX509TrustManager();
        }
        if (this.jobSimpleSsl != null && this.jobSimpleSsl.booleanValue()) {
            this.jobSslContext = SimpleX509TrustManager.newSSLContext();
            this.jobSslHostnameVerifier = DatabaseClientFactory.SSLHostnameVerifier.ANY;
            this.jobTrustManager = new SimpleX509TrustManager();
        }
    }

    private void initializeSslConfigForCloud() {
        SSLContext sslContext;
        this.stagingSslContext = sslContext = SimpleX509TrustManager.newSSLContext();
        this.finalSslContext = sslContext;
        this.jobSslContext = sslContext;
        SimpleX509TrustManager trustManager = new SimpleX509TrustManager();
        this.stagingTrustManager = trustManager;
        this.finalTrustManager = trustManager;
        this.jobTrustManager = trustManager;
        this.stagingSslHostnameVerifier = DatabaseClientFactory.SSLHostnameVerifier.ANY;
        this.finalSslHostnameVerifier = DatabaseClientFactory.SSLHostnameVerifier.ANY;
        this.jobSslHostnameVerifier = DatabaseClientFactory.SSLHostnameVerifier.ANY;
    }

    public void setConfiguredDatabaseClientFactory(ConfiguredDatabaseClientFactory configuredDatabaseClientFactory) {
        this.configuredDatabaseClientFactory = configuredDatabaseClientFactory;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @JsonIgnore
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCloudApiKey() {
        return this.cloudApiKey;
    }

    public void setCloudApiKey(String cloudApiKey) {
        this.cloudApiKey = cloudApiKey;
    }

    public String getMlAuthentication() {
        return this.mlAuthentication;
    }

    public void setMlAuthentication(String mlAuthentication) {
        this.mlAuthentication = mlAuthentication;
    }

    public Integer getStagingPort() {
        return this.stagingPort;
    }

    public void setStagingPort(Integer stagingPort) {
        this.stagingPort = stagingPort;
    }

    public String getStagingBasePath() {
        return this.stagingBasePath;
    }

    public void setStagingBasePath(String stagingBasePath) {
        this.stagingBasePath = stagingBasePath;
    }

    public String getStagingAuthMethod() {
        return this.stagingAuthMethod;
    }

    public void setStagingAuthMethod(String stagingAuthMethod) {
        this.stagingAuthMethod = stagingAuthMethod;
    }

    public Boolean getStagingSimpleSsl() {
        return this.stagingSimpleSsl;
    }

    public void setStagingSimpleSsl(Boolean stagingSimpleSsl) {
        this.stagingSimpleSsl = stagingSimpleSsl;
    }

    @JsonIgnore
    public SSLContext getStagingSslContext() {
        return this.stagingSslContext;
    }

    public void setStagingSslContext(SSLContext stagingSslContext) {
        this.stagingSslContext = stagingSslContext;
    }

    @JsonIgnore
    public DatabaseClientFactory.SSLHostnameVerifier getStagingSslHostnameVerifier() {
        return this.stagingSslHostnameVerifier;
    }

    public void setStagingSslHostnameVerifier(DatabaseClientFactory.SSLHostnameVerifier stagingSslHostnameVerifier) {
        this.stagingSslHostnameVerifier = stagingSslHostnameVerifier;
    }

    public String getStagingCertFile() {
        return this.stagingCertFile;
    }

    public void setStagingCertFile(String stagingCertFile) {
        this.stagingCertFile = stagingCertFile;
    }

    @JsonIgnore
    public String getStagingCertPassword() {
        return this.stagingCertPassword;
    }

    public void setStagingCertPassword(String stagingCertPassword) {
        this.stagingCertPassword = stagingCertPassword;
    }

    public String getStagingExternalName() {
        return this.stagingExternalName;
    }

    public void setStagingExternalName(String stagingExternalName) {
        this.stagingExternalName = stagingExternalName;
    }

    @JsonIgnore
    public X509TrustManager getStagingTrustManager() {
        return this.stagingTrustManager;
    }

    public void setStagingTrustManager(X509TrustManager stagingTrustManager) {
        this.stagingTrustManager = stagingTrustManager;
    }

    public Integer getFinalPort() {
        return this.finalPort;
    }

    public void setFinalPort(Integer finalPort) {
        this.finalPort = finalPort;
    }

    public String getFinalBasePath() {
        return this.finalBasePath;
    }

    public void setFinalBasePath(String finalBasePath) {
        this.finalBasePath = finalBasePath;
    }

    public String getFinalAuthMethod() {
        return this.finalAuthMethod;
    }

    public void setFinalAuthMethod(String finalAuthMethod) {
        this.finalAuthMethod = finalAuthMethod;
    }

    public Boolean getFinalSimpleSsl() {
        return this.finalSimpleSsl;
    }

    public void setFinalSimpleSsl(Boolean finalSimpleSsl) {
        this.finalSimpleSsl = finalSimpleSsl;
    }

    @JsonIgnore
    public SSLContext getFinalSslContext() {
        return this.finalSslContext;
    }

    public void setFinalSslContext(SSLContext finalSslContext) {
        this.finalSslContext = finalSslContext;
    }

    @JsonIgnore
    public DatabaseClientFactory.SSLHostnameVerifier getFinalSslHostnameVerifier() {
        return this.finalSslHostnameVerifier;
    }

    public void setFinalSslHostnameVerifier(DatabaseClientFactory.SSLHostnameVerifier finalSslHostnameVerifier) {
        this.finalSslHostnameVerifier = finalSslHostnameVerifier;
    }

    public String getFinalCertFile() {
        return this.finalCertFile;
    }

    public void setFinalCertFile(String finalCertFile) {
        this.finalCertFile = finalCertFile;
    }

    @JsonIgnore
    public String getFinalCertPassword() {
        return this.finalCertPassword;
    }

    public void setFinalCertPassword(String finalCertPassword) {
        this.finalCertPassword = finalCertPassword;
    }

    public String getFinalExternalName() {
        return this.finalExternalName;
    }

    public void setFinalExternalName(String finalExternalName) {
        this.finalExternalName = finalExternalName;
    }

    @JsonIgnore
    public X509TrustManager getFinalTrustManager() {
        return this.finalTrustManager;
    }

    public void setFinalTrustManager(X509TrustManager finalTrustManager) {
        this.finalTrustManager = finalTrustManager;
    }

    public Integer getJobPort() {
        return this.jobPort;
    }

    public void setJobPort(Integer jobPort) {
        this.jobPort = jobPort;
    }

    public String getJobBasePath() {
        return this.jobBasePath;
    }

    public void setJobBasePath(String jobBasePath) {
        this.jobBasePath = jobBasePath;
    }

    public String getJobAuthMethod() {
        return this.jobAuthMethod;
    }

    public void setJobAuthMethod(String jobAuthMethod) {
        this.jobAuthMethod = jobAuthMethod;
    }

    public Boolean getJobSimpleSsl() {
        return this.jobSimpleSsl;
    }

    public void setJobSimpleSsl(Boolean jobSimpleSsl) {
        this.jobSimpleSsl = jobSimpleSsl;
    }

    @JsonIgnore
    public SSLContext getJobSslContext() {
        return this.jobSslContext;
    }

    public void setJobSslContext(SSLContext jobSslContext) {
        this.jobSslContext = jobSslContext;
    }

    @JsonIgnore
    public DatabaseClientFactory.SSLHostnameVerifier getJobSslHostnameVerifier() {
        return this.jobSslHostnameVerifier;
    }

    public void setJobSslHostnameVerifier(DatabaseClientFactory.SSLHostnameVerifier jobSslHostnameVerifier) {
        this.jobSslHostnameVerifier = jobSslHostnameVerifier;
    }

    public String getJobCertFile() {
        return this.jobCertFile;
    }

    public void setJobCertFile(String jobCertFile) {
        this.jobCertFile = jobCertFile;
    }

    @JsonIgnore
    public String getJobCertPassword() {
        return this.jobCertPassword;
    }

    public void setJobCertPassword(String jobCertPassword) {
        this.jobCertPassword = jobCertPassword;
    }

    public String getJobExternalName() {
        return this.jobExternalName;
    }

    public void setJobExternalName(String jobExternalName) {
        this.jobExternalName = jobExternalName;
    }

    @JsonIgnore
    public X509TrustManager getJobTrustManager() {
        return this.jobTrustManager;
    }

    public void setJobTrustManager(X509TrustManager jobTrustManager) {
        this.jobTrustManager = jobTrustManager;
    }

    public String getModulesDbName() {
        return this.modulesDbName;
    }

    public void setModulesDbName(String modulesDbName) {
        this.modulesDbName = modulesDbName;
    }

    public Boolean getIsHostLoadBalancer() {
        return this.isHostLoadBalancer;
    }

    public void setIsHostLoadBalancer(Boolean hostLoadBalancer) {
        this.isHostLoadBalancer = hostLoadBalancer;
    }

    public String getStagingDbName() {
        return this.stagingDbName;
    }

    public void setStagingDbName(String stagingDbName) {
        this.stagingDbName = stagingDbName;
    }

    public String getFinalDbName() {
        return this.finalDbName;
    }

    public void setFinalDbName(String finalDbName) {
        this.finalDbName = finalDbName;
    }

    public String getJobDbName() {
        return this.jobDbName;
    }

    public void setJobDbName(String jobDbName) {
        this.jobDbName = jobDbName;
    }

    public String getStagingTriggersDbName() {
        return this.stagingTriggersDbName;
    }

    public void setStagingTriggersDbName(String stagingTriggersDbName) {
        this.stagingTriggersDbName = stagingTriggersDbName;
    }

    public String getFinalTriggersDbName() {
        return this.finalTriggersDbName;
    }

    public void setFinalTriggersDbName(String finalTriggersDbName) {
        this.finalTriggersDbName = finalTriggersDbName;
    }

    public String getStagingSchemasDbName() {
        return this.stagingSchemasDbName;
    }

    public void setStagingSchemasDbName(String stagingSchemasDbName) {
        this.stagingSchemasDbName = stagingSchemasDbName;
    }

    public String getFinalSchemasDbName() {
        return this.finalSchemasDbName;
    }

    public void setFinalSchemasDbName(String finalSchemasDbName) {
        this.finalSchemasDbName = finalSchemasDbName;
    }

    public Integer getMaxStringsInMemory() {
        return this.maxStringsInMemory;
    }

    public void setMaxStringsInMemory(Integer maxStringsInMemory) {
        this.maxStringsInMemory = maxStringsInMemory;
    }

    public String getCollectorTmpDir() {
        return this.collectorTmpDir;
    }

    public void setCollectorTmpDir(String collectorTmpDir) {
        this.collectorTmpDir = collectorTmpDir;
    }

    @JsonIgnore
    public ManageConfig getManageConfig() {
        return this.manageConfig;
    }

    public void setManageConfig(ManageConfig manageConfig) {
        this.manageConfig = manageConfig;
    }

    public String getModulePermissions() {
        return this.modulePermissions;
    }

    public void setModulePermissions(String modulePermissions) {
        this.modulePermissions = modulePermissions;
    }

    public boolean supportMlColonPrefix() {
        return this.supportMlColonPrefix;
    }
}

