/*
 * Decompiled with CFR 0.152.
 */
package marketo.utils;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.Patterns;
import android.widget.Toast;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import marketo.utils.MktoDeviceIdentifier;
import org.json.JSONException;
import org.json.JSONObject;

public class MktoUtils {
    static final String MKTOPREF = "com.mkto.mobile";
    static final String TAG = "MKTO";
    protected static Boolean supportAvailable = null;

    public static void writeDebugLog(String string) {
        Log.d((String)TAG, (String)string);
    }

    public static void writeDebugStrace(Exception ex) {
        ex.printStackTrace();
    }

    public static void writelog(String s) {
        Log.w((String)TAG, (String)s);
    }

    public static void writeError(String s) {
        Log.e((String)TAG, (String)s);
    }

    public static void writeWarning(String s) {
        Log.w((String)TAG, (String)s);
    }

    public static void writeInfo(String s) {
        Log.i((String)TAG, (String)s);
    }

    public static void clearPreference(Context context, String name) {
        Context ctx = context;
        if (ctx != null && !TextUtils.isEmpty((CharSequence)name)) {
            SharedPreferences settings = ctx.getSharedPreferences(MKTOPREF, 0);
            SharedPreferences.Editor editor = settings.edit();
            editor.remove(name);
            editor.commit();
        }
    }

    public static void writePreference(Context context, String name, String value) {
        Context ctx = context;
        if (ctx != null && !TextUtils.isEmpty((CharSequence)name) && value != null) {
            SharedPreferences settings = ctx.getSharedPreferences(MKTOPREF, 0);
            SharedPreferences.Editor editor = settings.edit();
            editor.putString(name, value);
            editor.commit();
        }
    }

    public static String readPreference(Context context, String name) {
        String result = null;
        if (context != null) {
            SharedPreferences settings = context.getSharedPreferences(MKTOPREF, 0);
            try {
                result = settings.getString(name, "");
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return result;
    }

    public static void writePreference(Context context, String name, boolean value) {
        Context ctx = context;
        if (ctx != null && !TextUtils.isEmpty((CharSequence)name)) {
            SharedPreferences settings = ctx.getSharedPreferences(MKTOPREF, 0);
            SharedPreferences.Editor editor = settings.edit();
            editor.putBoolean(name, value);
            editor.commit();
        }
    }

    public static boolean readPreference(Context context, String name, boolean defaultValue) {
        boolean ret = defaultValue;
        Context ctx = context;
        if (ctx != null) {
            SharedPreferences settings = ctx.getSharedPreferences(MKTOPREF, 0);
            try {
                ret = settings.getBoolean(name, defaultValue);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static int readPreferenceInt(Context context, String name, int defaultValue) {
        int ret = defaultValue;
        Context ctx = context;
        if (ctx != null) {
            SharedPreferences settings = ctx.getSharedPreferences(MKTOPREF, 0);
            try {
                ret = settings.getInt(name, defaultValue);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static void writePreference(Context context, String name, int value) {
        Context ctx = context;
        if (ctx != null && !TextUtils.isEmpty((CharSequence)name)) {
            SharedPreferences settings = ctx.getSharedPreferences(MKTOPREF, 0);
            SharedPreferences.Editor editor = settings.edit();
            editor.putInt(name, value);
            editor.commit();
        }
    }

    public static long readPreferenceLong(Context context, String name, long defaultValue) {
        long ret = defaultValue;
        Context ctx = context;
        if (ctx != null) {
            SharedPreferences settings = ctx.getSharedPreferences(MKTOPREF, 0);
            try {
                ret = settings.getLong(name, defaultValue);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static void writePreferenceLong(Context context, String name, long value) {
        Context ctx = context;
        if (ctx != null && !TextUtils.isEmpty((CharSequence)name)) {
            SharedPreferences settings = ctx.getSharedPreferences(MKTOPREF, 0);
            SharedPreferences.Editor editor = settings.edit();
            editor.putLong(name, value);
            editor.commit();
        }
    }

    static String getHash(String s) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] bytes = s.getBytes("UTF-8");
            if (bytes != null) {
                digest.update(bytes, 0, bytes.length);
            }
            byte[] md5 = digest.digest();
            return MktoUtils.bytesToHex(md5);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    static String bytesToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static String getAppName(Context context) {
        String appName = "unknown";
        if (context != null) {
            ApplicationInfo ai;
            PackageManager pm = context.getApplicationContext().getPackageManager();
            try {
                ai = pm.getApplicationInfo(context.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                ai = null;
            }
            appName = ai != null ? pm.getApplicationLabel(ai) : "unknown";
        }
        return appName;
    }

    public static String getAppVersion(Context context) {
        String app_ver = "unknown";
        if (context != null) {
            try {
                app_ver = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
            }
            catch (PackageManager.NameNotFoundException e) {
                MktoUtils.writelog("VersionNotFoundException");
            }
        }
        return app_ver;
    }

    public static String getAppVersionCode(Context context) {
        String versionCode = "unknown";
        if (context != null) {
            try {
                int i = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
                versionCode = Integer.toString(i);
            }
            catch (Exception e) {
                MktoUtils.writelog("VersionNotFoundException");
            }
        }
        return versionCode;
    }

    public static boolean isJellyBeanAndAbove() {
        return MktoUtils.getVersion() >= 16;
    }

    public static boolean isHoneyCombAndAbove() {
        return MktoUtils.getVersion() >= 11;
    }

    public static JSONObject getBuildInfo() {
        JSONObject object = new JSONObject();
        try {
            object.put("brand", (Object)Build.BRAND);
            object.put("product", (Object)Build.PRODUCT);
            object.put("sdk", (Object)Build.VERSION.RELEASE);
            object.put("api-level", Build.VERSION.SDK_INT);
            object.put("build", (Object)Build.ID);
            Locale locale = Locale.getDefault();
            if (locale != null) {
                object.put("locale", (Object)locale.toString());
                object.put("language", (Object)locale.getLanguage());
                object.put("locale_country", (Object)locale.getCountry());
                object.put("language_variant", (Object)locale.getVariant());
                object.put("locale_iso3_country", (Object)locale.getISO3Country());
                object.put("locale_iso3_language", (Object)locale.getISO3Language());
            }
        }
        catch (Exception e) {
            MktoUtils.writelog("Failed to get build information");
        }
        return object;
    }

    public static String getNetworkOperator(Context mCtx) {
        TelephonyManager manager = (TelephonyManager)mCtx.getSystemService("phone");
        if (manager != null) {
            return manager.getNetworkOperatorName();
        }
        return "n/a";
    }

    public static JSONObject haveInternet(Context context) {
        JSONObject object = new JSONObject();
        try {
            TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
            String phoneType = MktoUtils.getPhoneType(manager.getPhoneType());
            object.put("service_provider", (Object)MktoUtils.getNetworkOperator(context));
            object.put("phone_type", (Object)phoneType);
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = connectivityManager.getActiveNetworkInfo();
            if (info != null) {
                object.put("availability", info.isAvailable());
                object.put("availability", false);
                object.put("on_roaming", info.isRoaming());
                object.put("is_connected", info.isConnected());
                object.put("connection_type", (Object)(info.isConnected() ? info.getTypeName() : ""));
            } else {
                object.put("availability", false);
                object.put("is_connected", false);
                object.put("on_roaming", false);
                MktoUtils.writelog("unable to find network connection");
            }
        }
        catch (JSONException manager) {
        }
        catch (Exception e) {
            MktoUtils.writelog("Add android.permission.ACCESS_NETWORK_STATE in manifest for detailed network information.");
        }
        return object;
    }

    static String getPhoneType(int phoneType) {
        switch (phoneType) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "GSM";
            }
            case 2: {
                return "CDMA";
            }
        }
        return "UNKNOWN";
    }

    public static boolean launchUrl(Activity activity, String url) {
        try {
            Intent i = new Intent("android.intent.action.VIEW");
            i.setData(Uri.parse((String)url.trim()));
            activity.startActivity(i);
            return true;
        }
        catch (ActivityNotFoundException exception) {
            MktoUtils.writelog("Failed to update to new version");
            return false;
        }
    }

    public static boolean permissionLookup(Context context, String name) {
        if (context != null) {
            PackageManager pm = context.getPackageManager();
            return pm.checkPermission(name, context.getPackageName()) == 0;
        }
        return false;
    }

    public static int getVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static Location getLocation(Context mContext) {
        if (MktoUtils.permissionLookup(mContext, "android.permission.ACCESS_FINE_LOCATION") || MktoUtils.permissionLookup(mContext, "android.permission.ACCESS_COARSE_LOCATION")) {
            try {
                LocationManager locationManager = (LocationManager)mContext.getSystemService("location");
                String provider = "network";
                Location location = locationManager.getLastKnownLocation(provider);
                return location;
            }
            catch (Exception e) {
                MktoUtils.writeError("Failed to get location");
            }
        }
        return null;
    }

    public static JSONObject getLocationJSON(Context context) {
        JSONObject locationObj = new JSONObject();
        try {
            Location location = MktoUtils.getLocation(context);
            if (location == null) {
                return null;
            }
            locationObj.put("latitude", location.getLatitude());
            locationObj.put("longitude", location.getLongitude());
            return locationObj;
        }
        catch (Exception e) {
            MktoUtils.writeError("Error getting location");
            return null;
        }
    }

    public static String truncate(String str, int len) {
        if (!TextUtils.isEmpty((CharSequence)str)) {
            if (len <= 3) {
                throw new IllegalArgumentException();
            }
            if (str.length() > len) {
                return str.substring(0, len - 3) + "...";
            }
            return str;
        }
        return null;
    }

    public static void checkBlockResponse(Context ctx, JSONObject response) {
        boolean blocked = response.optBoolean("blocked", false);
        if (blocked) {
            String versionCode = MktoUtils.getAppVersionCode(ctx);
            MktoUtils.writePreference(ctx, versionCode + "blocked", true);
        }
    }

    public static boolean checkIfIsBlocked(Context ctx, String currVersion) {
        return MktoUtils.readPreference(ctx, currVersion + "blocked", false);
    }

    public static boolean validateEmail(String evalue) {
        if (!TextUtils.isEmpty((CharSequence)evalue)) {
            String EMAIL_PATTERN = "^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
            Pattern pattern = Pattern.compile(EMAIL_PATTERN);
            Matcher matcher = pattern.matcher(evalue);
            return matcher.matches();
        }
        return false;
    }

    public static boolean InstallFile(Activity activity, String fileName) {
        try {
            File file = new File(Environment.getExternalStorageDirectory() + "/Vessel/" + fileName);
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.fromFile((File)file), "application/vnd.android.package-archive");
            activity.startActivity(intent);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isSameDay(long last, long current) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTimeInMillis(last);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTimeInMillis(current);
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static long getDate() {
        return System.currentTimeMillis() / 1000L;
    }

    public static boolean isInDebugMode(Context context) {
        return context != null && 0 != (context.getApplicationInfo().flags &= 2);
    }

    public static float dpToPx(int dp) {
        return (float)dp * Resources.getSystem().getDisplayMetrics().density;
    }

    public static String getVisibility(int visibility) {
        if (0 == visibility) {
            return "visible";
        }
        if (4 == visibility) {
            return "invisible";
        }
        if (8 == visibility) {
            return "gone";
        }
        return "";
    }

    public static void showToastMessage(final Activity activity, final String string) {
        if (activity != null && !TextUtils.isEmpty((CharSequence)string)) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Toast.makeText((Context)activity, (CharSequence)string, (int)0).show();
                }
            });
        }
    }

    static HttpsURLConnection getHeaders(Context context, boolean includeEtag, HttpsURLConnection urlConnection) {
        urlConnection.setRequestProperty("p", "android");
        urlConnection.setRequestProperty("sec", MktoUtils.readPreference(context, "mkto.secretkey"));
        urlConnection.setRequestProperty("sdkvr", Integer.toString(7));
        urlConnection.setRequestProperty("appbd", MktoUtils.getAppVersionCode(context));
        urlConnection.setRequestProperty("appver", MktoUtils.getAppVersion(context));
        urlConnection.setRequestProperty("uuid", MktoDeviceIdentifier.getOrCreateUUID(context));
        urlConnection.setRequestProperty("tduuid", MktoDeviceIdentifier.getTestDeviceIdentifier(context));
        urlConnection.setRequestProperty("tz", MktoUtils.getCurrentTimeZone());
        urlConnection.setRequestProperty("lc", MktoUtils.getCurrentLocal());
        if (includeEtag) {
            String etag = MktoUtils.readPreference(context, "initETag");
            urlConnection.setRequestProperty("If-None-Match", etag);
        }
        return urlConnection;
    }

    public static CharSequence getDeviceName() {
        return Build.BRAND + "_" + Build.MANUFACTURER + "_" + Build.MODEL;
    }

    public static boolean isSupportLibraryAvailable() {
        if (supportAvailable != null) {
            return supportAvailable;
        }
        try {
            Class.forName("android.support.v4.view.ViewPager");
            supportAvailable = true;
        }
        catch (ClassNotFoundException e) {
            supportAvailable = false;
        }
        return supportAvailable;
    }

    public static long tick() {
        return System.currentTimeMillis();
    }

    public static void tock(long start, String message) {
        long difference = MktoUtils.tick() - start;
        MktoUtils.writeWarning("Elapsed milliseconds: " + difference + " [" + message + "]");
    }

    public static final boolean isValidEmail(CharSequence target) {
        return !TextUtils.isEmpty((CharSequence)target) && Patterns.EMAIL_ADDRESS.matcher(target).matches();
    }

    public static boolean isValidSecurityTokens(String accesskey, String signature, long timestamp, String email) {
        return !TextUtils.isEmpty((CharSequence)accesskey) && !TextUtils.isEmpty((CharSequence)signature) && timestamp != 0L && !TextUtils.isEmpty((CharSequence)email);
    }

    public static String getCurrentTimeZone() {
        return TimeZone.getDefault().getID();
    }

    public static String getCurrentLocal() {
        return Locale.getDefault().getLanguage();
    }
}

