/*
 * Decompiled with CFR 0.152.
 */
package marketo.utils;

import android.content.Context;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import com.marketo.Marketo;
import com.marketo.errors.MktoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import marketo.utils.MktoUtils;
import org.json.JSONException;
import org.json.JSONObject;

public final class MktoNetworkManager {
    private static final String SERVER = "https://%s.mktomma.com";
    private static final String INTERNAL_ERROR = "Internal error occurred";
    private static final String IO_EXCEPTION = "IOException";
    private static final String JSON_EXCEPTION = "JSONException";
    private static final String IMAGE_CURROPTED = "Corrupted Image ";

    private static String createServerBaseUrl(Context context) throws MktoException {
        String customerMunchkinId = MktoUtils.readPreference(context, "mkto.munchkinid");
        if (TextUtils.isEmpty((CharSequence)customerMunchkinId)) {
            throw new MktoException("Invalid munchkinId or endpoint");
        }
        return String.format(SERVER, customerMunchkinId);
    }

    public static JSONObject getRequest(String endApi, Context context) throws MktoException {
        if (TextUtils.isEmpty((CharSequence)endApi)) {
            throw new MktoException("Invalid munchkinId or endpoint");
        }
        String serverUrl = MktoNetworkManager.createServerBaseUrl(context);
        return MktoNetworkManager.get(serverUrl + endApi, context);
    }

    public static JSONObject get(String endApi, Context context) throws MktoException {
        block9: {
            try {
                HttpsURLConnection conn = MktoNetworkManager.getHttpsURLConnection(endApi);
                MktoUtils.getHeaders(context, true, conn);
                ResponseObject response = MktoNetworkManager.executeHttpRequest(conn, HttpMethodType.GET, null);
                if (response == null) break block9;
                if (response.statusCode != 0 && response.statusCode == 304) {
                    MktoUtils.writeDebugLog("No update is available");
                    JSONObject obj = new JSONObject();
                    try {
                        obj.put("success", true);
                        return obj;
                    }
                    catch (JSONException e) {
                        MktoUtils.writeDebugLog(e.getMessage());
                        throw new MktoException(INTERNAL_ERROR);
                    }
                }
                JSONObject respJson = MktoNetworkManager.parseResponse(response.response);
                if (respJson != null) {
                    try {
                        String etagResp = conn.getHeaderField("ETag");
                        if (etagResp != null) {
                            MktoUtils.writeDebugLog("Etag is " + etagResp);
                            respJson.put("etag", (Object)etagResp);
                        }
                    }
                    catch (Exception e) {
                        MktoUtils.writeDebugLog("failed to save etag");
                        throw new MktoException(INTERNAL_ERROR);
                    }
                }
                return respJson;
            }
            catch (IOException e1) {
                throw new MktoException(IO_EXCEPTION);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResponseObject executeHttpRequest(HttpURLConnection connection, HttpMethodType httpMethodType, String body) throws IOException {
        ResponseObject response = new ResponseObject();
        try {
            connection.setReadTimeout(Marketo.getNetworkTimeout());
            connection.setConnectTimeout(Marketo.getNetworkTimeout());
            connection.setRequestProperty("User-Agent", "MarketoSDK 0.8.1");
            connection.setDoInput(true);
            switch (httpMethodType) {
                case GET: {
                    connection.setRequestMethod("GET");
                    connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
                    break;
                }
                case PLANE_POST: {
                    connection.setRequestMethod("POST");
                    connection.setDoOutput(true);
                    connection.setRequestProperty("Content-Type", "text/plain; charset=utf-8");
                    connection.setRequestProperty("Accept-Charset", "utf-8");
                    break;
                }
                case FORM_POST: {
                    connection.setRequestMethod("POST");
                    connection.setDoOutput(true);
                    connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                    connection.setRequestProperty("Accept-Charset", "utf-8");
                }
            }
            if (!(httpMethodType != HttpMethodType.PLANE_POST && httpMethodType != HttpMethodType.FORM_POST || TextUtils.isEmpty((CharSequence)body))) {
                MktoNetworkManager.writeStream(new BufferedOutputStream(connection.getOutputStream()), body);
            }
            connection.connect();
            response.statusCode = connection.getResponseCode();
            BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
            response.response = MktoNetworkManager.readStream(inputStream);
        }
        finally {
            connection.disconnect();
        }
        return response;
    }

    private static String readStream(InputStream inputStream) throws IOException {
        StringBuilder sb = new StringBuilder("");
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        String line = in.readLine();
        while (line != null) {
            sb.append(line);
            line = in.readLine();
        }
        in.close();
        return sb.toString();
    }

    private static void writeStream(OutputStream out, String body) throws IOException {
        BufferedOutputStream buffOutStream = new BufferedOutputStream(out);
        buffOutStream.write(body.getBytes());
        buffOutStream.flush();
    }

    private static String executeHttpPost(String endApi, Map<String, Object> values, Context context) throws MktoException {
        ResponseObject response;
        try {
            HttpsURLConnection conn = MktoNetworkManager.getHttpsURLConnection(endApi);
            MktoUtils.getHeaders(context, true, conn);
            response = MktoNetworkManager.executeHttpRequest(conn, HttpMethodType.FORM_POST, MktoNetworkManager.getParamsAsFormString(values));
        }
        catch (IOException e1) {
            throw new MktoException(IO_EXCEPTION);
        }
        return response.response;
    }

    private static String executeHttpPlainPost(String endApi, String content, Context context) throws MktoException {
        ResponseObject response;
        try {
            HttpsURLConnection conn = MktoNetworkManager.getHttpsURLConnection(endApi);
            MktoUtils.getHeaders(context, true, conn);
            response = MktoNetworkManager.executeHttpRequest(conn, HttpMethodType.PLANE_POST, content);
        }
        catch (IOException e1) {
            throw new MktoException(IO_EXCEPTION);
        }
        return response.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void downloadFile(String endApi, File file) throws Exception, MktoException {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(endApi);
            connection = (HttpsURLConnection)url.openConnection();
            connection.setReadTimeout(Marketo.getNetworkTimeout());
            connection.setConnectTimeout(Marketo.getNetworkTimeout());
            connection.setRequestProperty("User-Agent", "MarketoSDK 0.8.1");
            connection.setRequestProperty("Accept-Charset", "utf-8");
            connection.setDoInput(true);
            connection.setRequestMethod("GET");
            connection.connect();
            if (file != null) {
                int readLength;
                file.createNewFile();
                FileOutputStream out = new FileOutputStream(file.getAbsolutePath());
                InputStream in = connection.getInputStream();
                byte[] buffer = new byte[1024];
                while ((readLength = in.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, readLength);
                }
                out.flush();
                ((OutputStream)out).close();
                in.close();
                if (BitmapFactory.decodeFile((String)file.getAbsolutePath()) == null) {
                    file.delete();
                    throw new MktoException(IMAGE_CURROPTED + file.getName().replaceAll("_", " "));
                }
                MktoUtils.writelog("Downloaded latest version: " + file.getName());
            }
        }
        finally {
            if (null != connection) {
                connection.disconnect();
            }
        }
    }

    public static JSONObject postJSON(String endApi, String post, Context context) throws MktoException {
        if (TextUtils.isEmpty((CharSequence)post) || TextUtils.isEmpty((CharSequence)endApi)) {
            throw new MktoException("Invalid munchkinId or endpoint");
        }
        String serverUrl = MktoNetworkManager.createServerBaseUrl(context);
        String response = MktoNetworkManager.executeHttpPlainPost(serverUrl + endApi, post, context);
        return MktoNetworkManager.parseResponse(response);
    }

    private static JSONObject parseResponse(String response) throws MktoException {
        MktoUtils.writeDebugLog(response);
        try {
            JSONObject json = new JSONObject(response);
            if (json.optBoolean("success", false)) {
                return json;
            }
            if (json.has("error_message")) {
                String error_message = json.getString("error_message");
                throw new MktoException(error_message);
            }
            throw new MktoException("unknown error");
        }
        catch (JSONException e) {
            throw new MktoException(JSON_EXCEPTION);
        }
        catch (Exception e) {
            throw new MktoException("Internal error occurred.");
        }
    }

    private static String getParamsAsFormString(Map<?, ?> parameters) throws UnsupportedEncodingException {
        StringBuilder dataBfr = new StringBuilder();
        for (Object key : parameters.keySet()) {
            Object preliminaryValue;
            if (dataBfr.length() != 0) {
                dataBfr.append('&');
            }
            String value = (preliminaryValue = parameters.get(key)) == null ? "" : preliminaryValue;
            dataBfr.append(URLEncoder.encode(key.toString(), "UTF-8"));
            dataBfr.append('=');
            dataBfr.append(URLEncoder.encode(value.toString(), "UTF-8"));
        }
        return dataBfr.toString();
    }

    private static HttpsURLConnection getHttpsURLConnection(String endApi) {
        try {
            MktoNetworkManager.trustEveryone();
            URL url = new URL(endApi);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            return conn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void trustEveryone() {
        try {
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new X509TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class ResponseObject {
        String response = "";
        int statusCode = 400;

        ResponseObject() {
        }
    }

    private static enum HttpMethodType {
        PLANE_POST,
        FORM_POST,
        GET;

    }
}

