/*
 * Decompiled with CFR 0.152.
 */
package marketo.utils;

import android.os.Environment;
import android.text.TextUtils;
import com.marketo.errors.MktoException;
import java.io.File;
import marketo.utils.MktoNetworkManager;

public class MktoIOManager {
    private static final String ROOT_FOLDER_PATH = Environment.getDataDirectory() + File.separator + "data" + File.separator + "%s" + File.separator + "ImageResource" + File.separator;
    private String applicationID;
    private static MktoIOManager ioManager;

    private MktoIOManager(String applicationID) {
        this.applicationID = applicationID;
    }

    public static MktoIOManager getIOManager(String applicationID) {
        if (ioManager == null) {
            ioManager = new MktoIOManager(applicationID);
        }
        return ioManager;
    }

    public synchronized File getFileFromLocal(String url, String campaign) throws Exception, MktoException {
        File downloadFile = null;
        if (!(TextUtils.isEmpty((CharSequence)url) || TextUtils.isEmpty((CharSequence)String.valueOf(campaign)) || (downloadFile = this.getFile(url, String.valueOf(campaign))) != null && downloadFile.exists())) {
            downloadFile = this.getFileFromServer(url, String.valueOf(campaign));
        }
        return downloadFile;
    }

    public synchronized boolean isFileAvailable(String url, String campaign) {
        if (!TextUtils.isEmpty((CharSequence)url) && !TextUtils.isEmpty((CharSequence)String.valueOf(campaign))) {
            File downloadFile = this.getFile(url, String.valueOf(campaign));
            return downloadFile != null && downloadFile.exists();
        }
        return false;
    }

    private synchronized File getFileFromServer(String url, String campaign) throws Exception, MktoException {
        File downloadFile = this.getFile(url, campaign);
        MktoNetworkManager.downloadFile(url, downloadFile);
        return downloadFile;
    }

    private synchronized File getFile(String url, String campaign) {
        File dir = new File(this.getRootDirPath());
        if (!dir.exists()) {
            dir.mkdir();
        }
        return new File(dir, campaign.replace(" ", "_") + "_" + url.substring(url.lastIndexOf("/") + 1));
    }

    private synchronized String getRootDirPath() {
        return String.format(ROOT_FOLDER_PATH, this.applicationID);
    }

    public void clearAllFilesOfCampaign(String campaignID) {
        File dir = new File(this.getRootDirPath());
        if (dir.exists() && dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (!file.getName().startsWith(String.valueOf(campaignID))) continue;
                file.deleteOnExit();
            }
        }
    }
}

