/*
 * Decompiled with CFR 0.152.
 */
package marketo.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.text.TextUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.UUID;
import marketo.utils.MktoUtils;

public class MktoDeviceIdentifier {
    private static final String MKTO_DEVICE_ID = "mkto.uuid";
    private static final String MKTO_TEST_DEVICE_ID = "mkto.test_device_uuid";
    private static String sID = null;
    private static String testDeviceIdentifier = null;

    private MktoDeviceIdentifier(Context context) {
        if (!TextUtils.isEmpty((CharSequence)sID)) {
            return;
        }
        sID = MktoUtils.readPreference(context, MKTO_DEVICE_ID);
        if (!TextUtils.isEmpty((CharSequence)sID)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)sID)) {
            sID = MktoDeviceIdentifier.createRandomSerial();
            MktoUtils.writePreference(context, MKTO_DEVICE_ID, sID);
        }
    }

    private static String createRandomSerial() {
        return UUID.randomUUID().toString();
    }

    public static String getOrCreateUUID(Context context) {
        MktoDeviceIdentifier zId = new MktoDeviceIdentifier(context);
        MktoUtils.writeDebugLog(zId.get());
        return zId.get();
    }

    public static String getTestDeviceIdentifier(Context mCtx) {
        if (!TextUtils.isEmpty((CharSequence)testDeviceIdentifier)) {
            return testDeviceIdentifier;
        }
        testDeviceIdentifier = MktoUtils.readPreference(mCtx, MKTO_TEST_DEVICE_ID);
        if (!TextUtils.isEmpty((CharSequence)testDeviceIdentifier)) {
            return testDeviceIdentifier;
        }
        testDeviceIdentifier = MktoDeviceIdentifier.getDeviceSerial();
        if (TextUtils.isEmpty((CharSequence)testDeviceIdentifier)) {
            testDeviceIdentifier = MktoDeviceIdentifier.getDeviceId(mCtx);
        }
        if (TextUtils.isEmpty((CharSequence)testDeviceIdentifier)) {
            testDeviceIdentifier = MktoDeviceIdentifier.getBuildSerial(mCtx);
        }
        if (TextUtils.isEmpty((CharSequence)testDeviceIdentifier)) {
            testDeviceIdentifier = MktoDeviceIdentifier.createRandomSerial();
        }
        MktoUtils.writePreference(mCtx, MKTO_TEST_DEVICE_ID, testDeviceIdentifier);
        return testDeviceIdentifier;
    }

    private static String getDeviceSerial() {
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class);
            String s = (String)get.invoke(c, "ro.serialno");
            if (MktoDeviceIdentifier.checkSerial(s)) {
                return MktoUtils.getHash(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String getDeviceId(Context context) {
        String s;
        if (context != null && MktoDeviceIdentifier.checkSerial(s = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id"))) {
            return MktoUtils.getHash(s);
        }
        return null;
    }

    private static String getBuildSerial(Context context) {
        try {
            Class<?> c = Class.forName("android.os.Build");
            Field field = c.getDeclaredField("SERIAL");
            String s = (String)field.get(null);
            if (MktoDeviceIdentifier.checkSerial(s)) {
                return MktoUtils.getHash(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean checkSerial(String s) {
        if (s != null && s.length() >= 4) {
            if (s.equalsIgnoreCase("unknown")) {
                return false;
            }
            if (s.equalsIgnoreCase("9774d56d682e549c")) {
                return false;
            }
            int c0 = 0;
            int counter = 0;
            for (int i = 0; i < s.length(); ++i) {
                int c1 = s.codePointAt(i);
                if (i == 0) {
                    c0 = c1;
                }
                if (c0 != c1) continue;
                ++counter;
            }
            return counter != s.length();
        }
        return false;
    }

    public String get() {
        return sID;
    }
}

