/*
 * Decompiled with CFR 0.152.
 */
package marketo.utils;

import java.util.Timer;
import java.util.TimerTask;

public abstract class FutureRunnable {
    private Timer mTimer;
    private long mDelayMilliseconds;

    public FutureRunnable(long delay) {
        this.mDelayMilliseconds = delay;
    }

    public abstract void run();

    public void scheduleRun() {
        this.cancel();
        this.mTimer = new Timer();
        this.mTimer.schedule((TimerTask)new DelayedTimerTask(), this.mDelayMilliseconds);
    }

    public void cancel() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    private class DelayedTimerTask
    extends TimerTask {
        private DelayedTimerTask() {
        }

        @Override
        public void run() {
            FutureRunnable.this.run();
            FutureRunnable.this.mTimer = null;
        }
    }
}

