/*
 * Decompiled with CFR 0.152.
 */
package marketo.push;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import marketo.utils.MktoUtils;

public class MktoPushUtils {
    public static Intent createExplicitFromImplicitIntent(Context context, Intent implicitIntent) {
        PackageManager pm = context.getPackageManager();
        List resolveInfo = pm.queryIntentServices(implicitIntent, 0);
        if (resolveInfo == null || resolveInfo.size() == 0) {
            return null;
        }
        ComponentName component = null;
        for (ResolveInfo serviceInfo : resolveInfo) {
            String packageName = serviceInfo.serviceInfo.packageName;
            String className = serviceInfo.serviceInfo.name;
            if (TextUtils.isEmpty((CharSequence)packageName) || !packageName.equalsIgnoreCase("com.google.android.gms")) continue;
            component = new ComponentName(packageName, className);
            break;
        }
        if (component == null) {
            return null;
        }
        Intent explicitIntent = new Intent(implicitIntent);
        explicitIntent.setComponent(component);
        return explicitIntent;
    }

    public static void startNotificationChannel(Context context, String channelName) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel mChannel = new NotificationChannel("default", (CharSequence)channelName, 3);
            mChannel.setDescription("Marketo notification ");
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            if (notificationManager != null) {
                notificationManager.createNotificationChannel(mChannel);
            }
        }
    }

    public static void startPushService(Context context, String channelName, String ... projectIds) {
        String projectId = MktoPushUtils.getFlatSenderIds(projectIds);
        if (context == null && TextUtils.isEmpty((CharSequence)projectId)) {
            MktoUtils.writeError("Failed to start FCM registration ");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)channelName)) {
            channelName = "MKTO";
        }
        try {
            MktoPushUtils.startNotificationChannel(context, channelName);
            MktoUtils.writePreference(context, "mkto.sender_id", projectId);
            MktoUtils.writePreference(context, "mkto.channel_name", channelName);
        }
        catch (Exception e) {
            MktoUtils.writeError("Failed to start FCM registration " + e.getMessage());
        }
    }

    private static void firePushService(Context context, String projectId) {
        Intent registrationIntent = new Intent("com.google.android.c2dm.intent.REGISTER");
        registrationIntent.putExtra("app", (Parcelable)PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(), (int)0));
        registrationIntent.putExtra("sender", projectId);
        if (MktoUtils.getVersion() >= 21) {
            Intent explicitIntent = MktoPushUtils.createExplicitFromImplicitIntent(context, registrationIntent);
            if (explicitIntent == null) {
                MktoUtils.writeError("Failed to start push notification service on Android L and above");
                return;
            }
            context.startService(explicitIntent);
        } else {
            context.startService(registrationIntent);
        }
    }

    static String getFlatSenderIds(String ... senderIds) {
        if (senderIds == null || senderIds.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder(senderIds[0]);
        for (int i = 1; i < senderIds.length; ++i) {
            builder.append(',').append(senderIds[i]);
        }
        return builder.toString();
    }

    static boolean checkDevice() {
        int version = MktoUtils.getVersion();
        if (version < 8) {
            MktoUtils.writeError("Device must be at least API Level 8 (instead of " + version + ")");
            return false;
        }
        return true;
    }

    static boolean checkManifestFile(Context context) {
        PackageInfo receiversInfo;
        PackageManager packageManager = context.getPackageManager();
        String packageName = context.getPackageName();
        String permissionName = packageName + ".permission.C2D_MESSAGE";
        try {
            packageManager.getPermissionInfo(permissionName, 4096);
        }
        catch (PackageManager.NameNotFoundException e) {
            MktoUtils.writeWarning("Please check manifest file.Application does not define permission: " + permissionName);
            MktoUtils.writeInfo("Please add following lines to your AndroidManifest.xml file:\n<permission android:name=\"" + packageName + ".permission.C2D_MESSAGE\" android:protectionLevel=\"signature\" />\n<uses-permission android:name=\"" + packageName + ".permission.C2D_MESSAGE\" />");
            return false;
        }
        if (0 != packageManager.checkPermission("com.google.android.c2dm.permission.RECEIVE", packageName)) {
            MktoUtils.writeWarning("Please check manifest file.Application package does not have permission com.google.android.c2dm.permission.RECEIVE");
            MktoUtils.writeInfo("Please add following lines to your AndroidManifest.xml file:\n<uses-permission android:name=\"com.google.android.c2dm.permission.RECEIVE\" />");
            return false;
        }
        if (0 != packageManager.checkPermission("android.permission.INTERNET", packageName)) {
            MktoUtils.writeWarning("Please check manifest file.Application does not define permission: android.permission.INTERNET");
            MktoUtils.writeInfo("Please add following lines to your AndroidManifest.xml file:\n<uses-permission android:name=\"android.permission.INTERNET\" />");
            return false;
        }
        if (MktoUtils.getVersion() < 14 && 0 != packageManager.checkPermission("android.permission.GET_ACCOUNTS", packageName)) {
            MktoUtils.writeWarning("Please check manifest file.Application does not define permission: android.permission.GET_ACCOUNTS");
            MktoUtils.writeInfo("Please add following lines to your AndroidManifest.xml file:\n<uses-permission android:name=\"android.permission.GET_ACCOUNTS\" />");
            return false;
        }
        if (0 != packageManager.checkPermission("android.permission.WAKE_LOCK", packageName)) {
            MktoUtils.writeWarning("Please check manifest file.Application does not define permission: android.permission.WAKE_LOCK");
            MktoUtils.writeInfo("Please add following lines to your AndroidManifest.xml file:\n<uses-permission android:name=\"android.permission.WAKE_LOCK\" />");
            return false;
        }
        try {
            receiversInfo = packageManager.getPackageInfo(packageName, 2);
        }
        catch (PackageManager.NameNotFoundException e) {
            MktoUtils.writeError("Could not get receivers for package " + packageName);
            return false;
        }
        ActivityInfo[] receivers = receiversInfo.receivers;
        if (receivers == null || receivers.length == 0) {
            MktoUtils.writeWarning("No receiver found for the package " + packageName);
            MktoUtils.writeInfo("Please add following lines to your AndroidManifest.xml file:\n" + MktoPushUtils.pushConfiguration(packageName));
            MktoUtils.writeError("No receiver for package " + packageName);
            return false;
        }
        HashSet<String> allowedReceivers = new HashSet<String>();
        for (ActivityInfo receiver : receivers) {
            if (!"com.google.android.c2dm.permission.SEND".equals(receiver.permission)) continue;
            allowedReceivers.add(receiver.name);
        }
        if (allowedReceivers.isEmpty()) {
            MktoUtils.writeWarning("No receiver allowed to receive com.google.android.c2dm.permission.SEND");
            MktoUtils.writeInfo("Please add following lines to your AndroidManifest.xml file:\n" + MktoPushUtils.pushConfiguration(packageName));
            return false;
        }
        return MktoPushUtils.checkReceiver(context, allowedReceivers, "com.google.android.c2dm.intent.REGISTRATION") && MktoPushUtils.checkReceiver(context, allowedReceivers, "com.google.android.c2dm.intent.RECEIVE");
    }

    public static boolean isPushReady(Context context) {
        if (!MktoPushUtils.checkDevice()) {
            return false;
        }
        return MktoPushUtils.checkManifestFile(context);
    }

    private static boolean checkReceiver(Context context, Set<String> allowedReceivers, String action) {
        PackageManager pm = context.getPackageManager();
        String packageName = context.getPackageName();
        Intent intent = new Intent(action);
        intent.setPackage(packageName);
        List receivers = pm.queryBroadcastReceivers(intent, 32);
        if (receivers.isEmpty()) {
            MktoUtils.writeWarning("No receivers for action " + action);
            MktoUtils.writeInfo("Please add following lines to your AndroidManifest.xml file:\n" + MktoPushUtils.pushConfiguration(packageName));
            return false;
        }
        for (ResolveInfo receiver : receivers) {
            String name = receiver.activityInfo.name;
            if (allowedReceivers.contains(name)) continue;
            MktoUtils.writeError("Receiver " + name + " is not set with permission com.google.android.c2dm.permission.SEND");
            MktoUtils.writeError("Please add the attribute 'android:permission=\"com.google.android.c2dm.permission.SEND\"' to your <receiver> tag");
            return false;
        }
        return true;
    }

    private static String pushConfiguration(String packageName) {
        return "<receiver android:name=\"com.marketo.MarketoBroadcastReceiver\"\n          android:permission=\"com.google.android.c2dm.permission.SEND\" >\n   <intent-filter>\n       <action android:name=\"com.google.android.c2dm.intent.RECEIVE\" />\n       <action android:name=\"com.google.android.c2dm.intent.REGISTRATION\" />\n       <category android:name=\"" + packageName + "\" />\n    </intent-filter>\n</receiver>\n<service android:name=\"com.marketo.MarketoIntentService\" />";
    }
}

